/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.grpc.server.flowcontrol.FlowControlRejectExecutionListener;
import com.navercorp.pinpoint.grpc.server.flowcontrol.IdleTimeout;
import com.navercorp.pinpoint.grpc.server.flowcontrol.IdleTimeoutFactory;
import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListener;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ServerCallWrapper;
import com.navercorp.pinpoint.grpc.server.flowcontrol.SimpleRejectedExecutionListener;
import java.util.Objects;

public class RejectedExecutionListenerFactory {
    private static final int REQUEST_IMMEDIATELY = -1;
    private final String name;
    private final long recoveryMessagesCount;
    private final IdleTimeoutFactory idleTimeoutFactory;

    public RejectedExecutionListenerFactory(String name, long recoveryMessagesCount, IdleTimeoutFactory idleTimeoutFactory) {
        this.name = Objects.requireNonNull(name, "name");
        this.recoveryMessagesCount = recoveryMessagesCount;
        this.idleTimeoutFactory = Objects.requireNonNull(idleTimeoutFactory, "idleTimeoutFactory");
    }

    public RejectedExecutionListener newListener(ServerCallWrapper serverCall) {
        IdleTimeout idleTimeout = this.idleTimeoutFactory.newIdleTimeout();
        if (this.recoveryMessagesCount == -1L) {
            return new SimpleRejectedExecutionListener(this.name, serverCall, idleTimeout);
        }
        return new FlowControlRejectExecutionListener(this.name, serverCall, this.recoveryMessagesCount, idleTimeout);
    }
}

