/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject<PrimitiveFloatArraySubject, float[]> {
    PrimitiveFloatArraySubject(FailureStrategy failureStrategy, @Nullable float[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "float";
    }

    @Override
    protected List<Float> listRepresentation() {
        return Floats.asList((float[])((float[])this.actual()));
    }

    @Override
    @Deprecated
    public void isEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of floats is unsafe, use isEqualTo(float[] array, float tolerance) instead.");
    }

    @Deprecated
    public void isEqualTo(Object expected, float tolerance) {
        float[] actual = (float[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            float[] expectedArray = (float[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Floats.asList((float[])expectedArray), Floats.asList((float[])actual));
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Floats.asList((float[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    @Deprecated
    public void isNotEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of floats is unsafe, use isNotEqualTo(float[] array, float tolerance) instead.");
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, float tolerance) {
        float[] actual = (float[])this.actual();
        try {
            float[] expected = (float[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Floats.asList((float[])expected));
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Floats.asList((float[])expected));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public TolerantPrimitiveFloatArrayComparison hasValuesWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveFloatArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveFloatArraySubject.this.actualAsString(), Float.valueOf(tolerance), Iterables.toString(expected), expectedCount, actual.length);
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveFloatArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveFloatArrayComparison hasValuesNotWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveFloatArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public IterableSubject.UsingCorrespondence<Number, Number> withTolerance(float tolerance) {
        return new IterableSubject(this.failureStrategy, (Iterable<?>)this.listRepresentation()).comparingElementsUsing(Correspondence.tolerance(tolerance));
    }

    public static abstract class TolerantPrimitiveFloatArrayComparison {
        private TolerantPrimitiveFloatArrayComparison() {
        }

        public void of(float ... expected) {
            this.ofElementsIn(Floats.asList((float[])expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare float arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

