/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.trace;

import com.navercorp.pinpoint.common.profiler.trace.AnnotationKeyMatcherRegistry;
import com.navercorp.pinpoint.common.profiler.trace.AnnotationKeyRegistry;
import com.navercorp.pinpoint.common.profiler.trace.DefaultDisplayArgument;
import com.navercorp.pinpoint.common.profiler.trace.DisplayArgumentMatcher;
import com.navercorp.pinpoint.common.profiler.trace.ServiceTypeRegistry;
import com.navercorp.pinpoint.common.profiler.trace.StaticFieldLookUp;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcher;
import com.navercorp.pinpoint.common.trace.DefaultServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.TraceMetadataProvider;
import com.navercorp.pinpoint.common.trace.TraceMetadataSetupContext;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TraceMetadataLoader {
    private final CommonLogger logger;
    private final List<ServiceType> staticServiceTypes;
    private final List<AnnotationKey> staticAnnotationKeys;
    private final List<DisplayArgumentMatcher> staticDisplayArgumentMatchers;
    private final List<ServiceTypeInfo> serviceTypeInfos = new ArrayList<ServiceTypeInfo>();
    private final ServiceTypeChecker serviceTypeChecker = new ServiceTypeChecker();
    private final List<AnnotationKey> annotationKeys = new ArrayList<AnnotationKey>();
    private final AnnotationKeyChecker annotationKeyChecker = new AnnotationKeyChecker();

    public TraceMetadataLoader(CommonLoggerFactory loggerFactory) {
        Objects.requireNonNull(loggerFactory, "loggerFactory");
        this.logger = loggerFactory.getLogger(TraceMetadataLoader.class.getName());
        this.staticServiceTypes = this.staticFieldLookUp(ServiceType.class, ServiceType.class);
        this.staticAnnotationKeys = this.staticFieldLookUp(AnnotationKey.class, AnnotationKey.class);
        this.staticDisplayArgumentMatchers = this.staticFieldLookUp(DefaultDisplayArgument.class, DisplayArgumentMatcher.class);
    }

    private <T> List<T> staticFieldLookUp(Class<?> targetClazz, Class<T> lookUpClazz) {
        StaticFieldLookUp<T> staticFieldLookUp = new StaticFieldLookUp<T>(targetClazz, lookUpClazz);
        return Collections.unmodifiableList(staticFieldLookUp.lookup());
    }

    public void load(List<TraceMetadataProvider> providers) {
        Objects.requireNonNull(providers, "providers");
        this.logger.info("Loading TraceMetadataProviders");
        for (TraceMetadataProvider provider : providers) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading TraceMetadataProvider: " + provider.getClass().getName() + " from:" + provider);
            }
            TraceMetadataSetupContextImpl context = new TraceMetadataSetupContextImpl(provider);
            provider.setup((TraceMetadataSetupContext)context);
        }
        this.serviceTypeChecker.logResult();
        this.annotationKeyChecker.logResult();
    }

    public ServiceTypeRegistry createServiceTypeRegistry() {
        this.logInfo("creating ServiceTypeRegistry");
        ServiceTypeRegistry.Builder builder = new ServiceTypeRegistry.Builder();
        for (ServiceType serviceType : this.staticServiceTypes) {
            this.logInfo("add Default ServiceType:" + serviceType.getName());
            builder.addServiceType(serviceType);
        }
        for (ServiceTypeInfo serviceTypeInfo : this.serviceTypeInfos) {
            ServiceType serviceType = serviceTypeInfo.getServiceType();
            this.logInfo("add Plugin ServiceType:" + serviceType.getName());
            builder.addServiceType(serviceType);
        }
        return builder.build();
    }

    public AnnotationKeyRegistry createAnnotationKeyRegistry() {
        this.logInfo("creating AnnotationKeyRegistry");
        AnnotationKeyRegistry.Builder builder = new AnnotationKeyRegistry.Builder();
        for (AnnotationKey annotationKey : this.staticAnnotationKeys) {
            this.logInfo("add Default AnnotationKey:" + annotationKey);
            builder.addAnnotationKey(annotationKey);
        }
        for (AnnotationKey annotationKey : this.annotationKeys) {
            this.logInfo("add PluginAnnotationKey:" + annotationKey);
            builder.addAnnotationKey(annotationKey);
        }
        return builder.build();
    }

    public AnnotationKeyMatcherRegistry createAnnotationKeyMatcherRegistry() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("creating AnnotationKeyMatcherRegistry");
        }
        AnnotationKeyMatcherRegistry.Builder builder = new AnnotationKeyMatcherRegistry.Builder();
        for (DisplayArgumentMatcher displayArgumentMatcher : this.staticDisplayArgumentMatchers) {
            AnnotationKeyMatcher annotationKeyMatcher = displayArgumentMatcher.getAnnotationKeyMatcher();
            if (annotationKeyMatcher == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("add DefaultAnnotationKeyMatcher ServiceType:" + displayArgumentMatcher.getServiceType() + ", AnnotationKeyMatcher:" + annotationKeyMatcher);
            }
            builder.addAnnotationKeyMatcher(displayArgumentMatcher.getServiceType(), annotationKeyMatcher);
        }
        for (ServiceTypeInfo serviceTypeInfo : this.serviceTypeInfos) {
            if (serviceTypeInfo.getPrimaryAnnotationKeyMatcher() == null) continue;
            ServiceType serviceType = serviceTypeInfo.getServiceType();
            AnnotationKeyMatcher primaryAnnotationKeyMatcher = serviceTypeInfo.getPrimaryAnnotationKeyMatcher();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("add AnnotationKeyMatcher ServiceType:" + serviceType + ", AnnotationKeyMatcher:" + primaryAnnotationKeyMatcher);
            }
            builder.addAnnotationKeyMatcher(serviceType, primaryAnnotationKeyMatcher);
        }
        return builder.build();
    }

    private void logInfo(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    private static String serviceTypePairToString(Pair<ServiceType> pair) {
        return ((ServiceType)((Pair)pair).value).getName() + "(" + ((ServiceType)((Pair)pair).value).getCode() + ") from " + ((Pair)pair).provider.toString();
    }

    private static String annotationKeyPairToString(Pair<AnnotationKey> pair) {
        return ((AnnotationKey)((Pair)pair).value).getName() + "(" + ((AnnotationKey)((Pair)pair).value).getCode() + ") from " + ((Pair)pair).provider.toString();
    }

    private class AnnotationKeyChecker {
        private final Map<Integer, Pair<AnnotationKey>> annotationKeyCodeMap = new HashMap<Integer, Pair<AnnotationKey>>();

        private AnnotationKeyChecker() {
        }

        private void check(AnnotationKey key, TraceMetadataProvider provider) {
            Pair<AnnotationKey> pair = new Pair<AnnotationKey>(key, provider);
            Pair<AnnotationKey> prev = this.annotationKeyCodeMap.put(key.getCode(), pair);
            if (prev != null) {
                throw new RuntimeException("AnnotationKey code of " + TraceMetadataLoader.annotationKeyPairToString(pair) + " is duplicated with " + TraceMetadataLoader.annotationKeyPairToString(prev));
            }
        }

        private void logResult() {
            TraceMetadataLoader.this.logger.info("Finished loading AnnotationKeys:");
            ArrayList<Pair<AnnotationKey>> annotationKeys = new ArrayList<Pair<AnnotationKey>>(this.annotationKeyCodeMap.values());
            Collections.sort(annotationKeys, new Comparator<Pair<AnnotationKey>>(){

                @Override
                public int compare(Pair<AnnotationKey> o1, Pair<AnnotationKey> o2) {
                    int code1 = ((AnnotationKey)((Pair)o1).value).getCode();
                    int code2 = ((AnnotationKey)((Pair)o2).value).getCode();
                    return Integer.compare(code1, code2);
                }
            });
            for (Pair pair : annotationKeys) {
                TraceMetadataLoader.this.logger.info(TraceMetadataLoader.annotationKeyPairToString(pair));
            }
        }
    }

    private class ServiceTypeChecker {
        private final Map<String, Pair<ServiceType>> serviceTypeNameMap = new HashMap<String, Pair<ServiceType>>();
        private final Map<Short, Pair<ServiceType>> serviceTypeCodeMap = new HashMap<Short, Pair<ServiceType>>();

        private ServiceTypeChecker() {
        }

        private void check(ServiceType type, TraceMetadataProvider provider) {
            Pair<ServiceType> pair = new Pair<ServiceType>(type, provider);
            Pair<ServiceType> prev = this.serviceTypeNameMap.put(type.getName(), pair);
            if (prev != null) {
                throw new RuntimeException("ServiceType name of " + TraceMetadataLoader.serviceTypePairToString(pair) + " is duplicated with " + TraceMetadataLoader.serviceTypePairToString(prev));
            }
            prev = this.serviceTypeCodeMap.put(type.getCode(), pair);
            if (prev != null) {
                throw new RuntimeException("ServiceType code of " + TraceMetadataLoader.serviceTypePairToString(pair) + " is duplicated with " + TraceMetadataLoader.serviceTypePairToString(prev));
            }
            if (type.isAlias()) {
                if (!type.isRpcClient()) {
                    throw new RuntimeException("ServiceType code of " + TraceMetadataLoader.serviceTypePairToString(pair) + " should be between range of RPC");
                }
                if (type.isRecordStatistics()) {
                    throw new RuntimeException("ServiceType code of " + TraceMetadataLoader.serviceTypePairToString(pair) + " can't have ALIAS and RECORD_STATISTICS at the same time");
                }
            }
        }

        private void logResult() {
            TraceMetadataLoader.this.logger.info("Finished loading ServiceType:");
            ArrayList<Pair<ServiceType>> serviceTypes = new ArrayList<Pair<ServiceType>>(this.serviceTypeCodeMap.values());
            Collections.sort(serviceTypes, new Comparator<Pair<ServiceType>>(){

                @Override
                public int compare(Pair<ServiceType> o1, Pair<ServiceType> o2) {
                    short code1 = ((ServiceType)((Pair)o1).value).getCode();
                    short code2 = ((ServiceType)((Pair)o2).value).getCode();
                    return Integer.compare(code1, code2);
                }
            });
            for (Pair pair : serviceTypes) {
                TraceMetadataLoader.this.logger.info(TraceMetadataLoader.serviceTypePairToString(pair));
            }
        }
    }

    private static class Pair<T> {
        private final T value;
        private final TraceMetadataProvider provider;

        public Pair(T value, TraceMetadataProvider provider) {
            this.value = value;
            this.provider = provider;
        }
    }

    private class TraceMetadataSetupContextImpl
    implements TraceMetadataSetupContext {
        private final TraceMetadataProvider provider;

        public TraceMetadataSetupContextImpl(TraceMetadataProvider provider) {
            this.provider = provider;
        }

        public void addServiceType(ServiceType serviceType) {
            Objects.requireNonNull(serviceType, "serviceType");
            DefaultServiceTypeInfo type = new DefaultServiceTypeInfo(serviceType);
            this.addType0((ServiceTypeInfo)type);
        }

        public void addServiceType(ServiceType serviceType, AnnotationKeyMatcher annotationKeyMatcher) {
            Objects.requireNonNull(serviceType, "serviceType");
            Objects.requireNonNull(annotationKeyMatcher, "annotationKeyMatcher");
            DefaultServiceTypeInfo type = new DefaultServiceTypeInfo(serviceType, annotationKeyMatcher);
            this.addType0((ServiceTypeInfo)type);
        }

        private void addType0(ServiceTypeInfo type) {
            Objects.requireNonNull(type, "type");
            TraceMetadataLoader.this.serviceTypeChecker.check(type.getServiceType(), this.provider);
            TraceMetadataLoader.this.serviceTypeInfos.add(type);
        }

        public void addAnnotationKey(AnnotationKey annotationKey) {
            Objects.requireNonNull(annotationKey, "annotationKey");
            TraceMetadataLoader.this.annotationKeyChecker.check(annotationKey, this.provider);
            TraceMetadataLoader.this.annotationKeys.add(annotationKey);
        }
    }
}

