/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.maxabsscaler.MaxAbsScaler;
import org.apache.flink.ml.feature.maxabsscaler.MaxAbsScalerModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class MaxAbsScalerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 3.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{2.1, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{4.1, 5.1})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{6.1, 8.1})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{200.0, 400.0})})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("input", new String[0]);
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{150.0, 90.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{50.0, 40.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{100.0, 50.0})})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("input", new String[0]);
        MaxAbsScaler maxAbsScaler = new MaxAbsScaler();
        MaxAbsScalerModel maxAbsScalerModel = maxAbsScaler.fit(new Table[]{trainTable});
        Table outputTable = maxAbsScalerModel.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector inputValue = (DenseVector)row.getField(maxAbsScaler.getInputCol());
            DenseVector outputValue = (DenseVector)row.getField(maxAbsScaler.getOutputCol());
            System.out.printf("Input Value: %-15s\tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

