/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Functions;
import org.apache.geode.cache.query.internal.Support;

public class CompiledFunction
extends AbstractCompiledValue {
    private final CompiledValue[] _args;
    private final int _function;

    public CompiledFunction(CompiledValue[] args, int function) {
        this._args = args;
        this._function = function;
    }

    @Override
    public List getChildren() {
        return Arrays.asList(this._args);
    }

    @Override
    public int getType() {
        return -2;
    }

    public int getFunction() {
        return this._function;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this._function == 105) {
            Object arg = this._args[0].evaluate(context);
            return this.call(arg, context);
        }
        if (this._function == 107) {
            return Functions.nvl(this._args[0], this._args[1], context);
        }
        if (this._function == 108) {
            return Functions.to_date(this._args[0], this._args[1], context);
        }
        throw new QueryInvalidException("UnSupported function was used in the query");
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        int len = this._args.length;
        for (CompiledValue arg : this._args) {
            context.addDependencies(this, arg.computeDependencies(context));
        }
        return context.getDependencySet(this, true);
    }

    private Object call(Object arg, ExecutionContext context) throws FunctionDomainException, TypeMismatchException {
        Support.Assert(this._function == 105);
        return Functions.element(arg, context);
    }

    public CompiledValue[] getArguments() {
        return this._args;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuilder clauseBuffer, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ')');
        int len = this._args.length;
        for (int i = len - 1; i > 0; --i) {
            this._args[i].generateCanonicalizedExpression(clauseBuffer, context);
            clauseBuffer.insert(0, ',');
        }
        this._args[0].generateCanonicalizedExpression(clauseBuffer, context);
        switch (this._function) {
            case 107: {
                clauseBuffer.insert(0, "NVL(");
                break;
            }
            case 105: {
                clauseBuffer.insert(0, "ELEMENT(");
                break;
            }
            case 108: {
                clauseBuffer.insert(0, "TO_DATE(");
                break;
            }
            default: {
                super.generateCanonicalizedExpression(clauseBuffer, context);
            }
        }
    }
}

