/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.geode.GemFireIOException;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.internal.DistributedSystemConfigImpl;
import org.apache.geode.admin.internal.InetAddressUtils;
import org.apache.geode.admin.internal.InetAddressUtilsWithLogging;
import org.apache.geode.admin.jmx.Agent;
import org.apache.geode.admin.jmx.AgentConfig;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.util.IOUtils;

@Deprecated
public class AgentConfigImpl
extends DistributedSystemConfigImpl
implements AgentConfig {
    public static final String AGENT_DEBUG = "agent-debug";
    public static final String PROPERTY_FILE_NAME = "property-file";
    public static final String AGENT_PROPSFILE_PROPERTY_NAME = "gfAgentPropertyFile";
    public static final String LOCATOR_HOST_NAME = "locator.host-";
    public static final String LOCATOR_PORT_NAME = "locator.port-";
    public static final String LOCATOR_PRODUCT_DIRECTORY_NAME = "locator.product-directory-";
    public static final String LOCATOR_WORKING_DIRECTORY_NAME = "locator.working-directory-";
    public static final String LOCATOR_REMOTE_COMMAND = "locator.remote-command-";
    public static final String LOCATOR_BIND_ADDRESS = "locator.bind-address-";
    public static final String LOCATOR_DS_PROPERTIES = "locator.ds-properties";
    static final String DEFAULT_LOG_FILE = "agent.log";
    static final String DEFAULT_STARTUP_LOG_FILE = "start_agent.log";
    private static final String OBFUSCATED_STRING = "********";
    private boolean autoConnect;
    private boolean agentSSLEnabled;
    private String agentSSLProtocols;
    private String agentSSLCiphers;
    private boolean agentSSLRequireAuth;
    private boolean httpSSLRequireAuth;
    private boolean httpAuthEnabled;
    private String httpAuthUser;
    private String httpAuthPassword;
    private boolean httpEnabled;
    private int httpPort;
    private String httpBindAddress;
    private boolean rmiEnabled;
    private boolean rmiRegistryEnabled;
    private String rmiBindAddress;
    private int rmiPort;
    private int rmiServerPort;
    private boolean snmpEnabled;
    private String snmpBindAddress;
    private String snmpDirectory;
    private boolean isEmailNotificationEnabled;
    private String emailNotificationFrom;
    private String emailNotificationHostName;
    private String emailNotificationToList;
    private String stateSaveFile;
    private final URL url;
    private String[] originalCmdLineArgs = null;
    private Agent agent;
    private boolean sslEnabled = false;
    private String sslProtocols = "any";
    private String sslCiphers = "any";
    private boolean sslAuthenticationRequired = true;
    private Properties sslProperties = new Properties();

    static String retrievePropertyFile() {
        return System.getProperty(AGENT_PROPSFILE_PROPERTY_NAME, "agent.properties");
    }

    private static Properties getDefaultProperties() {
        Properties props = new Properties();
        props.setProperty("auto-connect", String.valueOf(true));
        props.setProperty("http-enabled", String.valueOf(true));
        props.setProperty("http-bind-address", "");
        props.setProperty("http-port", String.valueOf(8080));
        props.setProperty("http-authentication-enabled", String.valueOf(false));
        props.setProperty("http-authentication-user", "admin");
        props.setProperty("http-authentication-password", "password");
        props.setProperty("rmi-enabled", String.valueOf(true));
        props.setProperty("rmi-registry-enabled", String.valueOf(true));
        props.setProperty("rmi-bind-address", "");
        props.setProperty("rmi-port", String.valueOf(1099));
        props.setProperty("rmi-server-port", String.valueOf(0));
        props.setProperty("snmp-enabled", String.valueOf(false));
        props.setProperty("snmp-directory", "");
        props.setProperty("agent-ssl-enabled", String.valueOf(false));
        props.setProperty("agent-ssl-protocols", "any");
        props.setProperty("agent-ssl-ciphers", "any");
        props.setProperty("agent-ssl-require-authentication", String.valueOf(true));
        props.setProperty("http-ssl-require-authentication", String.valueOf(false));
        return props;
    }

    static Properties getDefaultValuesForAllProperties() {
        Properties props = new Properties();
        props.setProperty("auto-connect", String.valueOf(true));
        props.setProperty("http-enabled", String.valueOf(true));
        props.setProperty("http-bind-address", "");
        props.setProperty("http-port", String.valueOf(8080));
        props.setProperty("http-authentication-enabled", String.valueOf(false));
        props.setProperty("http-authentication-user", "admin");
        props.setProperty("http-authentication-password", "password");
        props.setProperty("rmi-enabled", String.valueOf(true));
        props.setProperty("rmi-registry-enabled", String.valueOf(true));
        props.setProperty("rmi-bind-address", "");
        props.setProperty("rmi-port", String.valueOf(1099));
        props.setProperty("rmi-server-port", String.valueOf(0));
        props.setProperty("snmp-enabled", String.valueOf(false));
        props.setProperty("snmp-directory", "");
        props.setProperty("agent-ssl-enabled", String.valueOf(false));
        props.setProperty("agent-ssl-protocols", "any");
        props.setProperty("agent-ssl-ciphers", "any");
        props.setProperty("agent-ssl-require-authentication", String.valueOf(true));
        props.setProperty("http-ssl-require-authentication", String.valueOf(false));
        props.setProperty("snmp-bind-address", "");
        props.setProperty("email-notification-enabled", String.valueOf(false));
        props.setProperty("email-notification-host", "");
        props.setProperty("email-notification-from", "");
        props.setProperty("email-notification-to", "");
        props.setProperty("state-save-file", "agent.ser");
        props.setProperty("cluster-ssl-enabled", String.valueOf(false));
        props.setProperty("cluster-ssl-protocols", "any");
        props.setProperty("cluster-ssl-ciphers", "any");
        props.setProperty("cluster-ssl-require-authentication", String.valueOf(true));
        props.setProperty("entity-config-xml-file", "distributed-system.xml");
        props.setProperty("mcast-port", String.valueOf(0));
        props.setProperty("mcast-address", String.valueOf(DEFAULT_MCAST_ADDRESS));
        props.setProperty("locators", "");
        props.setProperty("bind-address", "");
        props.setProperty("remote-command", "rsh -n {HOST} {CMD}");
        props.setProperty("log-file", DEFAULT_LOG_FILE);
        props.setProperty("log-level", "config");
        props.setProperty("log-disk-space-limit", String.valueOf(0));
        props.setProperty("log-file-size-limit", String.valueOf(0));
        props.setProperty("refresh-interval", String.valueOf(15));
        return props;
    }

    public AgentConfigImpl() {
        this(AgentConfigImpl.getDefaultProperties());
    }

    public AgentConfigImpl(String[] args) {
        this(AgentConfigImpl.toProperties(args));
        this.originalCmdLineArgs = args;
    }

    public AgentConfigImpl(Properties props) {
        super(AgentConfigImpl.filterOutAgentProperties(AgentConfigImpl.appendOptionalPropertyFileProperties(props)), true);
        this.url = AgentConfigImpl.getPropertyFileURL(AgentConfigImpl.retrievePropertyFile());
        this.initialize(AgentConfigImpl.appendOptionalPropertyFileProperties(props));
    }

    public AgentConfigImpl(File propFile) {
        this();
        Properties props = new Properties();
        if (propFile.exists()) {
            try {
                FileInputStream in = new FileInputStream(propFile);
                props.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new GemFireIOException(String.format("Failed reading %s", propFile), e);
            }
        } else {
            throw new IllegalArgumentException(String.format("Specified properties file does not exist: %s", propFile));
        }
        this.initialize(props);
    }

    void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    protected void checkReadOnly() {
        if (this.agent != null) {
            throw new IllegalStateException("An AgentConfig object cannot be modified after it has been used to create an Agent.");
        }
        super.checkReadOnly();
    }

    public String getPropertyFileDescription() {
        if (this.url == null) {
            return "Using default configuration because property file was not found.";
        }
        return String.format("Configuration loaded from: %s.", this.url);
    }

    public File getPropertyFile() {
        File f;
        if (this.url == null) {
            f = new File(AgentConfigImpl.retrievePropertyFile());
            if (!f.isAbsolute()) {
                f = new File(System.getProperty("user.dir"), AgentConfigImpl.retrievePropertyFile());
            }
        } else {
            f = new File(this.url.getFile());
        }
        return f;
    }

    public String toPropertiesAsString() {
        Properties p = this.toProperties(true);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Agent Configuration:");
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String pn = (String)e.nextElement();
            String pv = p.getProperty(pn);
            pw.println("  " + pn + " = " + pv);
        }
        pw.close();
        return sw.toString();
    }

    public Properties toProperties() {
        return this.toProperties(false);
    }

    public Properties toProperties(boolean includeDSProperties) {
        Properties props = new Properties();
        props.setProperty("auto-connect", AgentConfigImpl.toString("auto-connect", this.getAutoConnect()));
        props.setProperty("http-enabled", AgentConfigImpl.toString("http-enabled", this.isHttpEnabled()));
        props.setProperty("http-bind-address", AgentConfigImpl.toString("http-bind-address", this.getHttpBindAddress()));
        props.setProperty("http-port", AgentConfigImpl.toString("http-port", this.getHttpPort()));
        props.setProperty("rmi-enabled", AgentConfigImpl.toString("rmi-enabled", this.isRmiEnabled()));
        props.setProperty("rmi-registry-enabled", AgentConfigImpl.toString("rmi-registry-enabled", this.isRmiRegistryEnabled()));
        props.setProperty("rmi-bind-address", AgentConfigImpl.toString("rmi-bind-address", this.getRmiBindAddress()));
        props.setProperty("rmi-port", AgentConfigImpl.toString("rmi-port", this.getRmiPort()));
        props.setProperty("rmi-server-port", AgentConfigImpl.toString("rmi-server-port", this.getRmiServerPort()));
        props.setProperty("snmp-enabled", AgentConfigImpl.toString("snmp-enabled", this.isSnmpEnabled()));
        props.setProperty("snmp-bind-address", AgentConfigImpl.toString("snmp-bind-address", this.getSnmpBindAddress()));
        props.setProperty("snmp-directory", AgentConfigImpl.toString("snmp-directory", this.getSnmpDirectory()));
        props.setProperty("agent-ssl-enabled", AgentConfigImpl.toString("agent-ssl-enabled", this.isAgentSSLEnabled()));
        props.setProperty("agent-ssl-protocols", AgentConfigImpl.toString("agent-ssl-protocols", this.getAgentSSLProtocols()));
        props.setProperty("agent-ssl-ciphers", AgentConfigImpl.toString("agent-ssl-ciphers", this.getAgentSSLCiphers()));
        props.setProperty("agent-ssl-require-authentication", AgentConfigImpl.toString("agent-ssl-require-authentication", this.isAgentSSLRequireAuth()));
        props.setProperty("http-ssl-require-authentication", AgentConfigImpl.toString("http-ssl-require-authentication", this.isHttpSSLRequireAuth()));
        props.setProperty("http-authentication-enabled", AgentConfigImpl.toString("http-authentication-enabled", this.isHttpAuthEnabled()));
        props.setProperty("http-authentication-user", AgentConfigImpl.toString("http-authentication-user", this.getHttpAuthUser()));
        props.setProperty("http-authentication-password", AgentConfigImpl.toString("http-authentication-password", this.getHttpAuthPassword()));
        props.setProperty("email-notification-enabled", AgentConfigImpl.toString("email-notification-enabled", this.isEmailNotificationEnabled()));
        props.setProperty("email-notification-host", AgentConfigImpl.toString("email-notification-host", this.getEmailNotificationHost()));
        props.setProperty("email-notification-from", AgentConfigImpl.toString("email-notification-from", this.getEmailNotificationFrom()));
        props.setProperty("email-notification-to", AgentConfigImpl.toString("email-notification-to", this.getEmailNotificationToList()));
        props.setProperty("state-save-file", AgentConfigImpl.toString("state-save-file", this.getStateSaveFile()));
        props.setProperty("email-notification-enabled", AgentConfigImpl.toString("email-notification-enabled", this.isEmailNotificationEnabled()));
        props.setProperty("email-notification-host", AgentConfigImpl.toString("email-notification-host", this.getEmailNotificationHost()));
        props.setProperty("email-notification-from", AgentConfigImpl.toString("email-notification-from", this.getEmailNotificationFrom()));
        props.setProperty("email-notification-to", AgentConfigImpl.toString("email-notification-to", this.getEmailNotificationToList()));
        props.setProperty("cluster-ssl-enabled", AgentConfigImpl.toString("cluster-ssl-enabled", this.isSSLEnabled()));
        props.setProperty("cluster-ssl-protocols", AgentConfigImpl.toString("cluster-ssl-protocols", this.getSSLProtocols()));
        props.setProperty("cluster-ssl-ciphers", AgentConfigImpl.toString("cluster-ssl-ciphers", this.getSSLCiphers()));
        props.setProperty("cluster-ssl-require-authentication", AgentConfigImpl.toString("cluster-ssl-require-authentication", this.isSSLAuthenticationRequired()));
        Properties sslProps = this.getSSLProperties();
        if (sslProps.size() > 0) {
            int sequence = 0;
            for (Object o : sslProps.keySet()) {
                String key = (String)o;
                String value = sslProps.getProperty(key);
                props.setProperty("ssl-property-" + sequence, key + "=" + OBFUSCATED_STRING);
                ++sequence;
            }
        }
        if (this.getDistributionLocatorConfigs().length > 0) {
            DistributionLocatorConfig[] configs = this.getDistributionLocatorConfigs();
            for (int i = 0; i < configs.length; ++i) {
                DistributionLocatorConfig locator = configs[i];
                props.setProperty(LOCATOR_HOST_NAME + i, AgentConfigImpl.toString(LOCATOR_HOST_NAME, locator.getHost()));
                props.setProperty(LOCATOR_PORT_NAME + i, AgentConfigImpl.toString(LOCATOR_PORT_NAME, locator.getPort()));
                props.setProperty(LOCATOR_PRODUCT_DIRECTORY_NAME + i, AgentConfigImpl.toString(LOCATOR_PRODUCT_DIRECTORY_NAME, locator.getProductDirectory()));
                props.setProperty(LOCATOR_WORKING_DIRECTORY_NAME + i, AgentConfigImpl.toString(LOCATOR_WORKING_DIRECTORY_NAME, locator.getWorkingDirectory()));
                props.setProperty(LOCATOR_REMOTE_COMMAND + i, AgentConfigImpl.toString(LOCATOR_REMOTE_COMMAND, locator.getRemoteCommand()));
                props.setProperty(LOCATOR_BIND_ADDRESS + i, AgentConfigImpl.toString(LOCATOR_BIND_ADDRESS, locator.getBindAddress()));
            }
        }
        if (includeDSProperties) {
            props.setProperty("entity-config-xml-file", AgentConfigImpl.toString("entity-config-xml-file", this.getEntityConfigXMLFile()));
            props.setProperty("mcast-port", AgentConfigImpl.toString("mcast-port", this.getMcastPort()));
            props.setProperty("mcast-address", AgentConfigImpl.toString("mcast-address", this.getMcastAddress()));
            props.setProperty("locators", AgentConfigImpl.toString("locators", this.getLocators()));
            props.setProperty("membership-port-range", this.getMembershipPortRange());
            props.setProperty("tcp-port", "" + this.getTcpPort());
            props.setProperty("bind-address", AgentConfigImpl.toString("bind-address", this.getBindAddress()));
            props.setProperty("remote-command", AgentConfigImpl.toString("remote-command", this.getRemoteCommand()));
            props.setProperty("log-file", AgentConfigImpl.toString("log-file", this.getLogFile()));
            props.setProperty("log-level", AgentConfigImpl.toString("log-level", this.getLogLevel()));
            props.setProperty("log-disk-space-limit", AgentConfigImpl.toString("log-disk-space-limit", this.getLogDiskSpaceLimit()));
            props.setProperty("log-file-size-limit", AgentConfigImpl.toString("log-file-size-limit", this.getLogFileSizeLimit()));
            props.setProperty("refresh-interval", AgentConfigImpl.toString("refresh-interval", this.getRefreshInterval()));
        }
        return props;
    }

    @Override
    public boolean isAgentSSLEnabled() {
        return this.agentSSLEnabled;
    }

    @Override
    public void setAgentSSLEnabled(boolean agentSSLEnabled) {
        this.checkReadOnly();
        this.agentSSLEnabled = agentSSLEnabled;
        this.configChanged();
    }

    @Override
    public String getAgentSSLProtocols() {
        return this.agentSSLProtocols;
    }

    @Override
    public void setAgentSSLProtocols(String agentSSLProtocols) {
        this.checkReadOnly();
        this.agentSSLProtocols = agentSSLProtocols;
        this.configChanged();
    }

    @Override
    public String getAgentSSLCiphers() {
        return this.agentSSLCiphers;
    }

    @Override
    public void setAgentSSLCiphers(String agentSSLCiphers) {
        this.checkReadOnly();
        this.agentSSLCiphers = agentSSLCiphers;
        this.configChanged();
    }

    @Override
    public boolean isAgentSSLRequireAuth() {
        return this.agentSSLRequireAuth;
    }

    @Override
    public void setAgentSSLRequireAuth(boolean agentSSLRequireAuth) {
        this.checkReadOnly();
        this.agentSSLRequireAuth = agentSSLRequireAuth;
        this.configChanged();
    }

    @Override
    public boolean isHttpSSLRequireAuth() {
        return this.httpSSLRequireAuth;
    }

    @Override
    public void setHttpSSLRequireAuth(boolean httpSSLRequireAuth) {
        this.checkReadOnly();
        this.httpSSLRequireAuth = httpSSLRequireAuth;
        this.configChanged();
    }

    @Override
    public boolean isHttpAuthEnabled() {
        return this.httpAuthEnabled;
    }

    @Override
    public void setHttpAuthEnabled(boolean httpAuthEnabled) {
        this.checkReadOnly();
        this.httpAuthEnabled = httpAuthEnabled;
        this.configChanged();
    }

    @Override
    public String getHttpAuthUser() {
        return this.httpAuthUser;
    }

    @Override
    public void setHttpAuthUser(String httpAuthUser) {
        this.checkReadOnly();
        this.httpAuthUser = httpAuthUser;
        this.configChanged();
    }

    @Override
    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    @Override
    public void setHttpAuthPassword(String httpAuthPassword) {
        this.checkReadOnly();
        this.httpAuthPassword = httpAuthPassword;
        this.configChanged();
    }

    @Override
    public boolean isSnmpEnabled() {
        return this.snmpEnabled;
    }

    @Override
    public void setSnmpEnabled(boolean snmpEnabled) {
        this.checkReadOnly();
        this.snmpEnabled = snmpEnabled;
        this.configChanged();
    }

    @Override
    public String getSnmpBindAddress() {
        return this.snmpBindAddress;
    }

    @Override
    public void setSnmpBindAddress(String snmpBindAddress) {
        this.checkReadOnly();
        this.snmpBindAddress = this.validateSnmpBindAddress(snmpBindAddress);
        this.configChanged();
    }

    @Override
    public String getSnmpDirectory() {
        return this.snmpDirectory;
    }

    @Override
    public void setSnmpDirectory(String snmpDirectory) {
        this.checkReadOnly();
        this.snmpDirectory = this.validateSnmpDirectory(snmpDirectory);
        this.configChanged();
    }

    @Override
    public boolean isRmiEnabled() {
        return this.rmiEnabled;
    }

    @Override
    public void setRmiEnabled(boolean rmiEnabled) {
        this.checkReadOnly();
        this.rmiEnabled = rmiEnabled;
        this.configChanged();
    }

    @Override
    public boolean isRmiRegistryEnabled() {
        return this.rmiRegistryEnabled;
    }

    @Override
    public void setRmiRegistryEnabled(boolean rmiRegistryEnabled) {
        this.checkReadOnly();
        this.rmiRegistryEnabled = rmiRegistryEnabled;
        this.configChanged();
    }

    @Override
    public String getRmiBindAddress() {
        return this.rmiBindAddress;
    }

    @Override
    public void setRmiBindAddress(String rmiBindAddress) {
        this.checkReadOnly();
        this.rmiBindAddress = this.validateRmiBindAddress(rmiBindAddress);
        this.configChanged();
    }

    @Override
    public int getRmiPort() {
        return this.rmiPort;
    }

    @Override
    public void setRmiPort(int rmiPort) {
        this.checkReadOnly();
        this.rmiPort = this.validateRmiPort(rmiPort);
        this.configChanged();
    }

    @Override
    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    @Override
    public void setRmiServerPort(int port) {
        this.checkReadOnly();
        this.rmiServerPort = this.validateRmiServerPort(this.rmiServerPort);
        this.configChanged();
    }

    @Override
    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    @Override
    public void setHttpEnabled(boolean httpEnabled) {
        this.checkReadOnly();
        this.httpEnabled = httpEnabled;
        this.configChanged();
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public void setHttpPort(int httpPort) {
        this.checkReadOnly();
        this.httpPort = this.validateHttpPort(httpPort);
        this.configChanged();
    }

    @Override
    public String getHttpBindAddress() {
        return this.httpBindAddress;
    }

    @Override
    public void setHttpBindAddress(String httpBindAddress) {
        this.checkReadOnly();
        this.httpBindAddress = this.validateHttpBindAddress(httpBindAddress);
        this.configChanged();
    }

    public void setHttpBindAddress(InetAddress httpBindAddress) {
        this.checkReadOnly();
        this.httpBindAddress = this.validateHttpBindAddress(httpBindAddress);
        this.configChanged();
    }

    @Override
    public boolean getAutoConnect() {
        return this.autoConnect;
    }

    @Override
    public void setAutoConnect(boolean v) {
        this.checkReadOnly();
        this.autoConnect = v;
        this.configChanged();
    }

    private void initialize(Properties props) {
        StringTokenizer st;
        String key;
        String value;
        this.autoConnect = this.validateBoolean(props.getProperty("auto-connect"), true);
        this.httpEnabled = this.validateBoolean(props.getProperty("http-enabled"), true);
        this.httpBindAddress = this.validateHttpBindAddress(props.getProperty("http-bind-address"));
        this.httpPort = this.validateHttpPort(props.getProperty("http-port"));
        this.rmiEnabled = this.validateBoolean(props.getProperty("rmi-enabled"), true);
        this.rmiRegistryEnabled = this.validateBoolean(props.getProperty("rmi-registry-enabled"), true);
        this.rmiBindAddress = this.validateRmiBindAddress(props.getProperty("rmi-bind-address"));
        this.rmiPort = this.validateRmiPort(props.getProperty("rmi-port"));
        this.rmiServerPort = this.validateRmiServerPort(props.getProperty("rmi-server-port"));
        this.snmpEnabled = this.validateBoolean(props.getProperty("snmp-enabled"), false);
        this.snmpDirectory = this.validateSnmpDirectory(props.getProperty("snmp-directory"));
        this.agentSSLEnabled = this.validateBoolean(props.getProperty("agent-ssl-enabled"), false);
        this.agentSSLProtocols = this.validateNonEmptyString(props.getProperty("agent-ssl-protocols"), "any");
        this.agentSSLCiphers = this.validateNonEmptyString(props.getProperty("agent-ssl-ciphers"), "any");
        this.agentSSLRequireAuth = this.validateBoolean(props.getProperty("agent-ssl-require-authentication"), true);
        this.httpSSLRequireAuth = this.validateBoolean(props.getProperty("http-ssl-require-authentication"), false);
        this.httpAuthEnabled = this.validateBoolean(props.getProperty("http-authentication-enabled"), false);
        this.httpAuthUser = this.validateNonEmptyString(props.getProperty("http-authentication-user"), "admin");
        this.httpAuthPassword = this.validateNonEmptyString(props.getProperty("http-authentication-password"), "password");
        this.sslEnabled = this.validateBoolean(props.getProperty("cluster-ssl-enabled"), false);
        this.sslProtocols = this.validateNonEmptyString(props.getProperty("cluster-ssl-protocols"), "any");
        this.sslCiphers = this.validateNonEmptyString(props.getProperty("cluster-ssl-ciphers"), "any");
        this.sslAuthenticationRequired = this.validateBoolean(props.getProperty("cluster-ssl-require-authentication"), true);
        this.sslProperties = new Properties();
        int i = 0;
        while ((value = props.getProperty(key = "ssl-property-" + i)) != null && (st = new StringTokenizer(value, "=")).hasMoreTokens()) {
            String propKey = st.nextToken();
            if (!st.hasMoreTokens()) break;
            String propValue = st.nextToken();
            this.sslProperties.put(propKey, propValue);
            ++i;
        }
        this.isEmailNotificationEnabled = this.validateBoolean(props.getProperty("email-notification-enabled"), false);
        this.emailNotificationHostName = this.validateNonEmptyString(props.getProperty("email-notification-host"), "");
        this.emailNotificationFrom = this.validateNonEmptyString(props.getProperty("email-notification-from"), "");
        this.emailNotificationToList = this.validateNonEmptyString(props.getProperty("email-notification-to"), "");
        this.stateSaveFile = this.validateNonEmptyString(props.getProperty("state-save-file"), "agent.ser");
        try {
            String hostProp;
            i = 0;
            while (!AgentConfigImpl.isEmpty(hostProp = props.getProperty(LOCATOR_HOST_NAME + i))) {
                String host = hostProp;
                int port = Integer.parseInt(props.getProperty(LOCATOR_PORT_NAME + i));
                File workDir = this.validateWorkingDirectory(props.getProperty(LOCATOR_WORKING_DIRECTORY_NAME + i));
                File prodDir = new File(this.validateProductDirectory(props.getProperty(LOCATOR_PRODUCT_DIRECTORY_NAME + i)));
                String remoteCmd = props.getProperty(LOCATOR_REMOTE_COMMAND + i);
                String bindAddr = props.getProperty(LOCATOR_BIND_ADDRESS + i);
                DistributionLocatorConfig config = this.createDistributionLocatorConfig();
                config.setHost(host);
                config.setPort(port);
                config.setBindAddress(bindAddr);
                config.setWorkingDirectory(workDir.getAbsolutePath());
                config.setProductDirectory(prodDir.getAbsolutePath());
                config.setRemoteCommand(remoteCmd);
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static Properties filterOutAgentProperties(Properties props) {
        Properties filteredProps = new Properties();
        for (Object key : props.keySet()) {
            String value;
            if (AgentConfigImpl._getPropertyDescription(key.toString()) != null || (value = props.getProperty(key.toString())) == null) continue;
            filteredProps.setProperty(key.toString(), value);
        }
        AgentConfigImpl.appendLogFileProperty(filteredProps);
        return filteredProps;
    }

    private static void appendLogFileProperty(Properties props) {
        if (!props.containsKey("log-file") && !props.containsKey("gemfire.agent.log-file")) {
            props.put("log-file", DEFAULT_LOG_FILE);
        }
    }

    private static Properties appendOptionalPropertyFileProperties(Properties props) {
        URL url = AgentConfigImpl.getPropertyFileURL(AgentConfigImpl.retrievePropertyFile());
        Properties appendedProps = new Properties();
        appendedProps.putAll((Map<?, ?>)props);
        if (url != null) {
            InputStream in = null;
            try {
                in = url.openStream();
                Properties agentPropertyFileProperties = new Properties();
                agentPropertyFileProperties.load(in);
                for (Object key : agentPropertyFileProperties.keySet()) {
                    if (props.getProperty(key.toString()) != null) continue;
                    appendedProps.setProperty(key.toString(), agentPropertyFileProperties.getProperty(key.toString()));
                }
            }
            catch (IOException e) {
                throw new GemFireIOException(String.format("Failed reading %s", url), e);
            }
            finally {
                IOUtils.close(in);
            }
        }
        for (Object propSuffix : props.keySet()) {
            String key = "gemfire.agent." + propSuffix;
            String value = System.getProperty(key);
            if (value == null) continue;
            appendedProps.put(key, value);
        }
        return appendedProps;
    }

    public static String getPropertyDescription(String prop) {
        if (prop.equals("log-file")) {
            return "Name of the agent's log file";
        }
        if (prop.equals("log-level")) {
            return "Minimum level of logging performed by agent. Valid values are: all, finest, finer, fine, config, info, warning, error, severe and none.";
        }
        if (prop.equals(AGENT_DEBUG)) {
            return "Whether the agent should print debugging information";
        }
        if (prop.equals("log-disk-space-limit")) {
            return "Limit, in megabytes, of how much disk space can be consumed by old inactive log files. This value (in megabytes) should be in the range: 0-1000000.";
        }
        if (prop.equals("log-file-size-limit")) {
            return "Limit, in megabytes, of how large the current log file can grow before it is closed and log rolls on to a new file. This value (in megabytes) should be in the range: 0-1000000.";
        }
        if (prop.equals("mcast-port")) {
            return "Multicast port used to connect to distributed system. To use IP multicast, you must also define mcast-address. The value must be in the range: 0-65535.";
        }
        if (prop.equals("mcast-address")) {
            return "Multicast address used to connect to distributed system. To use multicast, you must also define mcast-port, the IP port.";
        }
        if (prop.equals("bind-address")) {
            return "An IP address of the JMX Agent's distributed system on a multi-homed host. On a multi-homed host, you must explicitly specify the bind address.";
        }
        if (prop.equals("tcp-port")) {
            return "TCP/IP port number to use in the agent's distributed system";
        }
        if (prop.equals("locators")) {
            return "A comma-separated list of address(es) of the locator(s) in the distributed system in host[port] form. E.g. locators=host1[port1],host2[port2],...,hostn[portn]";
        }
        if (prop.equals("membership-port-range")) {
            return "The allowed range of UDP ports for use in forming an unique membership identifier. This range is given as two numbers separated by a minus sign.";
        }
        if (prop.equals("entity-config-xml-file")) {
            return "The name of an XML file that specifies the configuration for the managed entity administered by the Distributed System. The XML file must conform to the dtd - doc-files/ds5_0.dtd.";
        }
        if (prop.equals("refresh-interval")) {
            return "Refresh Interval, in seconds, to be used for auto-refresh of SystemMember, StatisticResource and CacheServer refreshes";
        }
        if (prop.equals("remote-command")) {
            return "Command prefix used for launching members of the distributed system";
        }
        if (prop.equals("cluster-ssl-enabled")) {
            return "Whether to use the SSL protocol for communication between members of the admin distributed system. If set to true, locators should be used.";
        }
        if (prop.equals("cluster-ssl-protocols")) {
            return "A space-separated list of the SSL protocols used to communicate with distributed system.";
        }
        if (prop.equals("cluster-ssl-ciphers")) {
            return "A space-separated list of the SSL ciphers to be used to communicate with distributed system.";
        }
        if (prop.equals("cluster-ssl-require-authentication")) {
            return "Whether connection to the distributed system needs SSL authentication.";
        }
        String description = AgentConfigImpl._getPropertyDescription(prop);
        if (description == null) {
            throw new IllegalArgumentException(String.format("Unknown config property: %s", prop));
        }
        return description;
    }

    public static String _getPropertyDescription(String prop) {
        if (prop.equals("auto-connect")) {
            return "Whether the JMX agent will connect 'automatically' to the distributed system that it is configured to monitor.";
        }
        if (prop.equals("http-enabled")) {
            return "Whether the HTTP adapter is enabled in the JMX agent.";
        }
        if (prop.equals("http-bind-address")) {
            return "Bind address of HTTP adapter's sockets";
        }
        if (prop.equals("http-port")) {
            return "The port on which the HTTP adapter will be started. This value should be in the range: 0-65535.";
        }
        if (prop.equals("rmi-enabled")) {
            return "Whether the RMI JMX adapter is enabled.";
        }
        if (prop.equals("rmi-registry-enabled")) {
            return "Whether the JMX agent should start RMI registry. Alternatively, a registry outside of the JMX agent VM can be used.";
        }
        if (prop.equals("rmi-bind-address")) {
            return "Bind address of RMI adapter's sockets";
        }
        if (prop.equals("rmi-port")) {
            return "The port on which to contact the RMI registry. The value must be in the range: 0-65535.";
        }
        if (prop.equals("rmi-server-port")) {
            return "The port on which the RMI Connector Server should start. The value must be in the range: 0-65535.";
        }
        if (prop.equals("snmp-enabled")) {
            return "Whether the SNMP JMX adapter will be enabled.";
        }
        if (prop.equals("snmp-bind-address")) {
            return "Bind address of SNMP adapter's sockets";
        }
        if (prop.equals("snmp-directory")) {
            return "The directory in which SNMP configuration resides";
        }
        if (prop.equals("agent-ssl-enabled")) {
            return "Whether the JMX Agent will use the SSL protocol for communication.";
        }
        if (prop.equals("agent-ssl-protocols")) {
            return "The space-separated list of the SSL protocols to be used when connecting to the JMX agent.";
        }
        if (prop.equals("agent-ssl-ciphers")) {
            return "The space-separated list of the SSL ciphers to be used when connecting to the JMX Agent.";
        }
        if (prop.equals("agent-ssl-require-authentication")) {
            return "Whether or not SSL connections to the RMI adapter require authentication. If true, needs client authentication for RMI and other non-HTTP connectors/adaptors.";
        }
        if (prop.equals("http-ssl-require-authentication")) {
            return "Whether SSL connections to the HTTP adapter will need authentication.";
        }
        if (prop.equals("http-authentication-enabled")) {
            return "Whether the HTTP adapter will use HTTP authentication.";
        }
        if (prop.equals("http-authentication-user")) {
            return "The user name for authentication in the HTTP JMX adapter";
        }
        if (prop.equals("http-authentication-password")) {
            return "The password for authentication in the HTTP JMX adapter";
        }
        if (prop.equals(PROPERTY_FILE_NAME)) {
            return "Name and path of the Agent's properties file from which agent reads configuration";
        }
        if (prop.equals(LOCATOR_HOST_NAME)) {
            return "Host on which the distributed system's locator runs";
        }
        if (prop.equals(LOCATOR_PORT_NAME)) {
            return "Host on which the distributed system's locator runs";
        }
        if (prop.equals(LOCATOR_PRODUCT_DIRECTORY_NAME)) {
            return "GemFire product directory used to launch a locator";
        }
        if (prop.equals(LOCATOR_WORKING_DIRECTORY_NAME)) {
            return "Directory in which a locator will be launched";
        }
        if (prop.equals(LOCATOR_REMOTE_COMMAND)) {
            return "Command prefix used when launching a locator";
        }
        if (prop.equals(LOCATOR_BIND_ADDRESS)) {
            return "IP address to use when contacting locator";
        }
        if (prop.equals(LOCATOR_DS_PROPERTIES)) {
            return "Properties for configuring a locator's distributed system";
        }
        if (prop.equals("email-notification-enabled")) {
            return "Whether the e-mail notifications are enabled.";
        }
        if (prop.equals("email-notification-from")) {
            return "E-mail address to be used to send e-mail notifications.";
        }
        if (prop.equals("email-notification-host")) {
            return "The host name of the e-mail server to be used for sending email notification.";
        }
        if (prop.equals("email-notification-to")) {
            return "A comma-separated list of recipient e-mail addresses to send e-mail notifications to.";
        }
        if (prop.equals("state-save-file")) {
            return "The name(not the path) of the file to be used for saving agent state. The file is stored in the same directory in which the agent.properties file is located.";
        }
        return null;
    }

    private static Properties toProperties(String[] args) {
        Properties props = new Properties();
        for (String arg : args) {
            String value;
            String key;
            int eq;
            if (arg.startsWith("-J")) {
                eq = arg.indexOf("=");
                key = arg.substring(2, eq);
                value = arg.substring(eq + 1);
                System.setProperty(key, value);
                continue;
            }
            if (arg.indexOf(AGENT_DEBUG) > 0) {
                eq = arg.indexOf("=");
                key = arg.substring(2, eq);
                value = arg.substring(eq + 1);
                System.setProperty(key, value);
                continue;
            }
            if (arg.indexOf("=") <= 0) continue;
            eq = arg.indexOf("=");
            key = arg.substring(0, eq);
            value = arg.substring(eq + 1);
            props.setProperty(key, value);
        }
        return props;
    }

    public String[] getOriginalArgs() {
        return this.originalCmdLineArgs;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.httpPort < 0 || this.httpPort > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "http-port", 0, 65535));
        }
        if (this.rmiPort < 0 || this.rmiPort > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "rmi-port", 0, 65535));
        }
        if (this.rmiServerPort < 0 || this.rmiServerPort > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "rmi-server-port", 0, 65535));
        }
    }

    private String validateNonEmptyString(String value, String defaultValue) {
        return AgentConfigImpl.isEmpty(value) ? defaultValue : value;
    }

    private String validateSystemHost(String systemHost) {
        return InetAddressUtilsWithLogging.validateHost(systemHost);
    }

    private String validateProductDirectory(String productDir) {
        if (AgentConfigImpl.isEmpty(productDir)) {
            return null;
        }
        return productDir;
    }

    private boolean validateBoolean(String value, boolean defaultValue) {
        if (AgentConfigImpl.isEmpty(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private int validateHttpPort(String val) {
        if (AgentConfigImpl.isEmpty(val)) {
            return 8080;
        }
        return this.validateHttpPort(Integer.parseInt(val));
    }

    private int validateHttpPort(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "http-port", 0, 65535));
        }
        return val;
    }

    private String validateHttpBindAddress(String val) {
        String value = InetAddressUtilsWithLogging.validateHost(val);
        if (value == null) {
            return "";
        }
        return value;
    }

    private String validateHttpBindAddress(InetAddress val) {
        if (val == null) {
            throw new IllegalArgumentException("HttpBindAddress must not be null");
        }
        return AgentConfigImpl.toString("", val);
    }

    private String validateSnmpBindAddress(String val) {
        String value = InetAddressUtilsWithLogging.validateHost(val);
        if (value == null) {
            return "";
        }
        return value;
    }

    private String validateSnmpDirectory(String snmpDir) {
        return snmpDir;
    }

    private int validateRmiPort(String val) {
        if (AgentConfigImpl.isEmpty(val)) {
            return 1099;
        }
        return this.validateRmiPort(Integer.parseInt(val));
    }

    private int validateRmiPort(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "rmi-port", 0, 65535));
        }
        return val;
    }

    private int validateRmiServerPort(String val) {
        if (AgentConfigImpl.isEmpty(val)) {
            return 0;
        }
        return this.validateRmiServerPort(Integer.parseInt(val));
    }

    private int validateRmiServerPort(int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException(String.format("%s must be zero or an integer between %s and %s.", "rmi-server-port", 0, 65535));
        }
        return val;
    }

    private String validateRmiBindAddress(String val) {
        String value = InetAddressUtilsWithLogging.validateHost(val);
        if (value == null) {
            return "";
        }
        return value;
    }

    private File validateWorkingDirectory(String workingDir) {
        if (AgentConfigImpl.isEmpty(workingDir)) {
            throw new IllegalArgumentException("Locator WorkingDirectory must not be null");
        }
        return new File(workingDir);
    }

    public static URL getPropertyFileURL(String propFileLocation) {
        File propFile = new File(propFileLocation);
        if (propFile.exists()) {
            propFile = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(propFile);
            try {
                return propFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (propFileLocation != null && propFileLocation.length() > 0 && (propFile = new File(System.getProperty("user.home"), propFileLocation)).exists()) {
            propFile = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(propFile);
            try {
                return propFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ClassPathLoader.getLatest().getResource(AgentConfigImpl.class, propFileLocation);
    }

    private static boolean okToDisplayPropertyValue(String attName) {
        if (attName.startsWith("http-authentication-user")) {
            return false;
        }
        if (attName.startsWith("http-authentication-password")) {
            return false;
        }
        if (attName.startsWith("agent-ssl-protocols")) {
            return false;
        }
        if (attName.startsWith("agent-ssl-ciphers")) {
            return false;
        }
        if (attName.toLowerCase().contains("javax.net.ssl")) {
            return false;
        }
        return !attName.toLowerCase().contains("password");
    }

    private static String toString(String attName, Object obj) {
        if (AgentConfigImpl.okToDisplayPropertyValue(attName)) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof InetAddress) {
                return InetAddressUtils.toHostString(obj);
            }
            return obj.toString();
        }
        return OBFUSCATED_STRING;
    }

    private static String toString(String attName, int num) {
        if (AgentConfigImpl.okToDisplayPropertyValue(attName)) {
            return String.valueOf(num);
        }
        return OBFUSCATED_STRING;
    }

    private static String toString(String attName, boolean v) {
        if (AgentConfigImpl.okToDisplayPropertyValue(attName)) {
            return String.valueOf(v);
        }
        return OBFUSCATED_STRING;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    @Override
    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    @Override
    public void setSSLEnabled(boolean enabled) {
        this.sslEnabled = enabled;
        this.configChanged();
    }

    @Override
    public String getSSLProtocols() {
        return this.sslProtocols;
    }

    @Override
    public void setSSLProtocols(String protocols) {
        this.sslProtocols = protocols;
        this.configChanged();
    }

    @Override
    public String getSSLCiphers() {
        return this.sslCiphers;
    }

    @Override
    public void setSSLCiphers(String ciphers) {
        this.sslCiphers = ciphers;
        this.configChanged();
    }

    @Override
    public boolean isSSLAuthenticationRequired() {
        return this.sslAuthenticationRequired;
    }

    @Override
    public void setSSLAuthenticationRequired(boolean authRequired) {
        this.sslAuthenticationRequired = authRequired;
        this.configChanged();
    }

    @Override
    public Properties getSSLProperties() {
        return this.sslProperties;
    }

    @Override
    public void setSSLProperties(Properties sslProperties) {
        this.sslProperties = sslProperties;
        if (this.sslProperties == null) {
            this.sslProperties = new Properties();
        }
        this.configChanged();
    }

    @Override
    public String getStateSaveFile() {
        return this.stateSaveFile;
    }

    @Override
    public void setStateSaveFile(String file) {
        this.checkReadOnly();
        this.stateSaveFile = file;
        this.configChanged();
    }

    @Override
    public boolean isEmailNotificationEnabled() {
        return this.isEmailNotificationEnabled;
    }

    @Override
    public void setEmailNotificationEnabled(boolean enabled) {
        this.checkReadOnly();
        this.isEmailNotificationEnabled = enabled;
        this.configChanged();
    }

    @Override
    public String getEmailNotificationFrom() {
        return this.emailNotificationFrom;
    }

    @Override
    public void setEmailNotificationFrom(String emailID) {
        this.emailNotificationFrom = emailID;
        this.configChanged();
    }

    @Override
    public String getEmailNotificationHost() {
        return this.emailNotificationHostName;
    }

    @Override
    public void setEmailNotificationHost(String hostName) {
        this.emailNotificationHostName = hostName;
        this.configChanged();
    }

    @Override
    public String getEmailNotificationToList() {
        return this.emailNotificationToList;
    }

    @Override
    public void setEmailNotificationToList(String emailIDs) {
        this.emailNotificationToList = emailIDs;
        this.configChanged();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

