/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.util.internal.UncheckedUtils;
import org.jetbrains.annotations.NotNull;

public class RegisterInterestOp {
    public static <K> List<List<K>> execute(@NotNull ExecutablePool pool, @NotNull String region, @NotNull K key, @NotNull InterestType interestType2, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOnQueuesAndReturnPrimaryResult(op));
    }

    public static <K> List<K> executeOn(@NotNull ServerLocation sl, @NotNull ExecutablePool pool, @NotNull String region, @NotNull K key, @NotNull InterestType interestType2, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOn(sl, (Op)op));
    }

    public static <K> List<K> executeOn(@NotNull Connection conn, @NotNull ExecutablePool pool, @NotNull String region, @NotNull K key, @NotNull InterestType interestType2, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
        RegisterInterestOpImpl op = new RegisterInterestOpImpl(region, key, interestType2, policy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
        return (List)UncheckedUtils.uncheckedCast((Object)pool.executeOn(conn, (Op)op));
    }

    private RegisterInterestOp() {
    }

    protected static class RegisterInterestOpImpl
    extends AbstractOp {
        protected String region;

        public RegisterInterestOpImpl(@NotNull String region, @NotNull Object key, @NotNull InterestType interestType2, @NotNull InterestResultPolicy policy, boolean isDurable, boolean receiveUpdatesAsInvalidates, @NotNull DataPolicy regionDataPolicy) {
            super(20, 7);
            this.region = region;
            this.getMessage().addStringPart(region, true);
            this.getMessage().addIntPart(interestType2.ordinal());
            this.getMessage().addObjPart(policy);
            byte durableByte = (byte)(isDurable ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{durableByte});
            this.getMessage().addStringOrObjPart(key);
            byte notifyByte = (byte)(receiveUpdatesAsInvalidates ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{notifyByte});
            this.getMessage().addBytesPart(new byte[]{(byte)regionDataPolicy.ordinal(), 1});
        }

        protected RegisterInterestOpImpl(String region, int msgType, int numParts) {
            super(msgType, numParts);
            this.region = region;
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, KnownVersion.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected List<List<Object>> processResponse(Message m, Connection con) throws Exception {
            ChunkedMessage chunkedMessage = (ChunkedMessage)m;
            chunkedMessage.readHeader();
            switch (chunkedMessage.getMessageType()) {
                case 32: {
                    LocalRegion localRegion = null;
                    try {
                        localRegion = (LocalRegion)GemFireCacheImpl.getInstance().getRegion(this.region);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    ArrayList<List<Object>> listOfList = new ArrayList<List<Object>>();
                    listOfList.add(list);
                    ArrayList<List<Object>> serverKeys = new ArrayList<List<Object>>();
                    VersionedObjectList serverEntries = null;
                    do {
                        chunkedMessage.receiveChunk();
                        Part part = chunkedMessage.getPart(0);
                        Object partObj = part.getObject();
                        if (partObj instanceof Throwable) {
                            String s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, (Throwable)partObj);
                        }
                        if (partObj instanceof VersionedObjectList) {
                            if (serverEntries == null) {
                                serverEntries = new VersionedObjectList(true);
                            }
                            ((VersionedObjectList)partObj).replaceNullIDs(con.getEndpoint().getMemberId());
                            list.clear();
                            list.add(partObj);
                            if (localRegion == null) continue;
                            try {
                                localRegion.refreshEntriesFromServerKeys(con, listOfList, InterestResultPolicy.KEYS_VALUES);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        serverKeys.add((List<Object>)UncheckedUtils.uncheckedCast((Object)partObj));
                    } while (!chunkedMessage.isLastChunk());
                    if (serverEntries != null) {
                        list.clear();
                        list.add(serverEntries);
                        return listOfList;
                    }
                    return serverKeys;
                }
                case 33: {
                    chunkedMessage.receiveChunk();
                    return null;
                }
                case 2: {
                    chunkedMessage.receiveChunk();
                    Part part = chunkedMessage.getPart(0);
                    Object obj = part.getObject();
                    String s = this + ": While performing a remote " + this.getOpName();
                    throw new ServerOperationException(s, (Throwable)obj);
                }
                case 21: {
                    chunkedMessage.receiveChunk();
                    String errorMessage = chunkedMessage.getPart(0).getString();
                    String s = this + ": While performing a remote " + this.getOpName() + ": ";
                    throw new ServerOperationException(s + errorMessage);
                }
            }
            throw new InternalGemFireError("Unknown message type " + chunkedMessage.getMessageType());
        }

        protected String getOpName() {
            return "registerInterest";
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 21;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRegisterInterest();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInterestSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInterest(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

