/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.jetbrains.annotations.NotNull;

public class UnregisterInterestOp {
    public static void execute(ExecutablePool pool, String region, Object key, @NotNull InterestType interestType2, boolean isClosing, boolean keepAlive) {
        UnregisterInterestOpImpl op = new UnregisterInterestOpImpl(region, key, interestType2, isClosing, keepAlive);
        pool.executeOnAllQueueServers(op);
    }

    private UnregisterInterestOp() {
    }

    private static class UnregisterInterestOpImpl
    extends AbstractOp {
        public UnregisterInterestOpImpl(String region, Object key, @NotNull InterestType interestType2, boolean isClosing, boolean keepAlive) {
            super(22, 5);
            this.getMessage().addStringPart(region, true);
            this.getMessage().addIntPart(interestType2.ordinal());
            this.getMessage().addStringOrObjPart(key);
            byte closingByte = (byte)(isClosing ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{closingByte});
            byte keepAliveByte = (byte)(keepAlive ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{keepAliveByte});
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            this.processAck(msg, "unregisterInterest");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 23;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startUnregisterInterest();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endUnregisterInterestSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endUnregisterInterest(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

