/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Statistics;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.Stat;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteStat;

public class RemoteStatResource
implements StatResource,
DataSerializable {
    private static final long serialVersionUID = -3118720083415516133L;
    private long rsrcId;
    private long rsrcUniqueId;
    private String name;
    private String typeName;
    private String typeDesc;
    private transient RemoteGemFireVM vm;
    private String systemName;

    public RemoteStatResource(Statistics rsrc) {
        this.rsrcId = rsrc.getNumericId();
        this.rsrcUniqueId = rsrc.getUniqueId();
        this.name = rsrc.getTextId();
        this.typeName = rsrc.getType().getName();
        this.typeDesc = rsrc.getType().getDescription();
    }

    public RemoteStatResource() {
    }

    @Override
    public long getResourceID() {
        return this.rsrcId;
    }

    @Override
    public long getResourceUniqueID() {
        return this.rsrcUniqueId;
    }

    @Override
    public String getSystemName() {
        if (this.systemName == null) {
            if (this.vm == null) {
                this.systemName = "";
            } else {
                this.systemName = this.vm.toString();
                return this.systemName;
            }
        }
        return this.systemName;
    }

    @Override
    public GemFireVM getGemFireVM() {
        return this.vm;
    }

    @Override
    public Stat[] getStats() {
        if (this.vm != null) {
            return this.vm.getResourceStatsByID(this.rsrcUniqueId);
        }
        return new RemoteStat[0];
    }

    @Override
    public Stat getStatByName(String name) {
        Stat[] stats;
        for (Stat stat : stats = this.getStats()) {
            if (!name.equals(stat.getName())) continue;
            return stat;
        }
        return null;
    }

    @Override
    public int getID() {
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public String getDescription() {
        return this.typeDesc;
    }

    public int hashCode() {
        return (int)this.rsrcUniqueId;
    }

    public boolean equals(Object other) {
        if (other instanceof RemoteStatResource) {
            RemoteStatResource rsrc = (RemoteStatResource)other;
            return this.rsrcUniqueId == rsrc.rsrcUniqueId && this.vm.equals(rsrc.vm);
        }
        return false;
    }

    void setGemFireVM(RemoteGemFireVM vm) {
        this.vm = vm;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.rsrcId);
        out.writeLong(this.rsrcUniqueId);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeString(this.typeName, out);
        DataSerializer.writeString(this.typeDesc, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.rsrcId = in.readLong();
        this.rsrcUniqueId = in.readLong();
        this.name = DataSerializer.readString(in);
        this.typeName = DataSerializer.readString(in);
        this.typeDesc = DataSerializer.readString(in);
    }
}

