/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.NotificationHub;
import org.apache.logging.log4j.Logger;

public class ManagementFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private final MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    private final NotificationHub notificationHub;

    public ManagementFunction(NotificationHub notifHub) {
        this.notificationHub = notifHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext fc) {
        block18: {
            boolean executedSuccessfully = false;
            InternalCacheForClientAccess cache = ((InternalCache)fc.getCache()).getCacheForProcessingClientRequests();
            Object[] functionArguments = (Object[])fc.getArguments();
            ObjectName objectName = (ObjectName)functionArguments[0];
            String methodName = (String)functionArguments[1];
            String[] signature = (String[])functionArguments[2];
            Object[] args = (Object[])functionArguments[3];
            String memberName = (String)functionArguments[4];
            Object returnObj = null;
            try {
                int nargs;
                int n = nargs = args == null ? 0 : args.length;
                if (methodName.startsWith("set") && methodName.length() > 3 && nargs == 1) {
                    Attribute attr = new Attribute(methodName.substring(3), args[0]);
                    this.mbeanServer.setAttribute(objectName, attr);
                    fc.getResultSender().lastResult(null);
                } else if (methodName.equals("addNotificationListener")) {
                    this.notificationHub.addHubNotificationListener(memberName, objectName);
                    fc.getResultSender().lastResult("UNDEFINED");
                } else if (methodName.equals("removeNotificationListener")) {
                    this.notificationHub.removeHubNotificationListener(memberName, objectName);
                    fc.getResultSender().lastResult("UNDEFINED");
                } else if (methodName.equals("getNotificationInfo")) {
                    fc.getResultSender().lastResult(this.mbeanServer.getMBeanInfo(objectName));
                } else {
                    returnObj = this.mbeanServer.invoke(objectName, methodName, args, signature);
                    fc.getResultSender().lastResult(returnObj);
                }
                executedSuccessfully = true;
            }
            catch (InstanceNotFoundException e) {
                if (cache != null) {
                    if (!cache.isClosed()) {
                        this.sendException(e, fc);
                    }
                }
            }
            catch (Exception e) {
                this.sendException(e, fc);
            }
            finally {
                if (executedSuccessfully || cache != null && !cache.isClosed()) break block18;
                e = new Exception("Member Is Shutting down");
                this.sendException(e, fc);
                return;
            }
        }
    }

    @Override
    public String getId() {
        return ManagementConstants.MGMT_FUNCTION_ID;
    }

    private void sendException(Exception e, FunctionContext fc) {
        if (logger.isDebugEnabled()) {
            logger.debug("Management Function Could Not Be Executed", (Throwable)e);
        }
        fc.getResultSender().sendException(e);
    }
}

