/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.serialization.filter.FilterConfiguration;
import org.apache.geode.internal.serialization.filter.SystemPropertyJmxSerialFilterConfigurationFactory;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.AlreadyRunningException;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DiskStoreMXBean;
import org.apache.geode.management.DistributedLockServiceMXBean;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.BaseManagementService;
import org.apache.geode.management.internal.FederatingManager;
import org.apache.geode.management.internal.FederatingManagerFactory;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.LocalManager;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.ManagementAgentFactory;
import org.apache.geode.management.internal.ManagementFunction;
import org.apache.geode.management.internal.ManagementMembershipListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.MemberMessenger;
import org.apache.geode.management.internal.NotificationHub;
import org.apache.geode.management.internal.ProxyListener;
import org.apache.geode.management.membership.MembershipEvent;
import org.apache.geode.management.membership.MembershipListener;
import org.apache.logging.log4j.Logger;

public class SystemManagementService
extends BaseManagementService {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    @VisibleForTesting
    static final String FEDERATING_MANAGER_FACTORY_PROPERTY = "FEDERATING_MANAGER_FACTORY";
    private final InternalDistributedSystem system;
    private final NotificationHub notificationHub;
    private final MBeanJMXAdapter jmxAdapter;
    private final InternalCacheForClientAccess cache;
    private final ManagementAgent agent;
    private final ManagementResourceRepo repo;
    private final List<ProxyListener> proxyListeners;
    private final UniversalListenerContainer universalListenerContainer = new UniversalListenerContainer();
    private final StatisticsFactory statisticsFactory;
    private final StatisticsClock statisticsClock;
    private final FederatingManagerFactory federatingManagerFactory;
    private final Function<SystemManagementService, LocalManager> localManagerFactory;
    private volatile boolean closed;
    private volatile boolean isStarted;
    private LocalManager localManager;
    private FederatingManager federatingManager;
    private ManagementMembershipListener listener;

    static BaseManagementService newSystemManagementService(InternalCacheForClientAccess cache) {
        return SystemManagementService.newSystemManagementService(cache, NotificationHub::new, SystemManagementService::createLocalManager, SystemManagementService.createFederatingManagerFactory(), ManagementAgent::new);
    }

    @VisibleForTesting
    static BaseManagementService newSystemManagementService(InternalCacheForClientAccess cache, Function<ManagementResourceRepo, NotificationHub> notificationHubFactory, Function<SystemManagementService, LocalManager> localManagerFactory, FederatingManagerFactory federatingManagerFactory, ManagementAgentFactory managementAgentFactory) {
        return new SystemManagementService(cache, notificationHubFactory, localManagerFactory, federatingManagerFactory, managementAgentFactory).init();
    }

    private SystemManagementService(InternalCacheForClientAccess cache, Function<ManagementResourceRepo, NotificationHub> notificationHubFactory, Function<SystemManagementService, LocalManager> localManagerFactory, FederatingManagerFactory federatingManagerFactory, ManagementAgentFactory managementAgentFactory) {
        this.cache = cache;
        this.system = cache.getInternalDistributedSystem();
        this.localManagerFactory = localManagerFactory;
        if (!this.system.isConnected()) {
            throw new DistributedSystemDisconnectedException("This connection to a distributed system has been disconnected.");
        }
        this.statisticsFactory = this.system.getStatisticsManager();
        this.statisticsClock = cache.getStatisticsClock();
        this.jmxAdapter = new MBeanJMXAdapter(this.system.getDistributedMember());
        this.repo = new ManagementResourceRepo();
        this.notificationHub = notificationHubFactory.apply(this.repo);
        if (this.system.getConfig().getJmxManager()) {
            FilterConfiguration filterConfiguration = new SystemPropertyJmxSerialFilterConfigurationFactory().create();
            this.agent = managementAgentFactory.create(this.system.getConfig(), cache, filterConfiguration);
        } else {
            this.agent = null;
        }
        FunctionService.registerFunction(new ManagementFunction(this.notificationHub));
        this.proxyListeners = new CopyOnWriteArrayList<ProxyListener>();
        this.federatingManagerFactory = federatingManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map map = instances;
        synchronized (map) {
            if (this.closed) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Closing Management Service");
            }
            if (this.listener != null && this.system.isConnected()) {
                this.system.getDistributionManager().removeMembershipListener(this.listener);
            }
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                this.federatingManager.stopManager();
            }
            this.notificationHub.cleanUpListeners();
            this.jmxAdapter.cleanJMXResource();
            if (this.localManager.isRunning()) {
                this.localManager.stopManager();
            }
            if (this.agent != null && this.agent.isRunning()) {
                this.agent.stopAgent();
            }
            this.cache.getJmxManagerAdvisor().broadcastChange();
            instances.remove(this.cache);
            this.localManager = null;
            this.closed = true;
        }
    }

    @Override
    public <T> void federate(ObjectName objectName, Class<T> interfaceClass, boolean notificationEmitter) {
        this.verifyManagementService();
        if (!objectName.getDomain().equalsIgnoreCase("GemFire")) {
            throw new ManagementException("Not A GemFire Domain MBean, can not Federate");
        }
        if (!this.jmxAdapter.isRegistered(objectName)) {
            throw new ManagementException("MBean Not Registered In GemFire Domain");
        }
        if (notificationEmitter && !this.jmxAdapter.hasNotificationSupport(objectName)) {
            throw new ManagementException("MBean Does Not Have Notification Support");
        }
        Object object = this.jmxAdapter.getMBeanObject(objectName);
        FederationComponent federationComponent = new FederationComponent(object, objectName, interfaceClass, notificationEmitter);
        if (Arrays.asList(RegionMXBean.class, MemberMXBean.class).contains(interfaceClass)) {
            federationComponent.refreshObjectState(true);
        }
        this.localManager.markForFederation(objectName, federationComponent);
        if (this.isManager()) {
            this.afterCreateProxy(objectName, interfaceClass, object, federationComponent);
        }
    }

    @Override
    public CacheServerMXBean getLocalCacheServerMXBean(int serverPort) {
        return this.jmxAdapter.getClientServiceMXBean(serverPort);
    }

    @Override
    public long getLastUpdateTime(ObjectName objectName) {
        if (!this.isStartedAndOpen()) {
            return 0L;
        }
        if (this.federatingManager == null) {
            return 0L;
        }
        if (!this.federatingManager.isRunning()) {
            return 0L;
        }
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return 0L;
        }
        return this.federatingManager.getLastUpdateTime(objectName);
    }

    @Override
    public DiskStoreMXBean getLocalDiskStoreMBean(String diskStoreName) {
        return this.jmxAdapter.getLocalDiskStoreMXBean(diskStoreName);
    }

    @Override
    public LockServiceMXBean getLocalLockServiceMBean(String lockServiceName) {
        return this.jmxAdapter.getLocalLockServiceMXBean(lockServiceName);
    }

    @Override
    public RegionMXBean getLocalRegionMBean(String regionPath) {
        return this.jmxAdapter.getLocalRegionMXBean(regionPath);
    }

    @Override
    public MemberMXBean getMemberMXBean() {
        return this.jmxAdapter.getMemberMXBean();
    }

    @Override
    public Set<ObjectName> queryMBeanNames(DistributedMember member) {
        if (!this.isStartedAndOpen()) {
            return Collections.emptySet();
        }
        if (this.system.getDistributedMember().equals(member)) {
            return this.jmxAdapter.getLocalGemFireMBean().keySet();
        }
        if (this.federatingManager == null) {
            return Collections.emptySet();
        }
        if (!this.federatingManager.isRunning()) {
            return Collections.emptySet();
        }
        return this.federatingManager.findAllProxies(member);
    }

    @Override
    public Set<ObjectName> getAsyncEventQueueMBeanNames(DistributedMember member) {
        return this.queryMBeanNames(member).stream().filter(x -> "AsyncEventQueue".equals(x.getKeyProperty("service"))).collect(Collectors.toSet());
    }

    @Override
    public ObjectName registerMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        return this.jmxAdapter.registerMBean(object, objectName, false);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) {
        FederationComponent removed;
        if (!this.isStartedAndOpen()) {
            return;
        }
        this.verifyManagementService();
        if (this.isManager() && (removed = this.localManager.getFedComponents().get(objectName)) != null) {
            this.afterRemoveProxy(objectName, removed.getInterfaceClass(), removed.getMBeanObject(), removed);
        }
        this.jmxAdapter.unregisterMBean(objectName);
        this.localManager.unMarkForFederation(objectName);
    }

    @Override
    public boolean isManager() {
        return this.isManagerCreated() && this.federatingManager.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startManager() {
        if (!this.cache.getInternalDistributedSystem().getConfig().getJmxManager()) {
            throw new ManagementException("Could not start the manager because the gemfire property \"jmx-manager\" is false.");
        }
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null && this.federatingManager.isRunning()) {
                throw new AlreadyRunningException("Manager is already running");
            }
            if (!this.isManagerCreated()) {
                this.createManager();
            }
            boolean started = false;
            try {
                this.system.handleResourceEvent(ResourceEvent.MANAGER_START, null);
                this.federatingManager.startManager();
                if (this.agent != null) {
                    this.agent.startAgent();
                }
                this.cache.getJmxManagerAdvisor().broadcastChange();
                started = true;
            }
            catch (Error | RuntimeException e) {
                logger.error("Jmx manager could not be started because {}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            finally {
                if (!started) {
                    if (this.federatingManager != null) {
                        this.federatingManager.stopManager();
                    }
                    this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopManager() {
        Map map = instances;
        synchronized (map) {
            this.verifyManagementService();
            if (this.federatingManager != null) {
                this.federatingManager.stopManager();
                this.system.handleResourceEvent(ResourceEvent.MANAGER_STOP, null);
                this.cache.getJmxManagerAdvisor().broadcastChange();
                if (this.agent != null && this.agent.isRunning()) {
                    this.agent.stopAgent();
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DistributedLockServiceMXBean getDistributedLockServiceMXBean(String lockServiceName) {
        return this.jmxAdapter.getDistributedLockServiceMXBean(lockServiceName);
    }

    @Override
    public DistributedRegionMXBean getDistributedRegionMXBean(String regionName) {
        return this.jmxAdapter.getDistributedRegionMXBean(regionName);
    }

    @Override
    public DistributedSystemMXBean getDistributedSystemMXBean() {
        return this.jmxAdapter.getDistributedSystemMXBean();
    }

    @Override
    public ManagerMXBean getManagerMXBean() {
        return this.jmxAdapter.getManagerMXBean();
    }

    @Override
    public ObjectName getCacheServerMBeanName(int serverPort, DistributedMember member) {
        return MBeanJMXAdapter.getClientServiceMBeanName(serverPort, member);
    }

    @Override
    public ObjectName getDiskStoreMBeanName(DistributedMember member, String diskName) {
        return MBeanJMXAdapter.getDiskStoreMBeanName(member, diskName);
    }

    @Override
    public ObjectName getDistributedLockServiceMBeanName(String lockService) {
        return MBeanJMXAdapter.getDistributedLockServiceName(lockService);
    }

    @Override
    public ObjectName getDistributedRegionMBeanName(String regionPath) {
        return MBeanJMXAdapter.getDistributedRegionMbeanName(regionPath);
    }

    @Override
    public ObjectName getDistributedSystemMBeanName() {
        return MBeanJMXAdapter.getDistributedSystemName();
    }

    @Override
    public ObjectName getGatewayReceiverMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getGatewayReceiverMBeanName(member);
    }

    @Override
    public ObjectName getGatewaySenderMBeanName(DistributedMember member, String gatewaySenderId) {
        return MBeanJMXAdapter.getGatewaySenderMBeanName(member, gatewaySenderId);
    }

    @Override
    public ObjectName getAsyncEventQueueMBeanName(DistributedMember member, String queueId) {
        return MBeanJMXAdapter.getAsyncEventQueueMBeanName(member, queueId);
    }

    @Override
    public ObjectName getLockServiceMBeanName(DistributedMember member, String lockServiceName) {
        return MBeanJMXAdapter.getLockServiceMBeanName(member, lockServiceName);
    }

    @Override
    public ObjectName getManagerMBeanName() {
        return MBeanJMXAdapter.getManagerName();
    }

    @Override
    public ObjectName getMemberMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getMemberMBeanName(member);
    }

    @Override
    public ObjectName getRegionMBeanName(DistributedMember member, String regionPath) {
        return MBeanJMXAdapter.getRegionMBeanName(member, regionPath);
    }

    @Override
    public GatewayReceiverMXBean getLocalGatewayReceiverMXBean() {
        return this.jmxAdapter.getGatewayReceiverMXBean();
    }

    @Override
    public GatewaySenderMXBean getLocalGatewaySenderMXBean(String senderId) {
        return this.jmxAdapter.getGatewaySenderMXBean(senderId);
    }

    @Override
    public AsyncEventQueueMXBean getLocalAsyncEventQueueMXBean(String queueId) {
        return this.jmxAdapter.getAsyncEventQueueMXBean(queueId);
    }

    @Override
    public ObjectName getLocatorMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getLocatorMBeanName(member);
    }

    @Override
    public LocatorMXBean getLocalLocatorMXBean() {
        return this.jmxAdapter.getLocatorMXBean();
    }

    @Override
    public <T> T getMBeanInstance(ObjectName objectName, Class<T> interfaceClass) {
        if (this.jmxAdapter.isLocalMBean(objectName)) {
            return this.jmxAdapter.findMBeanByName(objectName, interfaceClass);
        }
        return this.getMBeanProxy(objectName, interfaceClass);
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.addMembershipListener(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.universalListenerContainer.removeMembershipListener(listener);
    }

    public LocalManager getLocalManager() {
        return this.localManager;
    }

    public FederatingManager getFederatingManager() {
        return this.federatingManager;
    }

    public MBeanJMXAdapter getJMXAdapter() {
        return this.jmxAdapter;
    }

    public ManagementAgent getManagementAgent() {
        return this.agent;
    }

    public <T> T getMBeanProxy(ObjectName objectName, Class<T> interfaceClass) {
        if (!this.isStartedAndOpen()) {
            return null;
        }
        if (this.federatingManager == null) {
            return null;
        }
        if (!this.federatingManager.isRunning()) {
            return null;
        }
        return this.federatingManager.findProxy(objectName, interfaceClass);
    }

    public ObjectName registerInternalMBean(Object object, ObjectName objectName) {
        this.verifyManagementService();
        return this.jmxAdapter.registerMBean(object, objectName, true);
    }

    public boolean isManagerCreated() {
        return this.isStartedAndOpen() && this.federatingManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createManager() {
        Map map = instances;
        synchronized (map) {
            if (this.federatingManager != null) {
                return false;
            }
            this.system.handleResourceEvent(ResourceEvent.MANAGER_CREATE, null);
            this.federatingManager = this.federatingManagerFactory.create(this.repo, this.system, this, this.cache, this.statisticsFactory, this.statisticsClock, new MBeanProxyFactory(this.jmxAdapter, this), new MemberMessenger(this.jmxAdapter, this.system), () -> LoggingExecutors.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)"FederatingManager", (boolean)true));
            this.cache.getJmxManagerAdvisor().broadcastChange();
            return true;
        }
    }

    public void addProxyListener(ProxyListener listener) {
        this.proxyListeners.add(listener);
    }

    public void removeProxyListener(ProxyListener listener) {
        this.proxyListeners.remove(listener);
    }

    public void afterCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
    }

    public void afterRemoveProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterRemoveProxy(objectName, interfaceClass, proxyObject, oldVal);
        }
    }

    public void handleNotification(Notification notification) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.handleNotification(notification);
        }
    }

    void memberJoined(InternalDistributedMember id) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberJoined(this.system.getDistributionManager(), id);
        }
    }

    void memberDeparted(InternalDistributedMember id, boolean crashed) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberDeparted(this.system.getDistributionManager(), id, crashed);
        }
    }

    void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.memberSuspect(this.system.getDistributionManager(), id, whoSuspected, reason);
        }
    }

    void afterPseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterPseudoCreateProxy(objectName, interfaceClass, proxyObject, newVal);
        }
    }

    boolean isStartedAndOpen() {
        return this.isStarted && !this.closed && this.system.isConnected();
    }

    void afterUpdateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        for (ProxyListener listener : this.proxyListeners) {
            listener.afterUpdateProxy(objectName, interfaceClass, proxyObject, newVal, oldVal);
        }
    }

    UniversalListenerContainer getUniversalListenerContainer() {
        return this.universalListenerContainer;
    }

    private void verifyManagementService() {
        if (!this.isStarted) {
            throw new ManagementException("Management Service Not Started Yet");
        }
        if (!this.system.isConnected()) {
            throw new ManagementException("Not Connected To Distributed System");
        }
        if (this.closed) {
            throw new ManagementException("Management Service Is Closed");
        }
    }

    private SystemManagementService init() {
        try {
            this.localManager = this.localManagerFactory.apply(this);
            this.listener = new ManagementMembershipListener(this);
            this.localManager.startManager();
            this.system.getDistributionManager().addMembershipListener(this.listener);
            this.isStarted = true;
            return this;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ManagementException(e);
        }
    }

    private static LocalManager createLocalManager(SystemManagementService service) {
        return service.newLocalManager();
    }

    private LocalManager newLocalManager() {
        return new LocalManager(this.repo, this.system, this, this.cache, this.statisticsFactory, this.statisticsClock);
    }

    private static FederatingManagerFactory createFederatingManagerFactory() {
        try {
            String federatingManagerFactoryName = System.getProperty(FEDERATING_MANAGER_FACTORY_PROPERTY, FederatingManagerFactoryImpl.class.getName());
            Class<FederatingManagerFactory> federatingManagerFactoryClass = Class.forName(federatingManagerFactoryName).asSubclass(FederatingManagerFactory.class);
            Constructor<FederatingManagerFactory> constructor = federatingManagerFactoryClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new FederatingManagerFactoryImpl();
        }
    }

    @VisibleForTesting
    public NotificationHub getNotificationHub() {
        return this.notificationHub;
    }

    static class UniversalListenerContainer {
        private final Collection<MembershipListener> membershipListeners = new CopyOnWriteArrayList<MembershipListener>();

        UniversalListenerContainer() {
        }

        void memberJoined(InternalDistributedMember id) {
            MembershipEvent event = this.createEvent(id);
            for (MembershipListener listener : this.membershipListeners) {
                try {
                    listener.memberJoined(event);
                }
                catch (Exception e) {
                    logger.error("Could not invoke listener event memberJoined for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                }
            }
        }

        void memberDeparted(InternalDistributedMember id, boolean crashed) {
            MembershipEvent event = this.createEvent(id);
            if (crashed) {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberCrashed(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberCrashed for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                    }
                }
            } else {
                for (MembershipListener listener : this.membershipListeners) {
                    try {
                        listener.memberLeft(event);
                    }
                    catch (Exception e) {
                        logger.error("Could not invoke listener event memberLeft for listener[{}] due to ", listener.getClass(), (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }

        private void addMembershipListener(MembershipListener listener) {
            this.membershipListeners.add(listener);
        }

        private void removeMembershipListener(MembershipListener listener) {
            this.membershipListeners.remove(listener);
        }

        private MembershipEvent createEvent(final DistributedMember id) {
            return new MembershipEvent(){

                @Override
                public String getMemberId() {
                    return id.getId();
                }

                @Override
                public DistributedMember getDistributedMember() {
                    return id;
                }
            };
        }
    }

    private static class FederatingManagerFactoryImpl
    implements FederatingManagerFactory {
        @Override
        public FederatingManager create(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, MBeanProxyFactory proxyFactory, MemberMessenger messenger, Supplier<ExecutorService> executorServiceSupplier) {
            return new FederatingManager(repo, system, service, cache, statisticsFactory, statisticsClock, proxyFactory, messenger, executorServiceSupplier);
        }
    }
}

