/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.cli.UpdateAllConfigurationGroupsMarker;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.xml.sax.SAXException;

public class AlterAsyncEventQueueCommand
extends SingleGfshCommand
implements UpdateAllConfigurationGroupsMarker {
    public static final String GROUP_STATUS_SECTION = "group-status";
    static final String COMMAND_NAME = "alter async-event-queue";
    static final String ID = "id";
    static final String BATCH_SIZE = "batch-size";
    static final String BATCH_TIME_INTERVAL = "batch-time-interval";
    static final String MAX_QUEUE_MEMORY = "max-queue-memory";
    static final String MAXIMUM_QUEUE_MEMORY = "maximum-queue-memory";
    static final String COMMAND_HELP = "alter attributes of async-event-queue, needs rolling restart for new attributes to take effect. ";
    static final String ID_HELP = "Id of the async event queue to be changed.";
    static final String BATCH_SIZE_HELP = "Maximum number of events that a batch can contain.";
    static final String BATCH_TIME_INTERVAL_HELP = "Maximum amount of time, in ms, that can elapse before a batch is delivered.";
    static final String MAXIMUM_QUEUE_MEMORY_HELP = "Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.";
    static final String PAUSE_EVENT_PROCESSING = "pause-event-processing";
    static final String PAUSE_EVENT_PROCESSING_HELP = "Pause event processing when the async event queue is created";

    @CliCommand(value={"alter async-event-queue"}, help="alter attributes of async-event-queue, needs rolling restart for new attributes to take effect. ")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.AlterAsyncEventQueueCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public ResultModel execute(@CliOption(key={"id"}, mandatory=true, help="Id of the async event queue to be changed.") String id, @CliOption(key={"batch-size"}, help="Maximum number of events that a batch can contain.") Integer batchSize, @CliOption(key={"batch-time-interval"}, help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") Integer batchTimeInterval, @CliOption(key={"max-queue-memory"}, help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") Integer maxQueueMemory, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists, @CliOption(key={"pause-event-processing"}, help="Pause event processing when the async event queue is created", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean pauseEventProcessing) throws IOException, SAXException, ParserConfigurationException, TransformerException, EntityNotFoundException {
        if (this.getConfigurationPersistenceService() == null) {
            return ResultModel.createError("Cluster Configuration Service is not available. Please connect to a locator with running Cluster Configuration Service.");
        }
        if (this.findAEQ(id) == null) {
            String message = String.format("Can not find an async event queue with id '%s'.", id);
            throw new EntityNotFoundException(message, ifExists);
        }
        CacheConfig.AsyncEventQueue aeqConfiguration = new CacheConfig.AsyncEventQueue();
        aeqConfiguration.setId(id);
        aeqConfiguration.setPauseEventProcessing(Boolean.valueOf(pauseEventProcessing));
        if (batchSize != null) {
            aeqConfiguration.setBatchSize(batchSize + "");
        }
        if (batchTimeInterval != null) {
            aeqConfiguration.setBatchTimeInterval(batchTimeInterval + "");
        }
        if (maxQueueMemory != null) {
            aeqConfiguration.setMaximumQueueMemory(maxQueueMemory + "");
        }
        ResultModel result = new ResultModel();
        result.addInfo().addLine("Please restart the servers to apply any changed configuration");
        result.setConfigObject(aeqConfiguration);
        return result;
    }

    CacheConfig.AsyncEventQueue findAEQ(String aeqId) {
        CacheConfig.AsyncEventQueue queue = null;
        InternalConfigurationPersistenceService ccService = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (ccService == null) {
            return null;
        }
        Set groups = ccService.getGroups();
        for (String group : groups) {
            queue = (CacheConfig.AsyncEventQueue)Identifiable.find((List)ccService.getCacheConfig(group).getAsyncEventQueues(), (String)aeqId);
            if (queue == null) continue;
            return queue;
        }
        return queue;
    }

    @Override
    public boolean updateConfigForGroup(String group, CacheConfig config, Object configObject) {
        boolean aeqConfigsHaveBeenUpdated = false;
        List queues = config.getAsyncEventQueues();
        if (queues.isEmpty()) {
            return false;
        }
        CacheConfig.AsyncEventQueue aeqConfiguration = (CacheConfig.AsyncEventQueue)configObject;
        String aeqId = aeqConfiguration.getId();
        for (CacheConfig.AsyncEventQueue queue : queues) {
            if (!aeqId.equals(queue.getId())) continue;
            if (StringUtils.isNotBlank((CharSequence)aeqConfiguration.getBatchSize())) {
                queue.setBatchSize(aeqConfiguration.getBatchSize());
            }
            if (StringUtils.isNotBlank((CharSequence)aeqConfiguration.getBatchTimeInterval())) {
                queue.setBatchTimeInterval(aeqConfiguration.getBatchTimeInterval());
            }
            if (StringUtils.isNotBlank((CharSequence)aeqConfiguration.getMaximumQueueMemory())) {
                queue.setMaximumQueueMemory(aeqConfiguration.getMaximumQueueMemory());
            }
            if (aeqConfiguration.isPauseEventProcessing() != null) {
                queue.setPauseEventProcessing(aeqConfiguration.isPauseEventProcessing());
            }
            aeqConfigsHaveBeenUpdated = true;
        }
        return aeqConfigsHaveBeenUpdated;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public ResultModel preExecution(GfshParseResult parseResult) {
            Object batchSize = parseResult.getParamValue(AlterAsyncEventQueueCommand.BATCH_SIZE);
            Object batchTimeInterval = parseResult.getParamValue(AlterAsyncEventQueueCommand.BATCH_TIME_INTERVAL);
            Object maxQueueMemory = parseResult.getParamValue(AlterAsyncEventQueueCommand.MAX_QUEUE_MEMORY);
            if (batchSize == null && batchTimeInterval == null && maxQueueMemory == null) {
                return ResultModel.createError("need to specify at least one option to modify.");
            }
            return new ResultModel();
        }
    }
}

