/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEChainReaderWriter;
import com.linkedin.multipart.MultiPartMIMEDataSourceIterator;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.r2.message.stream.entitystream.CompositeWriter;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.util.ArgumentUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class MultiPartMIMEWriter {
    private final CompositeWriter _writer;
    private final EntityStream _entityStream;
    private final List<Writer> _allDataSources;
    private final String _rawBoundary;

    private MultiPartMIMEWriter(List<Writer> allDataSources, String rawBoundary) {
        this._allDataSources = allDataSources;
        this._rawBoundary = rawBoundary;
        this._writer = new CompositeWriter(this._allDataSources.toArray(new Writer[0]));
        this._entityStream = EntityStreams.newEntityStream((Writer)this._writer);
    }

    public void abortAllDataSources(Throwable throwable) {
        for (Writer writer : this._allDataSources) {
            writer.onAbort(throwable);
        }
    }

    public EntityStream getEntityStream() {
        return this._entityStream;
    }

    public String getBoundary() {
        return this._rawBoundary;
    }

    public static class Builder {
        private List<Writer> _allDataSources = new ArrayList<Writer>();
        private final String _preamble;
        private final String _epilogue;
        private int _dataSourceCount = 0;
        private final String _rawBoundary = MultiPartMIMEUtils.generateBoundary();
        private final byte[] _normalEncapsulationBoundary = ("\r\n--" + this._rawBoundary).getBytes(Charset.forName("US-ASCII"));
        private final byte[] _finalEncapsulationBoundary = ("\r\n--" + this._rawBoundary + "--").getBytes(Charset.forName("US-ASCII"));

        public Builder(String preamble, String epilogue) {
            ArgumentUtil.notNull((Object)preamble, (String)"preamble");
            ArgumentUtil.notNull((Object)epilogue, (String)"epilogue");
            this._preamble = preamble;
            this._epilogue = epilogue;
            if (!this._preamble.equalsIgnoreCase("")) {
                ByteStringWriter preambleWriter = new ByteStringWriter(ByteString.copyString((String)this._preamble, (Charset)Charset.forName("US-ASCII")));
                this._allDataSources.add((Writer)preambleWriter);
            }
        }

        public Builder() {
            this("", "");
        }

        public Builder appendDataSource(MultiPartMIMEDataSourceWriter dataSource) {
            ByteString serializedBoundaryAndHeaders = null;
            try {
                serializedBoundaryAndHeaders = MultiPartMIMEUtils.serializeBoundaryAndHeaders(this._normalEncapsulationBoundary, dataSource);
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Serious error when constructing local byte buffer for the boundary and headers!");
            }
            ByteStringWriter boundaryHeaderWriter = new ByteStringWriter(serializedBoundaryAndHeaders);
            this._allDataSources.add((Writer)boundaryHeaderWriter);
            this._allDataSources.add(dataSource);
            ++this._dataSourceCount;
            return this;
        }

        public Builder appendDataSourceIterator(MultiPartMIMEDataSourceIterator multiPartMIMEDataSourceIterator) {
            MultiPartMIMEChainReaderWriter multiPartMIMEReaderWriter = new MultiPartMIMEChainReaderWriter(multiPartMIMEDataSourceIterator, this._normalEncapsulationBoundary);
            this._allDataSources.add(multiPartMIMEReaderWriter);
            ++this._dataSourceCount;
            return this;
        }

        public Builder appendDataSources(List<MultiPartMIMEDataSourceWriter> dataSources) {
            for (MultiPartMIMEDataSourceWriter dataSource : dataSources) {
                this.appendDataSource(dataSource);
            }
            return this;
        }

        public Builder prependDataSource(MultiPartMIMEDataSourceWriter dataSource) {
            ByteString serializedBoundaryAndHeaders = null;
            try {
                serializedBoundaryAndHeaders = MultiPartMIMEUtils.serializeBoundaryAndHeaders(this._normalEncapsulationBoundary, dataSource);
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Serious error when constructing local byte buffer for the boundary and headers!");
            }
            ByteStringWriter boundaryHeaderWriter = new ByteStringWriter(serializedBoundaryAndHeaders);
            if (!this._preamble.equalsIgnoreCase("")) {
                this._allDataSources.add(1, dataSource);
                this._allDataSources.add(1, (Writer)boundaryHeaderWriter);
            } else {
                this._allDataSources.add(0, dataSource);
                this._allDataSources.add(0, (Writer)boundaryHeaderWriter);
            }
            ++this._dataSourceCount;
            return this;
        }

        public int getCurrentSize() {
            return this._dataSourceCount;
        }

        public MultiPartMIMEWriter build() {
            ByteArrayOutputStream finalBoundaryByteArrayOutputStream = new ByteArrayOutputStream();
            try {
                finalBoundaryByteArrayOutputStream.write(this._finalEncapsulationBoundary);
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Serious error when constructing local byte buffer for the final boundary!");
            }
            ByteStringWriter finalBoundaryWriter = new ByteStringWriter(ByteString.copy((byte[])finalBoundaryByteArrayOutputStream.toByteArray()));
            this._allDataSources.add((Writer)finalBoundaryWriter);
            if (!this._epilogue.equalsIgnoreCase("")) {
                ByteStringWriter epilogueWriter = new ByteStringWriter(ByteString.copyString((String)this._epilogue, (Charset)Charset.forName("US-ASCII")));
                this._allDataSources.add((Writer)epilogueWriter);
            }
            return new MultiPartMIMEWriter(this._allDataSources, this._rawBoundary);
        }
    }
}

