/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.DelayedExecutor;
import com.linkedin.parseq.EngineShutdownException;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.TaskQueueFactory;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.ContextImpl;
import com.linkedin.parseq.internal.PlanCompletionListener;
import com.linkedin.parseq.internal.PlanContext;
import com.linkedin.parseq.internal.PlanDeactivationListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    public static final String LOGGER_BASE = Engine.class.getName();
    public static final String MAX_RELATIONSHIPS_PER_TRACE = "_MaxRelationshipsPerTrace_";
    private static final int DEFUALT_MAX_RELATIONSHIPS_PER_TRACE = 4096;
    public static final String MAX_CONCURRENT_PLANS = "_MaxConcurrentPlans_";
    private static final int DEFUALT_MAX_CONCURRENT_PLANS = Integer.MAX_VALUE;
    private static final State INIT = new State(StateName.RUN, 0L);
    private static final State TERMINATED = new State(StateName.TERMINATED, 0L);
    private static final Logger LOG = LoggerFactory.getLogger((String)LOGGER_BASE);
    private final Executor _taskExecutor;
    private final DelayedExecutor _timerExecutor;
    private final ILoggerFactory _loggerFactory;
    private final TaskQueueFactory _taskQueueFactory;
    private final AtomicReference<State> _stateRef = new AtomicReference<State>(INIT);
    private final CountDownLatch _terminated = new CountDownLatch(1);
    private final Map<String, Object> _properties;
    private final int _maxRelationshipsPerTrace;
    private final int _maxConcurrentPlans;
    private final Semaphore _concurrentPlans;
    private final PlanDeactivationListener _planDeactivationListener;
    private final PlanCompletionListener _planCompletionListener;
    private final PlanCompletionListener _taskDoneListener;
    private final Logger _allLogger;
    private final Logger _rootLogger;

    Engine(Executor taskExecutor, DelayedExecutor timerExecutor, ILoggerFactory loggerFactory, Map<String, Object> properties, PlanDeactivationListener planActivityListener, PlanCompletionListener planCompletionListener, TaskQueueFactory taskQueueFactory) {
        this._taskExecutor = taskExecutor;
        this._timerExecutor = timerExecutor;
        this._loggerFactory = loggerFactory;
        this._properties = properties;
        this._planDeactivationListener = planActivityListener;
        this._taskQueueFactory = taskQueueFactory;
        this._allLogger = loggerFactory.getLogger(LOGGER_BASE + ":all");
        this._rootLogger = loggerFactory.getLogger(LOGGER_BASE + ":root");
        this._maxRelationshipsPerTrace = this._properties.containsKey(MAX_RELATIONSHIPS_PER_TRACE) ? (Integer)this.getProperty(MAX_RELATIONSHIPS_PER_TRACE) : 4096;
        this._maxConcurrentPlans = this._properties.containsKey(MAX_CONCURRENT_PLANS) ? (Integer)this.getProperty(MAX_CONCURRENT_PLANS) : Integer.MAX_VALUE;
        this._concurrentPlans = new Semaphore(this._maxConcurrentPlans);
        this._taskDoneListener = resolvedPromise -> {
            State newState;
            State currState;
            assert (this._stateRef.get()._pendingCount > 0L);
            assert (this._stateRef.get()._stateName != StateName.TERMINATED);
            while (!this._stateRef.compareAndSet(currState = this._stateRef.get(), newState = new State(currState._stateName, currState._pendingCount - 1L))) {
            }
            this._concurrentPlans.release();
            if (newState._stateName == StateName.SHUTDOWN && newState._pendingCount == 0L) {
                this.tryTransitionTerminate();
            }
        };
        this._planCompletionListener = planContext -> {
            try {
                planCompletionListener.onPlanCompleted(planContext);
            }
            catch (Throwable t) {
                LOG.error("Uncaught throwable from custom PlanCompletionListener.", t);
            }
            finally {
                this._taskDoneListener.onPlanCompleted(planContext);
            }
        };
    }

    public Object getProperty(String key) {
        return this._properties.get(key);
    }

    private final String defaultPlanClass(Task<?> task) {
        return task.getClass().getName();
    }

    public void run(Task<?> task) {
        this.run(task, this.defaultPlanClass(task));
    }

    public void run(Task<?> task, String planClass) {
        if (!this.tryRun(task, planClass)) {
            throw new IllegalStateException("Starting new plan rejected, exceeded limit of concurrent plans: " + this._maxConcurrentPlans);
        }
    }

    public void blockingRun(Task<?> task) {
        this.blockingRun(task, this.defaultPlanClass(task));
    }

    public void blockingRun(Task<?> task, String planClass) {
        try {
            this._concurrentPlans.acquire();
            this.runWithPermit(task, planClass);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean tryRun(Task<?> task) {
        return this.tryRun(task, this.defaultPlanClass(task));
    }

    public boolean tryRun(Task<?> task, String planClass) {
        if (this._concurrentPlans.tryAcquire()) {
            this.runWithPermit(task, planClass);
            return true;
        }
        return false;
    }

    public boolean tryRun(Task<?> task, long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryRun(task, this.defaultPlanClass(task), timeout, unit);
    }

    public boolean tryRun(Task<?> task, String planClass, long timeout, TimeUnit unit) throws InterruptedException {
        if (this._concurrentPlans.tryAcquire(timeout, unit)) {
            this.runWithPermit(task, planClass);
            return true;
        }
        return false;
    }

    private void runWithPermit(Task<?> task, String planClass) {
        State newState;
        State currState;
        ArgumentUtil.requireNotNull(task, "task");
        ArgumentUtil.requireNotNull(planClass, "planClass");
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.RUN) continue;
            task.cancel(new EngineShutdownException("Task submitted after engine shutdown"));
            return;
        } while (!this._stateRef.compareAndSet(currState, newState = new State(StateName.RUN, currState._pendingCount + 1L)));
        PlanContext planContext = new PlanContext(this, this._taskExecutor, this._timerExecutor, this._loggerFactory, this._allLogger, this._rootLogger, planClass, task, this._maxRelationshipsPerTrace, this._planDeactivationListener, this._planCompletionListener, this._taskQueueFactory.newTaskQueue());
        new ContextImpl(planContext, task).runTask();
    }

    public void shutdown() {
        if (this.tryTransitionShutdown()) {
            this.tryTransitionTerminate();
        }
    }

    public boolean isShutdown() {
        return this._stateRef.get()._stateName != StateName.RUN;
    }

    public boolean isTerminated() {
        return this._stateRef.get()._stateName == StateName.TERMINATED;
    }

    public boolean awaitTermination(int time, TimeUnit unit) throws InterruptedException {
        return this._terminated.await(time, unit);
    }

    private boolean tryTransitionShutdown() {
        State newState;
        State currState;
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.RUN) continue;
            return false;
        } while (!this._stateRef.compareAndSet(currState, newState = new State(StateName.SHUTDOWN, currState._pendingCount)));
        return true;
    }

    private void tryTransitionTerminate() {
        State currState;
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.SHUTDOWN && currState._pendingCount == 0L) continue;
            return;
        } while (!this._stateRef.compareAndSet(currState, TERMINATED));
        this._terminated.countDown();
    }

    private static class State {
        private final StateName _stateName;
        private final long _pendingCount;

        private State(StateName stateName, long pendingCount) {
            this._pendingCount = pendingCount;
            this._stateName = stateName;
        }
    }

    private static enum StateName {
        RUN,
        SHUTDOWN,
        TERMINATED;

    }
}

