/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry.termination;

import com.linkedin.parseq.retry.termination.LimitAttempts;
import com.linkedin.parseq.retry.termination.LimitDuration;
import com.linkedin.parseq.retry.termination.RequireBoth;
import com.linkedin.parseq.retry.termination.RequireEither;

public interface TerminationPolicy {
    public boolean shouldTerminate(int var1, long var2);

    public static TerminationPolicy limitAttempts(int maxAttempts) {
        return new LimitAttempts(maxAttempts);
    }

    public static TerminationPolicy limitDuration(long maxDuration) {
        return new LimitDuration(maxDuration);
    }

    public static TerminationPolicy requireBoth(TerminationPolicy first, TerminationPolicy second) {
        return new RequireBoth(first, second);
    }

    public static TerminationPolicy requireEither(TerminationPolicy first, TerminationPolicy second) {
        return new RequireEither(first, second);
    }

    public static TerminationPolicy alwaysTerminate() {
        return (attempts, nextAttemptAt) -> true;
    }

    public static TerminationPolicy neverTerminate() {
        return (attempts, nextAttemptAt) -> false;
    }
}

