/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.gobblin.hive.avro.HiveAvroSerDeManager;
import org.apache.hadoop.fs.Path;

@Alpha
public abstract class HiveSerDeManager {
    public static final String HIVE_ROW_FORMAT = "hive.row.format";
    protected final State props;

    protected HiveSerDeManager(State props) {
        this.props = props;
    }

    public abstract void addSerDeProperties(Path var1, HiveRegistrationUnit var2) throws IOException;

    public abstract void addSerDeProperties(HiveRegistrationUnit var1, HiveRegistrationUnit var2) throws IOException;

    public abstract void updateSchema(HiveRegistrationUnit var1, HiveRegistrationUnit var2) throws IOException;

    public abstract boolean haveSameSchema(HiveRegistrationUnit var1, HiveRegistrationUnit var2) throws IOException;

    public static HiveSerDeManager get(State props) {
        String type = props.getProp(HIVE_ROW_FORMAT, Implementation.AVRO.name());
        Optional implementation = Enums.getIfPresent(Implementation.class, (String)type.toUpperCase());
        try {
            if (implementation.isPresent()) {
                return (HiveSerDeManager)ConstructorUtils.invokeConstructor(Class.forName(((Implementation)((Object)implementation.get())).toString()), (Object[])new Object[]{props});
            }
            return (HiveSerDeManager)ConstructorUtils.invokeConstructor(Class.forName(type), (Object[])new Object[]{props});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to instantiate " + HiveSerDeManager.class.getSimpleName() + " with type " + type, e);
        }
    }

    public static enum Implementation {
        AVRO(HiveAvroSerDeManager.class.getName());

        private final String schemaManagerClassName;

        private Implementation(String schemaManagerClassName) {
            this.schemaManagerClassName = schemaManagerClassName;
        }

        public String toString() {
            return this.schemaManagerClassName;
        }
    }
}

