/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cli;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.List;

public class CliTablePrinter {
    private List<String> labels;
    private List<String> flags;
    private int indentation;
    private int delimiterWidth;
    private List<List<String>> data;
    private String rowFormat;

    public CliTablePrinter(List<String> labels, List<String> flags, int indentation, int delimiterWidth, List<List<String>> data) {
        Preconditions.checkArgument((data.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((data.get(0).size() > 0 ? 1 : 0) != 0);
        if (labels != null) {
            Preconditions.checkArgument((data.get(0).size() == labels.size() ? 1 : 0) != 0);
        }
        if (flags != null) {
            Preconditions.checkArgument((data.get(0).size() == flags.size() ? 1 : 0) != 0);
        }
        this.labels = labels;
        this.flags = flags;
        this.indentation = indentation;
        this.delimiterWidth = delimiterWidth;
        this.data = data;
        this.rowFormat = this.getRowFormat(this.getColumnMaxWidths());
    }

    public void printTable() {
        if (this.labels != null) {
            System.out.printf(this.rowFormat, this.labels.toArray());
        }
        for (List<String> row : this.data) {
            System.out.printf(this.rowFormat, row.toArray());
        }
    }

    private List<Integer> getColumnMaxWidths() {
        int numCols = this.data.get(0).size();
        int[] widths = new int[numCols];
        if (this.labels != null) {
            for (int i = 0; i < numCols; ++i) {
                widths[i] = this.labels.get(i).length();
            }
        }
        for (List<String> row : this.data) {
            for (int i = 0; i < row.size(); ++i) {
                widths[i] = row.get(i) == null ? Math.max(widths[i], 4) : Math.max(widths[i], row.get(i).length());
            }
        }
        return Ints.asList((int[])widths);
    }

    private String getRowFormat(List<Integer> widths) {
        StringBuilder rowFormat = new StringBuilder(CliTablePrinter.spaces(this.indentation));
        for (int i = 0; i < widths.size(); ++i) {
            rowFormat.append("%");
            rowFormat.append(this.flags != null ? this.flags.get(i) : "");
            rowFormat.append(widths.get(i).toString());
            rowFormat.append("s");
            rowFormat.append(CliTablePrinter.spaces(this.delimiterWidth));
        }
        rowFormat.append("\n");
        return rowFormat.toString();
    }

    private static String spaces(int numSpaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static final class Builder {
        private List<String> labels;
        private List<String> flags;
        private int indentation;
        private int delimiterWidth = 1;
        private List<List<String>> data;

        public Builder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder data(List<List<String>> data) {
            this.data = data;
            return this;
        }

        public Builder indentation(int indentation) {
            this.indentation = indentation;
            return this;
        }

        public Builder delimiterWidth(int delimiterWidth) {
            this.delimiterWidth = delimiterWidth;
            return this;
        }

        public Builder flags(List<String> flags) {
            this.flags = flags;
            return this;
        }

        public CliTablePrinter build() {
            return new CliTablePrinter(this.labels, this.flags, this.indentation, this.delimiterWidth, this.data);
        }
    }
}

