/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.restli.common.ResourceMethod;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Queue;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.r2.R2Request;
import org.apache.gobblin.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RestRequestBuilder
implements AsyncRequestBuilder<GenericRecord, RestRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(R2RestRequestBuilder.class);
    private static final JacksonDataCodec JACKSON_DATA_CODEC = new JacksonDataCodec();
    private final String urlTemplate;
    private final ResourceMethod method;
    private final String protocolVersion;

    public R2RestRequestBuilder(String urlTemplate, String verb, String protocolVersion) {
        this.urlTemplate = urlTemplate;
        this.method = ResourceMethod.fromString((String)verb);
        this.protocolVersion = protocolVersion;
    }

    public R2Request<GenericRecord> buildRequest(Queue<BufferedRecord<GenericRecord>> buffer) {
        return this.buildWriteRequest(buffer.poll());
    }

    private R2Request<GenericRecord> buildWriteRequest(BufferedRecord<GenericRecord> record) {
        if (record == null) {
            return null;
        }
        R2Request<GenericRecord> request = new R2Request<GenericRecord>();
        HttpOperation httpOperation = HttpUtils.toHttpOperation((GenericRecord)record.getRecord());
        URI uri = HttpUtils.buildURI(this.urlTemplate, httpOperation.getKeys(), httpOperation.getQueryParams());
        if (uri == null) {
            return null;
        }
        RestRequestBuilder builder = (RestRequestBuilder)new RestRequestBuilder(uri).setMethod(this.method.getHttpMethod().toString());
        Map<String, String> headers = httpOperation.getHeaders();
        if (headers != null && headers.size() != 0) {
            builder.setHeaders(headers);
        }
        builder.setHeader("X-RestLi-Protocol-Version", this.protocolVersion);
        builder.setHeader("X-RestLi-Method", this.method.toString());
        int bytesWritten = this.addPayload(builder, httpOperation.getBody());
        if (bytesWritten == -1) {
            throw new RuntimeException("Fail to write payload into request");
        }
        request.markRecord(record, bytesWritten);
        request.setRawRequest(this.build(builder));
        return request;
    }

    protected int addPayload(RestRequestBuilder builder, String payload) {
        if (payload == null || payload.length() == 0) {
            return 0;
        }
        builder.setHeader("Content-Type", "application/json");
        try {
            DataMap data = JACKSON_DATA_CODEC.stringToMap(payload);
            byte[] bytes = JACKSON_DATA_CODEC.mapToBytes(data);
            builder.setEntity(bytes);
            return bytes.length;
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to convert payload: " + payload, e);
        }
    }

    @VisibleForTesting
    public RestRequest build(RestRequestBuilder builder) {
        return builder.build();
    }
}

