/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

public class AppMasterEventOperator
extends Operator<AppMasterEventDesc> {
    protected transient Serializer serializer;
    protected transient DataOutputBuffer buffer;
    protected transient boolean hasReachedMaxSize = false;
    protected transient long MAX_SIZE;

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.MAX_SIZE = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING_MAX_EVENT_SIZE);
        this.serializer = (Serializer)ReflectionUtils.newInstance(((AppMasterEventDesc)this.conf).getTable().getDeserializerClass(), null);
        this.initDataBuffer(false);
    }

    protected void initDataBuffer(boolean skipPruning) throws HiveException {
        this.buffer = new DataOutputBuffer();
        try {
            ((AppMasterEventDesc)this.getConf()).writeEventHeader(this.buffer);
            this.buffer.writeBoolean(skipPruning);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.hasReachedMaxSize) {
            return;
        }
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        try {
            Writable writableRow = this.serializer.serialize(row, rowInspector);
            writableRow.write((DataOutput)this.buffer);
            if ((long)this.buffer.getLength() > this.MAX_SIZE) {
                this.LOG.info((Object)("Disabling AM events. Buffer size too large: " + this.buffer.getLength()));
                this.hasReachedMaxSize = true;
                this.buffer = null;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("AppMasterEvent: " + row));
        }
        this.forward(row, rowInspector);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            TezContext context = (TezContext)TezContext.get();
            String vertexName = ((AppMasterEventDesc)this.getConf()).getVertexName();
            String inputName = ((AppMasterEventDesc)this.getConf()).getInputName();
            byte[] payload = null;
            if (this.hasReachedMaxSize) {
                this.initDataBuffer(true);
            }
            payload = new byte[this.buffer.getLength()];
            System.arraycopy(this.buffer.getData(), 0, payload, 0, this.buffer.getLength());
            InputInitializerEvent event = InputInitializerEvent.create((String)vertexName, (String)inputName, (ByteBuffer)ByteBuffer.wrap(payload, 0, payload.length));
            this.LOG.info((Object)("Sending Tez event to vertex = " + vertexName + ", input = " + inputName + ". Payload size = " + payload.length));
            context.getTezProcessorContext().sendEvents(Collections.singletonList(event));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.EVENT;
    }

    @Override
    public String getName() {
        return AppMasterEventOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "EVENT";
    }
}

