/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.optiq.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Pair;

public class PartitionPruner {
    public static Pair<RexNode, RexNode> extractPartitionPredicates(RelOptCluster cluster, RelOptHiveTable hiveTable, RexNode predicate) {
        RexNode partitionPruningPred = (RexNode)predicate.accept((RexVisitor)new ExtractPartPruningPredicate(cluster, hiveTable));
        RexNode remainingPred = (RexNode)predicate.accept((RexVisitor)new ExtractRemainingPredicate(cluster, partitionPruningPred));
        return new Pair((Object)partitionPruningPred, (Object)remainingPred);
    }

    public static class ExtractRemainingPredicate
    extends RexVisitorImpl<RexNode> {
        List<RexNode> pruningPredicates;
        final RelOptCluster cluster;

        public ExtractRemainingPredicate(RelOptCluster cluster, RexNode partPruningExpr) {
            super(true);
            this.cluster = cluster;
            this.pruningPredicates = new ArrayList<RexNode>();
            this.flattenPredicates(partPruningExpr);
        }

        private void flattenPredicates(RexNode r) {
            if (r instanceof RexCall && ((RexCall)r).getOperator() == SqlStdOperatorTable.AND) {
                for (RexNode c : ((RexCall)r).getOperands()) {
                    this.flattenPredicates(c);
                }
            } else {
                this.pruningPredicates.add(r);
            }
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return inputRef;
        }

        public RexNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            if (call.getOperator() != SqlStdOperatorTable.AND) {
                if (this.pruningPredicates.contains(call)) {
                    return null;
                }
                return call;
            }
            LinkedList<RexNode> args = new LinkedList<RexNode>();
            for (RexNode operand : call.operands) {
                RexNode n = (RexNode)operand.accept((RexVisitor)this);
                if (n == null) continue;
                args.add(n);
            }
            if (args.size() == 0) {
                return null;
            }
            if (args.size() == 1) {
                return (RexNode)args.get(0);
            }
            return this.cluster.getRexBuilder().makeCall(call.getOperator(), args);
        }
    }

    public static class ExtractPartPruningPredicate
    extends RexVisitorImpl<RexNode> {
        final RelOptHiveTable hiveTable;
        final RelDataType rType;
        final Set<String> partCols;
        final RelOptCluster cluster;

        public ExtractPartPruningPredicate(RelOptCluster cluster, RelOptHiveTable hiveTable) {
            super(true);
            this.hiveTable = hiveTable;
            this.rType = hiveTable.getRowType();
            List<FieldSchema> pfs = hiveTable.getHiveTableMD().getPartCols();
            this.partCols = new HashSet<String>();
            for (FieldSchema pf : pfs) {
                this.partCols.add(pf.getName());
            }
            this.cluster = cluster;
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataTypeField f = (RelDataTypeField)this.rType.getFieldList().get(inputRef.getIndex());
            if (this.partCols.contains(f.getName())) {
                return inputRef;
            }
            return null;
        }

        public RexNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            LinkedList<RexNode> args = new LinkedList<RexNode>();
            boolean argsPruned = false;
            GenericUDF hiveUDF = SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), call.operands.size());
            if (hiveUDF != null && !FunctionRegistry.isDeterministic(hiveUDF)) {
                return null;
            }
            for (RexNode operand : call.operands) {
                RexNode n = (RexNode)operand.accept((RexVisitor)this);
                if (n != null) {
                    args.add(n);
                    continue;
                }
                argsPruned = true;
            }
            if (call.getOperator() != SqlStdOperatorTable.AND) {
                return argsPruned ? null : call;
            }
            if (args.size() == 0) {
                return null;
            }
            if (args.size() == 1) {
                return (RexNode)args.get(0);
            }
            return this.cluster.getRexBuilder().makeCall(call.getOperator(), args);
        }
    }
}

