/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AvaticaUtils {
    private static final Map<Class, Class> BOX = new HashMap<Class, Class>();

    private AvaticaUtils() {
    }

    public static void discard(Object o) {
    }

    public static List<?> primitiveList(final Object array) {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return Array.get(array, index);
            }

            @Override
            public int size() {
                return Array.getLength(array);
            }
        };
    }

    public static String camelToUpper(String name) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        int nextUpper = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextUpper = i + 1;
                continue;
            }
            c = nextUpper == i ? Character.toUpperCase(c) : Character.toLowerCase(c);
            buf.append(c);
        }
        return buf.toString();
    }

    public static Class box(Class clazz) {
        if (clazz.isPrimitive()) {
            return BOX.get(clazz);
        }
        return clazz;
    }

    static {
        BOX.put(Boolean.TYPE, Boolean.class);
        BOX.put(Byte.TYPE, Byte.class);
        BOX.put(Character.TYPE, Character.class);
        BOX.put(Short.TYPE, Short.class);
        BOX.put(Integer.TYPE, Integer.class);
        BOX.put(Long.TYPE, Long.class);
        BOX.put(Float.TYPE, Float.class);
        BOX.put(Double.TYPE, Double.class);
    }
}

