/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ForkOperatorUtils;

public class CompressionConfigParser {
    private static final String COMPRESSION_TYPE_KEY = "type";

    public static Map<String, Object> getConfigForBranch(State taskState, int numBranches, int branch) {
        String typePropertyName = ForkOperatorUtils.getPropertyNameForBranch((String)"writer.codec.type", (int)numBranches, (int)branch);
        String compressionType = taskState.getProp(typePropertyName);
        if (compressionType == null) {
            return null;
        }
        return ImmutableMap.of((Object)COMPRESSION_TYPE_KEY, (Object)compressionType);
    }

    public static String getCompressionType(Map<String, Object> properties) {
        return (String)properties.get(COMPRESSION_TYPE_KEY);
    }

    private CompressionConfigParser() {
    }
}

