/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Optional;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.NonNull;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.metadata.GlobalMetadata;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.stream.ControlMessage;
import org.apache.gobblin.stream.RecordEnvelope;

@Alpha
public abstract class AsyncConverter1to1<SI, SO, DI, DO>
extends Converter<SI, SO, DI, DO> {
    public static final String MAX_CONCURRENT_ASYNC_CONVERSIONS_KEY = "gobblin.converter.maxConcurrentAsyncConversions";
    public static final int DEFAULT_MAX_CONCURRENT_ASYNC_CONVERSIONS = 20;

    public abstract SO convertSchema(SI var1, WorkUnitState var2) throws SchemaConversionException;

    public final Iterable<DO> convertRecord(SO outputSchema, DI inputRecord, WorkUnitState workUnit) throws DataConversionException {
        throw new UnsupportedOperationException("Async converters are only supported in stream mode. Make sure to set task.execution.synchronousExecutionModel to false.");
    }

    protected abstract CompletableFuture<DO> convertRecordAsync(SO var1, DI var2, WorkUnitState var3) throws DataConversionException;

    public RecordStreamWithMetadata<DO, SO> processStream(RecordStreamWithMetadata<DI, SI> inputStream, WorkUnitState workUnitState) throws SchemaConversionException {
        int maxConcurrentAsyncConversions = workUnitState.getPropAsInt(MAX_CONCURRENT_ASYNC_CONVERSIONS_KEY, 20);
        SO outputSchema = this.convertSchema(inputStream.getGlobalMetadata().getSchema(), workUnitState);
        Flowable outputStream = inputStream.getRecordStream().flatMapSingle(in -> {
            if (in instanceof ControlMessage) {
                this.getMessageHandler().handleMessage((ControlMessage)in);
                return Single.just((Object)((ControlMessage)in));
            }
            if (in instanceof RecordEnvelope) {
                RecordEnvelope recordEnvelope = (RecordEnvelope)in;
                return new SingleAsync(recordEnvelope, this.convertRecordAsync(outputSchema, recordEnvelope.getRecord(), workUnitState));
            }
            throw new IllegalStateException("Expected ControlMessage or RecordEnvelope.");
        }, false, maxConcurrentAsyncConversions);
        return inputStream.withRecordStream(outputStream, GlobalMetadata.builderWithInput((GlobalMetadata)inputStream.getGlobalMetadata(), (Optional)Optional.fromNullable(outputSchema)).build());
    }

    private class SingleAsync
    extends Single<RecordEnvelope<DO>> {
        private final RecordEnvelope<DI> originalRecord;
        private final CompletableFuture<DO> completableFuture;

        protected void subscribeActual(@NonNull SingleObserver<? super RecordEnvelope<DO>> observer) {
            ((CompletableFuture)this.completableFuture.thenAccept(d -> observer.onSuccess((Object)this.originalRecord.withRecord(d)))).exceptionally(t -> {
                observer.onError(t);
                return null;
            });
        }

        @ConstructorProperties(value={"originalRecord", "completableFuture"})
        public SingleAsync(RecordEnvelope<DI> originalRecord, CompletableFuture<DO> completableFuture) {
            this.originalRecord = originalRecord;
            this.completableFuture = completableFuture;
        }
    }
}

