/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.RecordMetadata;

@Alpha
public final class RecordFuture
implements Future<RecordMetadata> {
    CountDownLatch latch;
    long offset;

    public RecordFuture(CountDownLatch latch, long offset) {
        this.latch = latch;
        this.offset = offset;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return new RecordMetadata(this.offset);
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean occurred = this.latch.await(timeout, unit);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit));
        }
        return new RecordMetadata(this.offset);
    }
}

