/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.filebased.FileBasedExtractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.hadoop.AvroFsHelper;

public class AvroFileExtractor
extends FileBasedExtractor<Schema, GenericRecord> {
    public AvroFileExtractor(WorkUnitState workUnitState) {
        super(workUnitState, new AvroFsHelper((State)workUnitState));
    }

    @Override
    public Iterator<GenericRecord> downloadFile(String file) throws IOException {
        try {
            return (Iterator)((Object)this.closer.register(((AvroFsHelper)this.fsHelper).getAvroFile(file)));
        }
        catch (FileBasedHelperException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    @Override
    public Schema getSchema() {
        if (this.workUnit.contains("source.schema")) {
            return new Schema.Parser().parse(this.workUnit.getProp("source.schema"));
        }
        AvroFsHelper hfsHelper = (AvroFsHelper)this.fsHelper;
        if (this.filesToPull.isEmpty()) {
            return null;
        }
        try {
            return hfsHelper.getAvroSchema((String)this.filesToPull.get(0));
        }
        catch (FileBasedHelperException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }
}

