/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.SizeAwareFileBasedHelper;
import org.apache.gobblin.source.extractor.hadoop.HadoopFsHelper;
import org.apache.gobblin.source.extractor.utils.ProxyFsInput;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroFsHelper
extends HadoopFsHelper
implements SizeAwareFileBasedHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroFsHelper.class);

    public AvroFsHelper(State state) {
        this(state, HadoopUtils.newConfiguration());
    }

    public AvroFsHelper(State state, Configuration configuration) {
        super(state, configuration);
    }

    public Schema getAvroSchema(String file) throws FileBasedHelperException {
        DataFileReader dfr = null;
        try {
            dfr = this.getState().getPropAsBoolean("should.fs.proxy.as.user", false) ? new DataFileReader((SeekableInput)new ProxyFsInput(new Path(file), this.getFileSystem()), (DatumReader)new GenericDatumReader()) : new DataFileReader((SeekableInput)new FsInput(new Path(file), this.getFileSystem().getConf()), (DatumReader)new GenericDatumReader());
            Schema schema = dfr.getSchema();
            return schema;
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Failed to open avro file " + file + " due to error " + e.getMessage(), e);
        }
        finally {
            if (dfr != null) {
                try {
                    dfr.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close avro file " + file, (Throwable)e);
                }
            }
        }
    }

    public DataFileReader<GenericRecord> getAvroFile(String file) throws FileBasedHelperException {
        try {
            if (!this.getFileSystem().exists(new Path(file))) {
                LOGGER.warn(file + " does not exist.");
                return null;
            }
            if (this.getState().getPropAsBoolean("should.fs.proxy.as.user", false)) {
                return new DataFileReader((SeekableInput)new ProxyFsInput(new Path(file), this.getFileSystem()), (DatumReader)new GenericDatumReader());
            }
            return new DataFileReader((SeekableInput)new FsInput(new Path(file), this.getFileSystem().getConf()), (DatumReader)new GenericDatumReader());
        }
        catch (IOException e) {
            throw new FileBasedHelperException("Failed to open avro file " + file + " due to error " + e.getMessage(), e);
        }
    }

    @Override
    public long getFileSize(String filePath) throws FileBasedHelperException {
        try {
            return this.getFileSystem().getFileStatus(new Path(filePath)).getLen();
        }
        catch (IOException e) {
            throw new FileBasedHelperException(String.format("Failed to get size for file at path %s due to error %s", filePath, e.getMessage()), e);
        }
    }
}

