/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import java.io.IOException;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.hadoop.mapreduce.RecordReader;

public abstract class HadoopFileInputExtractor<S, D, K, V>
implements Extractor<S, D> {
    private final RecordReader<K, V> recordReader;
    private final boolean readKeys;

    public HadoopFileInputExtractor(RecordReader<K, V> recordReader, boolean readKeys) {
        this.recordReader = recordReader;
        this.readKeys = readKeys;
    }

    public D readRecord(@Deprecated D reuse) throws DataRecordException, IOException {
        try {
            if (this.recordReader.nextKeyValue()) {
                return (D)(this.readKeys ? this.recordReader.getCurrentKey() : this.recordReader.getCurrentValue());
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return null;
    }

    public long getExpectedRecordCount() {
        return -1L;
    }

    public long getHighWatermark() {
        return -1L;
    }

    public void close() throws IOException {
        this.recordReader.close();
    }
}

