/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.clientgen;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.jersey.api.uri.UriTemplate;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.JavaCodeGeneratorBase;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.restli.client.OptionsRequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.client.base.ActionRequestBuilderBase;
import com.linkedin.restli.client.base.BatchCreateIdEntityRequestBuilderBase;
import com.linkedin.restli.client.base.BatchCreateIdRequestBuilderBase;
import com.linkedin.restli.client.base.BatchCreateRequestBuilderBase;
import com.linkedin.restli.client.base.BatchDeleteRequestBuilderBase;
import com.linkedin.restli.client.base.BatchGetEntityRequestBuilderBase;
import com.linkedin.restli.client.base.BatchGetRequestBuilderBase;
import com.linkedin.restli.client.base.BatchPartialUpdateRequestBuilderBase;
import com.linkedin.restli.client.base.BatchUpdateRequestBuilderBase;
import com.linkedin.restli.client.base.BuilderBase;
import com.linkedin.restli.client.base.CreateIdEntityRequestBuilderBase;
import com.linkedin.restli.client.base.CreateIdRequestBuilderBase;
import com.linkedin.restli.client.base.CreateRequestBuilderBase;
import com.linkedin.restli.client.base.DeleteRequestBuilderBase;
import com.linkedin.restli.client.base.FindRequestBuilderBase;
import com.linkedin.restli.client.base.GetAllRequestBuilderBase;
import com.linkedin.restli.client.base.GetRequestBuilderBase;
import com.linkedin.restli.client.base.PartialUpdateRequestBuilderBase;
import com.linkedin.restli.client.base.UpdateRequestBuilderBase;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.ResourceSpecImpl;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.common.validation.RestLiDataValidator;
import com.linkedin.restli.internal.common.RestliVersion;
import com.linkedin.restli.internal.common.URIParamUtils;
import com.linkedin.restli.internal.tools.RestLiToolsUtils;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.FinderSchemaArray;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.ResourceSchemaArray;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestMethodSchemaArray;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.util.CustomTypeUtil;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRequestBuilderGenerator
extends JavaCodeGeneratorBase {
    private static final Logger _log = LoggerFactory.getLogger(JavaRequestBuilderGenerator.class);
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final RestSpecCodec _codec = new RestSpecCodec();
    private static final List<ResourceMethod> _validateEntityMethods = Arrays.asList(ResourceMethod.CREATE, ResourceMethod.UPDATE, ResourceMethod.BATCH_CREATE, ResourceMethod.BATCH_UPDATE);
    private static final List<ResourceMethod> _validatePatchMethods = Arrays.asList(ResourceMethod.PARTIAL_UPDATE, ResourceMethod.BATCH_PARTIAL_UPDATE);
    private static final Map<RestliVersion, String> ROOT_BUILDERS_SUFFIX = new HashMap<RestliVersion, String>();
    private static final Map<RestliVersion, String> METHOD_BUILDER_SUFFIX;
    private final JClass _voidClass = this.getCodeModel().ref(Void.class);
    private final JClass _fieldDefClass = this.getCodeModel().ref(FieldDef.class);
    private final JClass _resourceSpecClass = this.getCodeModel().ref(ResourceSpec.class);
    private final JClass _resourceSpecImplClass = this.getCodeModel().ref(ResourceSpecImpl.class);
    private final JClass _enumSetClass = this.getCodeModel().ref(EnumSet.class);
    private final JClass _resourceMethodClass = this.getCodeModel().ref(ResourceMethod.class);
    private final JClass _classClass = this.getCodeModel().ref(Class.class);
    private final JClass _objectClass = this.getCodeModel().ref(Object.class);
    private final HashSet<JClass> _generatedArrayClasses = new HashSet();
    private final DataSchemaResolver _schemaResolver;
    private final TemplateSpecGenerator _specGenerator;
    private final JavaDataTemplateGenerator _javaDataTemplateGenerator;
    private final boolean _generateDataTemplates;
    private final RestliVersion _version;
    private final RestliVersion _deprecatedByVersion;
    private File _currentSourceFile;

    public JavaRequestBuilderGenerator(String resolverPath, String defaultPackage, boolean generateDataTemplates, RestliVersion version, RestliVersion deprecatedByVersion) {
        super(defaultPackage);
        this._schemaResolver = CodeUtil.createSchemaResolver((String)resolverPath);
        this._specGenerator = new TemplateSpecGenerator(this._schemaResolver);
        this._javaDataTemplateGenerator = new JavaDataTemplateGenerator(defaultPackage);
        this._generateDataTemplates = generateDataTemplates;
        this._version = version;
        this._deprecatedByVersion = deprecatedByVersion;
    }

    public boolean isGeneratedArrayClass(JClass clazz) {
        return this._generatedArrayClasses.contains(clazz);
    }

    public TemplateSpecGenerator getSpecGenerator() {
        return this._specGenerator;
    }

    public JavaDataTemplateGenerator getJavaDataTemplateGenerator() {
        return this._javaDataTemplateGenerator;
    }

    public JDefinedClass generate(ResourceSchema resource, File sourceFile) {
        this._currentSourceFile = sourceFile;
        try {
            return this.generateResourceFacade(resource, sourceFile, new HashMap<String, JClass>(), new HashMap<String, JClass>(), new HashMap<String, List<String>>());
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalStateException("Unexpected exception parsing " + sourceFile + ", " + e.getExistingClass().fullName() + " exists", e);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Error parsing json file [" + sourceFile.getAbsolutePath() + "] [" + e.getMessage() + ']', e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error processing file [" + sourceFile.getAbsolutePath() + ']' + e.getMessage(), e);
        }
    }

    private static String getBuilderClassNameByVersion(RestliVersion version, String namespace, String builderName, boolean isRootBuilders) {
        String className = (namespace == null || namespace.trim().isEmpty() ? "" : namespace + ".") + CodeUtil.capitalize((String)builderName);
        Map<RestliVersion, String> suffixMap = isRootBuilders ? ROOT_BUILDERS_SUFFIX : METHOD_BUILDER_SUFFIX;
        return className + suffixMap.get(version);
    }

    private static List<String> fixOldStylePathKeys(List<String> pathKeys, String resourcePath, Map<String, List<String>> pathToAssocKeys) {
        if (resourcePath.contains("=")) {
            ArrayList<String> newPathKeys = new ArrayList<String>(pathKeys.size());
            Map<String, String> assocToPathKeys = JavaRequestBuilderGenerator.reverseMap(pathToAssocKeys);
            HashSet<String> prevRealPathKeys = new HashSet<String>();
            for (String currKey : pathKeys) {
                if (assocToPathKeys.containsKey(currKey)) {
                    if (prevRealPathKeys.contains(assocToPathKeys.get(currKey))) continue;
                    prevRealPathKeys.add(assocToPathKeys.get(currKey));
                    newPathKeys.add(assocToPathKeys.get(currKey));
                    continue;
                }
                newPathKeys.add(currKey);
            }
            return newPathKeys;
        }
        return pathKeys;
    }

    private static Map<String, String> reverseMap(Map<String, List<String>> toReverse) {
        HashMap<String, String> reversed = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : toReverse.entrySet()) {
            for (String element : entry.getValue()) {
                reversed.put(element, entry.getKey());
            }
        }
        return reversed;
    }

    private static List<String> getPathKeys(String basePath, Map<String, List<String>> pathToAssocKeys) {
        UriTemplate template = new UriTemplate(basePath);
        return JavaRequestBuilderGenerator.fixOldStylePathKeys(template.getTemplateVariables(), basePath, pathToAssocKeys);
    }

    private static void generateQueryParamSetMethod(JDefinedClass derivedBuilderClass, ParameterSchema param, JClass paramClass, JClass paramItemsClass) {
        String paramName = param.getName();
        boolean isOptional = RestLiToolsUtils.isParameterOptional(param);
        String methodName = RestLiToolsUtils.nameCamelCase(paramName + "Param");
        JMethod setMethod = derivedBuilderClass.method(1, (JType)derivedBuilderClass, methodName);
        JVar setMethodParam = setMethod.param((JType)paramClass, "value");
        setMethod.body().add((JStatement)JExpr._super().invoke(isOptional ? "setParam" : "setReqParam").arg(paramName).arg((JExpression)setMethodParam).arg(paramItemsClass.dotclass()));
        setMethod.body()._return(JExpr._this());
        JavaRequestBuilderGenerator.generateParamJavadoc(setMethod, setMethodParam, param);
    }

    private static void generateQueryParamAddMethod(JDefinedClass derivedBuilderClass, ParameterSchema param, JClass paramClass) {
        String paramName = param.getName();
        boolean isOptional = RestLiToolsUtils.isParameterOptional(param);
        String methodName = RestLiToolsUtils.nameCamelCase("add" + RestLiToolsUtils.normalizeCaps(paramName) + "Param");
        JMethod addMethod = derivedBuilderClass.method(1, (JType)derivedBuilderClass, methodName);
        JVar addMethodParam = addMethod.param((JType)paramClass, "value");
        addMethod.body().add((JStatement)JExpr._super().invoke(isOptional ? "addParam" : "addReqParam").arg(paramName).arg((JExpression)addMethodParam).arg(paramClass.dotclass()));
        addMethod.body()._return(JExpr._this());
        JavaRequestBuilderGenerator.generateParamJavadoc(addMethod, addMethodParam, param);
    }

    private static void generateClassJavadoc(JDefinedClass clazz, RecordTemplate schema) {
        String doc = schema.data().getString("doc");
        if (doc != null) {
            clazz.javadoc().append((Object)doc);
        }
    }

    private static void checkRestSpecAndDeprecateRootBuildersClass(JDefinedClass clazz, ResourceSchema schema) {
        DataMap annotations;
        DataMap deprecated;
        if (schema.data().containsKey((Object)"annotations") && (deprecated = (annotations = schema.data().getDataMap("annotations")).getDataMap("deprecated")) != null) {
            clazz.annotate(Deprecated.class);
            if (deprecated.containsKey((Object)"doc")) {
                clazz.javadoc().addDeprecated().append((Object)deprecated.getString("doc"));
            }
        }
    }

    private static void generateFactoryMethodJavadoc(JMethod method, RecordTemplate schema) {
        DataMap annotations;
        String doc;
        DataMap annotations2;
        StringBuilder docString = new StringBuilder();
        if (schema.data().containsKey((Object)"annotations") && (annotations2 = schema.data().getDataMap("annotations")).containsKey((Object)"testMethod")) {
            DataMap testMethod = annotations2.getDataMap("testMethod");
            docString.append("<b>Test Method");
            String testMethodDoc = testMethod.getString("doc");
            if (testMethodDoc != null) {
                docString.append(": ");
                docString.append(testMethodDoc);
            }
            docString.append("</b>\n");
        }
        if ((doc = schema.data().getString("doc")) != null) {
            docString.append(doc);
        }
        if (docString.length() > 0) {
            method.javadoc().append((Object)docString.toString());
            method.javadoc().addReturn().add((Object)"builder for the resource method");
        }
        if (schema.data().containsKey((Object)"annotations") && (annotations = schema.data().getDataMap("annotations")).containsKey((Object)"deprecated")) {
            method.annotate(Deprecated.class);
            DataMap deprecated = annotations.getDataMap("deprecated");
            if (deprecated.containsKey((Object)"doc")) {
                method.javadoc().addDeprecated().append((Object)deprecated.getString("doc"));
            }
        }
    }

    private static void generateParamJavadoc(JMethod method, JVar param, ParameterSchema schema) {
        if (schema.hasDoc()) {
            method.javadoc().addParam(param).append((Object)schema.getDoc());
            method.javadoc().addReturn().append((Object)"this builder");
        }
    }

    private static String getResourcePath(String rawPath) {
        if (rawPath.charAt(0) == '/') {
            return rawPath.substring(1);
        }
        return rawPath;
    }

    private static Set<ResourceMethod> getSupportedMethods(StringArray supportsList) {
        EnumSet<ResourceMethod> supportedMethods = EnumSet.noneOf(ResourceMethod.class);
        for (String methodEntry : supportsList) {
            supportedMethods.add(ResourceMethod.fromString((String)methodEntry));
        }
        return supportedMethods;
    }

    private static String getName(JsonNode namedEntry) {
        return namedEntry.get(NAME).textValue();
    }

    private static String getNamespace(JsonNode entry) {
        if (entry.path(NAMESPACE).isMissingNode()) {
            return "";
        }
        return entry.get(NAMESPACE).textValue();
    }

    private boolean checkVersionAndDeprecateBuilderClass(JDefinedClass clazz, boolean isRootBuilders) {
        if (this._deprecatedByVersion == null) {
            return false;
        }
        clazz.annotate(Deprecated.class);
        Map<RestliVersion, String> suffixMap = isRootBuilders ? ROOT_BUILDERS_SUFFIX : METHOD_BUILDER_SUFFIX;
        String deprecatedBuilderName = clazz.name();
        String replacementBuilderName = deprecatedBuilderName.substring(0, deprecatedBuilderName.length() - suffixMap.get(this._version).length());
        clazz.javadoc().addDeprecated().append((Object)("This format of request builder is obsolete. Please use {@link " + JavaRequestBuilderGenerator.getBuilderClassNameByVersion(this._deprecatedByVersion, clazz.getPackage().name(), replacementBuilderName, isRootBuilders) + "} instead."));
        return true;
    }

    private void annotate(JDefinedClass requestBuilderClass, String sourceFilePath) {
        JavaCodeUtil.annotate((JDefinedClass)requestBuilderClass, (String)"Request Builder", (String)sourceFilePath);
    }

    private JDefinedClass generateResourceFacade(ResourceSchema resource, File sourceFile, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys) throws JClassAlreadyExistsException, IOException {
        JClass keyClass;
        String keyName;
        Class<CollectionSchema> resourceSchemaClass;
        JFieldVar requestOptionsField;
        JFieldVar baseUriField;
        ValidationResult validationResult = ValidateDataAgainstSchema.validate((Object)resource.data(), (DataSchema)resource.schema(), (ValidationOptions)new ValidationOptions(RequiredMode.MUST_BE_PRESENT));
        if (!validationResult.isValid()) {
            throw new IllegalArgumentException(String.format("Resource validation error.  Resource File '%s', Error Details '%s'", sourceFile, validationResult.toString()));
        }
        String packageName = resource.getNamespace();
        JPackage clientPackage = packageName == null || packageName.isEmpty() ? this.getPackage() : this.getPackage(packageName);
        String className = this._version == RestliVersion.RESTLI_2_0_0 ? JavaRequestBuilderGenerator.getBuilderClassNameByVersion(RestliVersion.RESTLI_2_0_0, null, resource.getName(), true) : JavaRequestBuilderGenerator.getBuilderClassNameByVersion(RestliVersion.RESTLI_1_0_0, null, resource.getName(), true);
        JDefinedClass facadeClass = clientPackage._class(className);
        this.annotate(facadeClass, sourceFile.getAbsolutePath());
        JInvocation baseUriGetter = JExpr.invoke((String)"getBaseUriTemplate");
        JInvocation requestOptionsGetter = JExpr.invoke((String)"getRequestOptions");
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            baseUriField = null;
            requestOptionsField = null;
            facadeClass._extends(BuilderBase.class);
        } else {
            baseUriField = facadeClass.field(12, String.class, "_baseUriTemplate");
            requestOptionsField = facadeClass.field(4, RestliRequestOptions.class, "_requestOptions");
            facadeClass.method(4, String.class, "getBaseUriTemplate").body()._return((JExpression)baseUriField);
            facadeClass.method(1, RestliRequestOptions.class, "getRequestOptions").body()._return((JExpression)requestOptionsField);
        }
        JFieldVar originalResourceField = facadeClass.field(28, String.class, "ORIGINAL_RESOURCE_PATH");
        String resourcePath = JavaRequestBuilderGenerator.getResourcePath(resource.getPath());
        originalResourceField.init(JExpr.lit((String)resourcePath));
        JClass restliRequestOptionsClass = this.getCodeModel().ref(RestliRequestOptions.class);
        JFieldRef defaultOptionsField = restliRequestOptionsClass.staticRef("DEFAULT_OPTIONS");
        if (this._version == RestliVersion.RESTLI_1_0_0) {
            JMethod pathComponentsGetter = facadeClass.method(1, String[].class, "getPathComponents");
            pathComponentsGetter.body()._return((JExpression)this.getCodeModel().ref(URIParamUtils.class).staticInvoke("extractPathComponentsFromUriTemplate").arg((JExpression)baseUriField));
            JMethod requestOptionsAssigner = facadeClass.method(20, RestliRequestOptions.class, "assignRequestOptions");
            JVar requestOptionsAssignerParam = requestOptionsAssigner.param(RestliRequestOptions.class, "requestOptions");
            JConditional requestNullCheck = requestOptionsAssigner.body()._if(requestOptionsAssignerParam.eq(JExpr._null()));
            requestNullCheck._then().block()._return((JExpression)defaultOptionsField);
            requestNullCheck._else().block()._return((JExpression)requestOptionsAssignerParam);
        }
        JMethod noArgConstructor = facadeClass.constructor(1);
        JMethod requestOptionsOverrideConstructor = facadeClass.constructor(1);
        JMethod resourceNameOverrideConstructor = facadeClass.constructor(1);
        JMethod mainConstructor = facadeClass.constructor(1);
        noArgConstructor.body().invoke("this").arg((JExpression)defaultOptionsField);
        JVar requestOptionsOverrideOptionsParam = requestOptionsOverrideConstructor.param(RestliRequestOptions.class, "requestOptions");
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            requestOptionsOverrideConstructor.body().invoke("super").arg((JExpression)originalResourceField).arg((JExpression)requestOptionsOverrideOptionsParam);
        } else {
            requestOptionsOverrideConstructor.body().assign((JAssignmentTarget)baseUriField, (JExpression)originalResourceField);
            JInvocation requestOptionsOverrideAssignRequestOptions = new JBlock().invoke("assignRequestOptions").arg((JExpression)requestOptionsOverrideOptionsParam);
            requestOptionsOverrideConstructor.body().assign((JAssignmentTarget)requestOptionsField, (JExpression)requestOptionsOverrideAssignRequestOptions);
        }
        JVar resourceNameOverrideResourceNameParam = resourceNameOverrideConstructor.param((JType)this._stringClass, "primaryResourceName");
        resourceNameOverrideConstructor.body().invoke("this").arg((JExpression)resourceNameOverrideResourceNameParam).arg((JExpression)defaultOptionsField);
        JVar mainConsResourceNameParam = mainConstructor.param((JType)this._stringClass, "primaryResourceName");
        JVar mainConsOptionsParam = mainConstructor.param(RestliRequestOptions.class, "requestOptions");
        Object baseUriExpr = resourcePath.contains("/") ? originalResourceField.invoke("replaceFirst").arg(JExpr.lit((String)"[^/]*/")).arg(mainConsResourceNameParam.plus(JExpr.lit((String)"/"))) : mainConsResourceNameParam;
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            mainConstructor.body().invoke("super").arg((JExpression)baseUriExpr).arg((JExpression)mainConsOptionsParam);
        } else {
            JInvocation mainAssignRequestOptions = new JBlock().invoke("assignRequestOptions").arg((JExpression)mainConsOptionsParam);
            mainConstructor.body().assign((JAssignmentTarget)baseUriField, (JExpression)baseUriExpr);
            mainConstructor.body().assign((JAssignmentTarget)requestOptionsField, (JExpression)mainAssignRequestOptions);
        }
        String resourceName = CodeUtil.capitalize((String)resource.getName());
        JMethod primaryResourceGetter = facadeClass.method(17, String.class, "getPrimaryResource");
        primaryResourceGetter.body()._return((JExpression)originalResourceField);
        List<String> pathKeys = JavaRequestBuilderGenerator.getPathKeys(resourcePath, pathToAssocKeys);
        JClass keyTyperefClass = null;
        JClass keyKeyClass = null;
        JClass keyParamsClass = null;
        Map<Object, Object> assocKeyTypeInfos = Collections.emptyMap();
        StringArray supportsList = null;
        RestMethodSchemaArray restMethods = null;
        FinderSchemaArray finders = null;
        ResourceSchemaArray subresources = null;
        ActionSchemaArray resourceActions = null;
        ActionSchemaArray entityActions = null;
        if (resource.getCollection() != null) {
            resourceSchemaClass = CollectionSchema.class;
            CollectionSchema collection = resource.getCollection();
            keyName = collection.getIdentifier().getName();
            if (collection.getIdentifier().getParams() == null) {
                keyClass = this.getJavaBindingType(collection.getIdentifier().getType(), facadeClass).valueClass;
                JClass declaredClass = this.getClassRefForSchema(RestSpecCodec.textToSchema((String)collection.getIdentifier().getType(), (DataSchemaResolver)this._schemaResolver), facadeClass);
                if (!declaredClass.equals(keyClass)) {
                    keyTyperefClass = declaredClass;
                }
            } else {
                keyKeyClass = this.getJavaBindingType(collection.getIdentifier().getType(), facadeClass).valueClass;
                keyParamsClass = this.getJavaBindingType(collection.getIdentifier().getParams(), facadeClass).valueClass;
                keyClass = this.getCodeModel().ref(ComplexResourceKey.class).narrow(new JClass[]{keyKeyClass, keyParamsClass});
            }
            pathKeyTypes.put(keyName, keyClass);
            supportsList = collection.getSupports();
            restMethods = collection.getMethods();
            finders = collection.getFinders();
            subresources = collection.getEntity().getSubresources();
            resourceActions = collection.getActions();
            entityActions = collection.getEntity().getActions();
        } else if (resource.getAssociation() != null) {
            resourceSchemaClass = AssociationSchema.class;
            AssociationSchema association = resource.getAssociation();
            keyClass = this.getCodeModel().ref(CompoundKey.class);
            supportsList = association.getSupports();
            restMethods = association.getMethods();
            finders = association.getFinders();
            subresources = association.getEntity().getSubresources();
            resourceActions = association.getActions();
            entityActions = association.getEntity().getActions();
            assocKeyTypeInfos = this.generateAssociationKey(facadeClass, association);
            keyName = this.getAssociationKey(resource, association);
            pathKeyTypes.put(keyName, keyClass);
            ArrayList<Object> assocKeys = new ArrayList<Object>(4);
            for (Map.Entry<Object, Object> entry : assocKeyTypeInfos.entrySet()) {
                assocKeys.add(entry.getKey());
                assocKeyTypes.put((String)entry.getKey(), ((AssocKeyTypeInfo)entry.getValue()).getBindingType());
            }
            pathToAssocKeys.put(keyName, assocKeys);
        } else if (resource.getSimple() != null) {
            resourceSchemaClass = SimpleSchema.class;
            SimpleSchema simpleSchema = resource.getSimple();
            keyClass = this._voidClass;
            supportsList = simpleSchema.getSupports();
            restMethods = simpleSchema.getMethods();
            subresources = simpleSchema.getEntity().getSubresources();
            resourceActions = simpleSchema.getActions();
        } else if (resource.getActionsSet() != null) {
            resourceSchemaClass = ActionsSetSchema.class;
            ActionsSetSchema actionsSet = resource.getActionsSet();
            resourceActions = actionsSet.getActions();
            keyClass = this._voidClass;
        } else {
            throw new IllegalArgumentException("unsupported resource type for resource: '" + resourceName + '\'');
        }
        this.generateOptions(facadeClass, (JExpression)baseUriGetter, (JExpression)requestOptionsGetter);
        JFieldVar resourceSpecField = facadeClass.field(28, (JType)this._resourceSpecClass, "_resourceSpec");
        if (resourceSchemaClass == CollectionSchema.class || resourceSchemaClass == AssociationSchema.class || resourceSchemaClass == SimpleSchema.class) {
            JInvocation supportedMethodsExpr;
            JClass schemaClass = this.getJavaBindingType(resource.getSchema(), null).schemaClass;
            Set<ResourceMethod> supportedMethods = JavaRequestBuilderGenerator.getSupportedMethods(supportsList);
            if (supportedMethods.isEmpty()) {
                supportedMethodsExpr = this._enumSetClass.staticInvoke("noneOf").arg(this._resourceMethodClass.dotclass());
            } else {
                supportedMethodsExpr = this._enumSetClass.staticInvoke("of");
                for (ResourceMethod resourceMethod : supportedMethods) {
                    this.validateResourceMethod(resourceSchemaClass, resourceName, resourceMethod);
                    supportedMethodsExpr.arg((JExpression)this._resourceMethodClass.staticRef(resourceMethod.name()));
                }
            }
            JBlock jBlock = facadeClass.init();
            JVar methodSchemaMap = this.methodMetadataMapInit(facadeClass, resourceActions, entityActions, jBlock);
            JVar responseSchemaMap = this.responseMetadataMapInit(facadeClass, resourceActions, entityActions, jBlock);
            if (resourceSchemaClass == CollectionSchema.class || resourceSchemaClass == AssociationSchema.class) {
                JClass assocKeyClass = this.getCodeModel().ref(CompoundKey.TypeInfo.class);
                JClass hashMapClass = this.getCodeModel().ref(HashMap.class).narrow(new JClass[]{this._stringClass, assocKeyClass});
                JVar keyPartsVar = jBlock.decl((JType)hashMapClass, "keyParts").init((JExpression)JExpr._new((JClass)hashMapClass));
                for (Map.Entry<Object, Object> typeInfoEntry : assocKeyTypeInfos.entrySet()) {
                    AssocKeyTypeInfo typeInfo = (AssocKeyTypeInfo)typeInfoEntry.getValue();
                    JInvocation typeArg = JExpr._new((JClass)assocKeyClass).arg(typeInfo.getBindingType().dotclass()).arg(typeInfo.getDeclaredType().dotclass());
                    jBlock.add((JStatement)keyPartsVar.invoke("put").arg((String)typeInfoEntry.getKey()).arg((JExpression)typeArg));
                }
                jBlock.assign((JAssignmentTarget)resourceSpecField, (JExpression)JExpr._new((JClass)this._resourceSpecImplClass).arg((JExpression)supportedMethodsExpr).arg((JExpression)methodSchemaMap).arg((JExpression)responseSchemaMap).arg(keyTyperefClass == null ? keyClass.dotclass() : keyTyperefClass.dotclass()).arg(keyKeyClass == null ? JExpr._null() : keyKeyClass.dotclass()).arg(keyKeyClass == null ? JExpr._null() : keyParamsClass.dotclass()).arg(schemaClass.dotclass()).arg((JExpression)keyPartsVar));
            } else {
                jBlock.assign((JAssignmentTarget)resourceSpecField, (JExpression)JExpr._new((JClass)this._resourceSpecImplClass).arg((JExpression)supportedMethodsExpr).arg((JExpression)methodSchemaMap).arg((JExpression)responseSchemaMap).arg(schemaClass.dotclass()));
            }
            this.generateBasicMethods(facadeClass, (JExpression)baseUriGetter, keyClass, schemaClass, supportedMethods, restMethods, (JVar)resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, (JExpression)requestOptionsGetter, resource.data().getDataMap("annotations"));
            if (resourceSchemaClass == CollectionSchema.class || resourceSchemaClass == AssociationSchema.class) {
                this.generateFinders(facadeClass, (JExpression)baseUriGetter, finders, keyClass, schemaClass, assocKeyTypeInfos, (JVar)resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, (JExpression)requestOptionsGetter);
            }
            this.generateSubResources(sourceFile, subresources, pathKeyTypes, assocKeyTypes, pathToAssocKeys);
        } else {
            JBlock staticInit = facadeClass.init();
            JInvocation supportedMethodsExpr = this._enumSetClass.staticInvoke("noneOf").arg(this._resourceMethodClass.dotclass());
            JVar methodSchemaMap = this.methodMetadataMapInit(facadeClass, resourceActions, entityActions, staticInit);
            JVar jVar = this.responseMetadataMapInit(facadeClass, resourceActions, entityActions, staticInit);
            staticInit.assign((JAssignmentTarget)resourceSpecField, (JExpression)JExpr._new((JClass)this._resourceSpecImplClass).arg((JExpression)supportedMethodsExpr).arg((JExpression)methodSchemaMap).arg((JExpression)jVar).arg(keyClass.dotclass()).arg(JExpr._null()).arg(JExpr._null()).arg(JExpr._null()).arg((JExpression)this.getCodeModel().ref(Collections.class).staticInvoke("<String, Class<?>>emptyMap")));
        }
        this.generateActions(facadeClass, (JExpression)baseUriGetter, resourceActions, entityActions, keyClass, (JVar)resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, (JExpression)requestOptionsGetter);
        JavaRequestBuilderGenerator.generateClassJavadoc(facadeClass, (RecordTemplate)resource);
        if (!this.checkVersionAndDeprecateBuilderClass(facadeClass, true)) {
            JavaRequestBuilderGenerator.checkRestSpecAndDeprecateRootBuildersClass(facadeClass, resource);
        }
        return facadeClass;
    }

    private String getAssociationKey(ResourceSchema resource, AssociationSchema association) {
        if (association.getIdentifier() == null) {
            return resource.getName() + "Id";
        }
        return association.getIdentifier();
    }

    private void validateResourceMethod(Class<?> resourceSchemaClass, String resourceName, ResourceMethod resourceMethod) {
        if (resourceSchemaClass == SimpleSchema.class && !RestConstants.SIMPLE_RESOURCE_METHODS.contains(resourceMethod)) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported method on resource: '%s'", resourceMethod.toString(), resourceName));
        }
    }

    private JVar responseMetadataMapInit(JDefinedClass facadeClass, ActionSchemaArray resourceActions, ActionSchemaArray entityActions, JBlock staticInit) {
        JClass MetadataMapClass = this.getCodeModel().ref(HashMap.class).narrow(new JClass[]{this._stringClass, this.getCodeModel().ref(DynamicRecordMetadata.class)});
        JVar responseMetadataMap = staticInit.decl((JType)MetadataMapClass, "responseMetadataMap").init((JExpression)JExpr._new((JClass)MetadataMapClass));
        int resourceActionsSize = resourceActions == null ? 0 : resourceActions.size();
        int entityActionsSize = entityActions == null ? 0 : entityActions.size();
        ActionSchemaArray allActionSchema = new ActionSchemaArray(resourceActionsSize + entityActionsSize);
        allActionSchema.addAll((Collection)(resourceActions == null ? new ActionSchemaArray() : resourceActions));
        allActionSchema.addAll((Collection)(entityActions == null ? new ActionSchemaArray() : entityActions));
        String returnName = "value";
        for (ActionSchema actionSchema : allActionSchema) {
            JInvocation returnFieldDefs;
            String methodName = actionSchema.getName();
            if (actionSchema.hasReturns()) {
                JInvocation returnFieldDef = this.createFieldDef("value", actionSchema.getReturns(), facadeClass);
                returnFieldDefs = this.getCodeModel().ref(Collections.class).staticInvoke("singletonList").arg((JExpression)returnFieldDef);
            } else {
                returnFieldDefs = this.getCodeModel().ref(Collections.class).staticInvoke("<FieldDef<?>>emptyList");
            }
            JInvocation returnMetadata = this.createMetadata(methodName, (JExpression)returnFieldDefs);
            staticInit.add((JStatement)responseMetadataMap.invoke("put").arg(methodName).arg((JExpression)returnMetadata));
        }
        return responseMetadataMap;
    }

    private JVar methodMetadataMapInit(JDefinedClass facadeClass, ActionSchemaArray resourceActions, ActionSchemaArray entityActions, JBlock staticInit) {
        JClass MetadataMapClass = this.getCodeModel().ref(HashMap.class).narrow(new JClass[]{this._stringClass, this.getCodeModel().ref(DynamicRecordMetadata.class)});
        JVar requestMetadataMap = staticInit.decl((JType)MetadataMapClass, "requestMetadataMap").init((JExpression)JExpr._new((JClass)MetadataMapClass));
        JClass fieldDefListClass = this.getCodeModel().ref(ArrayList.class).narrow(this.getCodeModel().ref(FieldDef.class).narrow(this.getCodeModel().ref(Object.class).wildcard()));
        int resourceActionsSize = resourceActions == null ? 0 : resourceActions.size();
        int entityActionsSize = entityActions == null ? 0 : entityActions.size();
        ActionSchemaArray allActionSchema = new ActionSchemaArray(resourceActionsSize + entityActionsSize);
        allActionSchema.addAll((Collection)(resourceActions == null ? new ActionSchemaArray() : resourceActions));
        allActionSchema.addAll((Collection)(entityActions == null ? new ActionSchemaArray() : entityActions));
        for (ActionSchema actionSchema : allActionSchema) {
            String varName = actionSchema.getName() + "Params";
            JVar currMethodParams = staticInit.decl((JType)fieldDefListClass, varName).init((JExpression)JExpr._new((JClass)fieldDefListClass));
            ParameterSchemaArray parameters = actionSchema.getParameters();
            for (ParameterSchema parameterSchema : parameters == null ? new ParameterSchemaArray() : parameters) {
                JInvocation fieldDefParam = this.createFieldDef(parameterSchema.getName(), parameterSchema.getType(), facadeClass);
                staticInit.add((JStatement)currMethodParams.invoke("add").arg((JExpression)fieldDefParam));
            }
            String methodName = actionSchema.getName();
            JInvocation newSchema = this.createMetadata(methodName, (JExpression)currMethodParams);
            staticInit.add((JStatement)requestMetadataMap.invoke("put").arg(methodName).arg((JExpression)newSchema));
        }
        return requestMetadataMap;
    }

    private JInvocation createFieldDef(String name, String type, JDefinedClass enclosingClass) {
        JavaBinding binding = this.getJavaBindingType(type, enclosingClass);
        JInvocation schema = this.getCodeModel().ref(DataTemplateUtil.class).staticInvoke("getSchema").arg(binding.schemaClass.dotclass());
        JInvocation fieldDefInvocation = JExpr._new((JClass)this.getCodeModel().ref(FieldDef.class).narrow(binding.valueClass)).arg(name).arg(binding.valueClass.dotclass()).arg((JExpression)schema);
        return fieldDefInvocation;
    }

    private JInvocation createMetadata(String name, JExpression fieldDefs) {
        return JExpr._new((JClass)this.getCodeModel().ref(DynamicRecordMetadata.class)).arg(name).arg(fieldDefs);
    }

    private JClass getKeyClass(CollectionSchema collection, JDefinedClass facadeClass) {
        JClass keyClass = this.getJavaBindingType(collection.getIdentifier().getType(), facadeClass).valueClass;
        if (collection.getIdentifier().getParams() == null) {
            return keyClass;
        }
        JClass paramsClass = this.getJavaBindingType(collection.getIdentifier().getParams(), facadeClass).valueClass;
        return this.getCodeModel().ref(ComplexResourceKey.class).narrow(new JClass[]{keyClass, paramsClass});
    }

    private void generateOptions(JDefinedClass facadeClass, JExpression baseUriExpr, JExpression requestOptionsExpr) {
        JClass builderClass = this.getCodeModel().ref(OptionsRequestBuilder.class);
        JMethod finderMethod = facadeClass.method(1, OptionsRequestBuilder.class, "options");
        finderMethod.body()._return((JExpression)JExpr._new((JClass)builderClass).arg(baseUriExpr).arg(requestOptionsExpr));
    }

    private void generateSubResources(File sourceFile, ResourceSchemaArray subresources, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys) throws JClassAlreadyExistsException, IOException {
        if (subresources == null) {
            return;
        }
        for (ResourceSchema resource : subresources) {
            this.generateResourceFacade(resource, sourceFile, pathKeyTypes, assocKeyTypes, pathToAssocKeys);
        }
    }

    private void generateFinders(JDefinedClass facadeClass, JExpression baseUriExpr, FinderSchemaArray finderSchemas, JClass keyClass, JClass valueClass, Map<String, AssocKeyTypeInfo> assocKeys, JVar resourceSpecField, String resourceName, List<String> pathKeys, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys, JExpression requestOptionsExpr) throws JClassAlreadyExistsException {
        if (finderSchemas != null) {
            JClass baseBuilderClass = this.getCodeModel().ref(FindRequestBuilderBase.class).narrow(new JClass[]{keyClass, valueClass});
            for (FinderSchema finder : finderSchemas) {
                String finderName = finder.getName();
                String builderName = CodeUtil.capitalize((String)resourceName) + "FindBy" + CodeUtil.capitalize((String)finderName) + METHOD_BUILDER_SUFFIX.get(this._version);
                JDefinedClass finderBuilderClass = this.generateDerivedBuilder(baseBuilderClass, valueClass, finderName, builderName, facadeClass.getPackage(), ResourceMethod.FINDER, null);
                JMethod finderMethod = facadeClass.method(1, (JType)finderBuilderClass, "findBy" + CodeUtil.capitalize((String)finderName));
                finderMethod.body()._return((JExpression)JExpr._new((JClass)finderBuilderClass).arg(baseUriExpr).arg((JExpression)resourceSpecField).arg(requestOptionsExpr));
                HashSet<String> finderKeys = new HashSet<String>();
                if (finder.getAssocKey() != null) {
                    finderKeys.add(finder.getAssocKey());
                }
                if (finder.getAssocKeys() != null) {
                    for (String assocKey : finder.getAssocKeys()) {
                        finderKeys.add(assocKey);
                    }
                }
                this.generatePathKeyBindingMethods(pathKeys, finderBuilderClass, pathKeyTypes, assocKeyTypes, pathToAssocKeys);
                this.generateAssocKeyBindingMethods(assocKeys, finderBuilderClass, finderKeys);
                if (finder.getParameters() != null) {
                    this.generateQueryParamBindingMethods(facadeClass, finder.getParameters(), finderBuilderClass);
                }
                if (finder.getMetadata() != null) {
                    String metadataClass = finder.getMetadata().getType();
                    this.getJavaBindingType(metadataClass, facadeClass);
                }
                JavaRequestBuilderGenerator.generateClassJavadoc(finderBuilderClass, (RecordTemplate)finder);
                JavaRequestBuilderGenerator.generateFactoryMethodJavadoc(finderMethod, (RecordTemplate)finder);
            }
        }
    }

    private void generateQueryParamBindingMethods(JDefinedClass facadeClass, ParameterSchemaArray parameters, JDefinedClass derivedBuilderClass) {
        for (ParameterSchema param : parameters) {
            JClass paramClass;
            if ("array".equals(param.getType())) {
                JClass paramItemsClass = this.getJavaBindingType(param.getItems(), facadeClass).valueClass;
                paramClass = this.getCodeModel().ref(Iterable.class).narrow(paramItemsClass);
                JavaRequestBuilderGenerator.generateQueryParamSetMethod(derivedBuilderClass, param, paramClass, paramItemsClass);
                JavaRequestBuilderGenerator.generateQueryParamAddMethod(derivedBuilderClass, param, paramItemsClass);
                continue;
            }
            DataSchema typeSchema = RestSpecCodec.textToSchema((String)param.getType(), (DataSchemaResolver)this._schemaResolver);
            paramClass = this.getJavaBindingType(typeSchema, facadeClass).valueClass;
            JavaRequestBuilderGenerator.generateQueryParamSetMethod(derivedBuilderClass, param, paramClass, paramClass);
            if (!(typeSchema instanceof ArrayDataSchema)) continue;
            DataSchema itemsSchema = ((ArrayDataSchema)typeSchema).getItems();
            JClass paramItemsClass = this.getJavaBindingType(itemsSchema, facadeClass).valueClass;
            JClass iterableItemsClass = this.getCodeModel().ref(Iterable.class).narrow(paramItemsClass);
            JavaRequestBuilderGenerator.generateQueryParamSetMethod(derivedBuilderClass, param, iterableItemsClass, paramItemsClass);
            JavaRequestBuilderGenerator.generateQueryParamAddMethod(derivedBuilderClass, param, paramItemsClass);
        }
    }

    private JDefinedClass generateDerivedBuilder(JClass baseBuilderClass, JClass valueClass, String finderName, String derivedBuilderName, JPackage clientPackage, ResourceMethod resourceMethod, DataMap annotations) throws JClassAlreadyExistsException {
        JDefinedClass derivedBuilderClass = clientPackage._class(1, derivedBuilderName);
        this.annotate(derivedBuilderClass, null);
        this.checkVersionAndDeprecateBuilderClass(derivedBuilderClass, false);
        derivedBuilderClass._extends(baseBuilderClass.narrow((JClass)derivedBuilderClass));
        JMethod derivedBuilderConstructor = derivedBuilderClass.constructor(1);
        JVar uriParam = derivedBuilderConstructor.param((JType)this._stringClass, "baseUriTemplate");
        JVar resourceSpecParam = derivedBuilderConstructor.param((JType)this._resourceSpecClass, "resourceSpec");
        JVar requestOptionsParam = derivedBuilderConstructor.param(RestliRequestOptions.class, "requestOptions");
        JInvocation invocation = derivedBuilderConstructor.body().invoke("super").arg((JExpression)uriParam);
        if (!baseBuilderClass.fullName().startsWith(BatchGetEntityRequestBuilderBase.class.getName() + "<")) {
            invocation.arg(valueClass.dotclass());
        }
        invocation.arg((JExpression)resourceSpecParam).arg((JExpression)requestOptionsParam);
        if (finderName != null) {
            derivedBuilderConstructor.body().add((JStatement)JExpr._super().invoke(NAME).arg(finderName));
        }
        if (_validateEntityMethods.contains(resourceMethod) || _validatePatchMethods.contains(resourceMethod)) {
            JMethod validateMethod = derivedBuilderClass.method(17, ValidationResult.class, "validateInput");
            JVar inputParam = _validateEntityMethods.contains(resourceMethod) ? validateMethod.param((JType)valueClass, "input") : validateMethod.param((JType)this.getCodeModel().ref(PatchRequest.class).narrow(valueClass), "patch");
            JBlock block = validateMethod.body();
            JVar annotationMap = block.decl((JType)this.getCodeModel().ref(Map.class).narrow(String.class).narrow(this.getCodeModel().ref(List.class).narrow(String.class)), "annotations").init((JExpression)JExpr._new((JClass)this.getCodeModel().ref(HashMap.class).narrow(String.class).narrow(this.getCodeModel().ref(List.class).narrow(String.class))));
            if (annotations != null) {
                for (Map.Entry entry : annotations.entrySet()) {
                    DataList values = ((DataMap)entry.getValue()).getDataList("value");
                    if (values == null) continue;
                    JInvocation list = this.getCodeModel().ref(Arrays.class).staticInvoke("asList");
                    for (Object value : values) {
                        list.arg(value.toString());
                    }
                    block.add((JStatement)annotationMap.invoke("put").arg((String)entry.getKey()).arg((JExpression)list));
                }
            }
            JClass validatorClass = this.getCodeModel().ref(RestLiDataValidator.class);
            JVar validator = block.decl((JType)validatorClass, "validator").init((JExpression)JExpr._new((JClass)validatorClass).arg((JExpression)annotationMap).arg(valueClass.dotclass()).arg((JExpression)this.getCodeModel().ref(ResourceMethod.class).staticRef(resourceMethod.name())));
            block._return((JExpression)validator.invoke("validateInput").arg((JExpression)inputParam));
        }
        return derivedBuilderClass;
    }

    private void generateAssocKeyBindingMethods(Map<String, AssocKeyTypeInfo> assocKeys, JDefinedClass finderBuilderClass, Set<String> finderKeys) {
        StringBuilder errorBuilder = new StringBuilder();
        for (String assocKey : finderKeys) {
            JClass assocKeyClass = assocKeys.get(assocKey).getBindingType();
            if (assocKeyClass == null) {
                errorBuilder.append(String.format("assocKey %s in finder is not found\n", assocKey));
                continue;
            }
            JMethod keyMethod = finderBuilderClass.method(1, (JType)finderBuilderClass, RestLiToolsUtils.nameCamelCase(assocKey + "Key"));
            JVar keyMethodParam = keyMethod.param((JType)assocKeyClass, "key");
            keyMethod.body().add((JStatement)JExpr._super().invoke("assocKey").arg(assocKey).arg((JExpression)keyMethodParam));
            keyMethod.body()._return(JExpr._this());
        }
        if (errorBuilder.length() > 0) {
            throw new IllegalArgumentException(errorBuilder.toString());
        }
    }

    private void generatePathKeyBindingMethods(List<String> pathKeys, JDefinedClass builderClass, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys) {
        for (String pathKey : pathKeys) {
            if (pathToAssocKeys.get(pathKey) != null) {
                JFieldVar compoundKey = builderClass.field(4, CompoundKey.class, RestLiToolsUtils.nameCamelCase(pathKey), (JExpression)JExpr._new((JClass)pathKeyTypes.get(pathKey)));
                for (String assocKeyName : pathToAssocKeys.get(pathKey)) {
                    JMethod assocKeyMethod = builderClass.method(1, (JType)builderClass, RestLiToolsUtils.nameCamelCase(assocKeyName + "Key"));
                    JVar assocKeyMethodParam = assocKeyMethod.param((JType)assocKeyTypes.get(assocKeyName), "key");
                    assocKeyMethod.body().add((JStatement)compoundKey.invoke("append").arg(assocKeyName).arg((JExpression)assocKeyMethodParam));
                    assocKeyMethod.body().add((JStatement)JExpr._super().invoke("pathKey").arg(assocKeyName).arg((JExpression)assocKeyMethodParam));
                    assocKeyMethod.body().add((JStatement)JExpr._super().invoke("pathKey").arg(pathKey).arg((JExpression)compoundKey));
                    assocKeyMethod.body()._return(JExpr._this());
                }
                continue;
            }
            JMethod keyMethod = builderClass.method(1, (JType)builderClass, RestLiToolsUtils.nameCamelCase(pathKey + "Key"));
            JVar keyMethodParam = keyMethod.param((JType)pathKeyTypes.get(pathKey), "key");
            keyMethod.body().add((JStatement)JExpr._super().invoke("pathKey").arg(pathKey).arg((JExpression)keyMethodParam));
            keyMethod.body()._return(JExpr._this());
        }
    }

    private void generateActions(JDefinedClass facadeClass, JExpression baseUriExpr, ActionSchemaArray resourceActions, ActionSchemaArray entityActions, JClass keyClass, JVar resourceSpecField, String resourceName, List<String> pathKeys, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys, JExpression requestOptionsExpr) throws JClassAlreadyExistsException {
        if (resourceActions != null) {
            for (ActionSchema action : resourceActions) {
                this.generateActionMethod(facadeClass, baseUriExpr, this._voidClass, action, resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, requestOptionsExpr);
            }
        }
        if (entityActions != null) {
            for (ActionSchema action : entityActions) {
                this.generateActionMethod(facadeClass, baseUriExpr, keyClass, action, resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, requestOptionsExpr);
            }
        }
    }

    private void generateActionMethod(JDefinedClass facadeClass, JExpression baseUriExpr, JClass keyClass, ActionSchema action, JVar resourceSpecField, String resourceName, List<String> pathKeys, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeysTypes, Map<String, List<String>> pathToAssocKeys, JExpression requestOptionsExpr) throws JClassAlreadyExistsException {
        JClass returnType = this.getActionReturnType(facadeClass, action.getReturns());
        JClass vanillaActionBuilderClass = this.getCodeModel().ref(ActionRequestBuilderBase.class).narrow(new JClass[]{keyClass, returnType});
        String actionName = action.getName();
        String actionBuilderClassName = CodeUtil.capitalize((String)resourceName) + "Do" + CodeUtil.capitalize((String)actionName) + METHOD_BUILDER_SUFFIX.get(this._version);
        JDefinedClass actionBuilderClass = facadeClass.getPackage()._class(1, actionBuilderClassName);
        this.annotate(actionBuilderClass, null);
        this.checkVersionAndDeprecateBuilderClass(actionBuilderClass, false);
        actionBuilderClass._extends(vanillaActionBuilderClass.narrow((JClass)actionBuilderClass));
        JMethod actionBuilderConstructor = actionBuilderClass.constructor(1);
        JVar uriParam = actionBuilderConstructor.param((JType)this._stringClass, "baseUriTemplate");
        JVar classParam = actionBuilderConstructor.param((JType)this.getCodeModel().ref(Class.class).narrow(returnType), "returnClass");
        JVar resourceSpecParam = actionBuilderConstructor.param((JType)this._resourceSpecClass, "resourceSpec");
        JVar actionsRequestOptionsParam = actionBuilderConstructor.param(RestliRequestOptions.class, "requestOptions");
        actionBuilderConstructor.body().invoke("super").arg((JExpression)uriParam).arg((JExpression)classParam).arg((JExpression)resourceSpecParam).arg((JExpression)actionsRequestOptionsParam);
        actionBuilderConstructor.body().add((JStatement)JExpr._super().invoke(NAME).arg(actionName));
        JMethod actionMethod = facadeClass.method(1, (JType)actionBuilderClass, "action" + CodeUtil.capitalize((String)actionName));
        actionMethod.body()._return((JExpression)JExpr._new((JClass)actionBuilderClass).arg(baseUriExpr).arg(returnType.dotclass()).arg((JExpression)resourceSpecField).arg(requestOptionsExpr));
        if (action.getParameters() != null) {
            for (ParameterSchema param : action.getParameters()) {
                String paramName = param.getName();
                boolean isOptional = RestLiToolsUtils.isParameterOptional(param);
                JavaBinding binding = this.getJavaBindingType(param.getType(), facadeClass);
                JMethod typesafeMethod = this._version == RestliVersion.RESTLI_2_0_0 ? actionBuilderClass.method(1, (JType)actionBuilderClass, RestLiToolsUtils.nameCamelCase(paramName + "Param")) : actionBuilderClass.method(1, (JType)actionBuilderClass, "param" + CodeUtil.capitalize((String)paramName));
                JVar typesafeMethodParam = typesafeMethod.param((JType)binding.valueClass, "value");
                JClass dataTemplateUtil = this.getCodeModel().ref(DataTemplateUtil.class);
                JInvocation dataSchema = dataTemplateUtil.staticInvoke("getSchema").arg(binding.schemaClass.dotclass());
                typesafeMethod.body().add((JStatement)JExpr._super().invoke(isOptional ? "setParam" : "setReqParam").arg((JExpression)resourceSpecField.invoke("getRequestMetadata").arg(actionName).invoke("getFieldDef").arg(paramName)).arg((JExpression)typesafeMethodParam));
                typesafeMethod.body()._return(JExpr._this());
            }
        }
        this.generatePathKeyBindingMethods(pathKeys, actionBuilderClass, pathKeyTypes, assocKeysTypes, pathToAssocKeys);
        JavaRequestBuilderGenerator.generateClassJavadoc(actionBuilderClass, (RecordTemplate)action);
        JavaRequestBuilderGenerator.generateFactoryMethodJavadoc(actionMethod, (RecordTemplate)action);
    }

    private void generateBasicMethods(JDefinedClass facadeClass, JExpression baseUriExpr, JClass keyClass, JClass valueClass, Set<ResourceMethod> supportedMethods, RestMethodSchemaArray restMethods, JVar resourceSpecField, String resourceName, List<String> pathKeys, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys, JExpression requestOptionsExpr, DataMap annotations) throws JClassAlreadyExistsException {
        HashMap<ResourceMethod, RestMethodSchema> schemaMap = new HashMap<ResourceMethod, RestMethodSchema>();
        if (restMethods != null) {
            for (RestMethodSchema restMethod : restMethods) {
                schemaMap.put(ResourceMethod.fromString((String)restMethod.getMethod()), restMethod);
            }
        }
        HashMap<ResourceMethod, Class> crudBuilderClasses = new HashMap<ResourceMethod, Class>();
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            crudBuilderClasses.put(ResourceMethod.CREATE, CreateIdRequestBuilderBase.class);
        } else {
            crudBuilderClasses.put(ResourceMethod.CREATE, CreateRequestBuilderBase.class);
        }
        crudBuilderClasses.put(ResourceMethod.GET, GetRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.UPDATE, UpdateRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.PARTIAL_UPDATE, PartialUpdateRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.DELETE, DeleteRequestBuilderBase.class);
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            crudBuilderClasses.put(ResourceMethod.BATCH_CREATE, BatchCreateIdRequestBuilderBase.class);
        } else {
            crudBuilderClasses.put(ResourceMethod.BATCH_CREATE, BatchCreateRequestBuilderBase.class);
        }
        crudBuilderClasses.put(ResourceMethod.BATCH_UPDATE, BatchUpdateRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.BATCH_PARTIAL_UPDATE, BatchPartialUpdateRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.BATCH_DELETE, BatchDeleteRequestBuilderBase.class);
        crudBuilderClasses.put(ResourceMethod.GET_ALL, GetAllRequestBuilderBase.class);
        if (this._version == RestliVersion.RESTLI_2_0_0) {
            crudBuilderClasses.put(ResourceMethod.BATCH_GET, BatchGetEntityRequestBuilderBase.class);
        } else {
            crudBuilderClasses.put(ResourceMethod.BATCH_GET, BatchGetRequestBuilderBase.class);
        }
        for (Map.Entry entry : crudBuilderClasses.entrySet()) {
            ResourceMethod method = (ResourceMethod)entry.getKey();
            Class refModel = (Class)entry.getValue();
            if (!supportedMethods.contains(method)) continue;
            String methodName = RestLiToolsUtils.normalizeUnderscores(method.toString());
            RestMethodSchema schema = (RestMethodSchema)schemaMap.get(method);
            this.generateDerivedBuilderAndJavaDoc(facadeClass, baseUriExpr, keyClass, valueClass, resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, requestOptionsExpr, annotations, method, refModel, methodName, schema);
            if (method != ResourceMethod.CREATE && method != ResourceMethod.BATCH_CREATE || schema == null || schema.getAnnotations() == null || !schema.getAnnotations().containsKey((Object)"returnEntity")) continue;
            Class newBuildClass = methodName.equals("create") ? CreateIdEntityRequestBuilderBase.class : BatchCreateIdEntityRequestBuilderBase.class;
            String requestName = methodName.equals("create") ? "createAndGet" : "batchCreateAndGet";
            this.generateDerivedBuilderAndJavaDoc(facadeClass, baseUriExpr, keyClass, valueClass, resourceSpecField, resourceName, pathKeys, pathKeyTypes, assocKeyTypes, pathToAssocKeys, requestOptionsExpr, annotations, method, newBuildClass, requestName, schema);
        }
    }

    private void generateDerivedBuilderAndJavaDoc(JDefinedClass facadeClass, JExpression baseUriExpr, JClass keyClass, JClass valueClass, JVar resourceSpecField, String resourceName, List<String> pathKeys, Map<String, JClass> pathKeyTypes, Map<String, JClass> assocKeyTypes, Map<String, List<String>> pathToAssocKeys, JExpression requestOptionsExpr, DataMap annotations, ResourceMethod method, Class<?> refModel, String methodName, RestMethodSchema schema) throws JClassAlreadyExistsException {
        JClass builderClass = this.getCodeModel().ref(refModel).narrow(new JClass[]{keyClass, valueClass});
        JDefinedClass derivedBuilder = this.generateDerivedBuilder(builderClass, valueClass, null, resourceName + RestLiToolsUtils.nameCapsCase(methodName) + METHOD_BUILDER_SUFFIX.get(this._version), facadeClass.getPackage(), method, annotations);
        this.generatePathKeyBindingMethods(pathKeys, derivedBuilder, pathKeyTypes, assocKeyTypes, pathToAssocKeys);
        JMethod factoryMethod = facadeClass.method(1, (JType)derivedBuilder, RestLiToolsUtils.nameCamelCase(methodName));
        factoryMethod.body()._return((JExpression)JExpr._new((JClass)derivedBuilder).arg(baseUriExpr).arg((JExpression)resourceSpecField).arg(requestOptionsExpr));
        if (schema != null) {
            if (schema.hasParameters()) {
                this.generateQueryParamBindingMethods(facadeClass, schema.getParameters(), derivedBuilder);
            }
            JavaRequestBuilderGenerator.generateClassJavadoc(derivedBuilder, (RecordTemplate)schema);
            JavaRequestBuilderGenerator.generateFactoryMethodJavadoc(factoryMethod, (RecordTemplate)schema);
        }
    }

    private Map<String, AssocKeyTypeInfo> generateAssociationKey(JDefinedClass facadeClass, AssociationSchema associationSchema) throws JClassAlreadyExistsException {
        JDefinedClass typesafeKeyClass = facadeClass._class(17, "Key");
        typesafeKeyClass._extends(CompoundKey.class);
        HashMap<String, AssocKeyTypeInfo> assocKeyTypeInfos = new HashMap<String, AssocKeyTypeInfo>();
        for (AssocKeySchema assocKey : associationSchema.getAssocKeys()) {
            String name = assocKey.getName();
            JClass clazz = this.getJavaBindingType(assocKey.getType(), facadeClass).valueClass;
            JClass declaredClass = this.getClassRefForSchema(RestSpecCodec.textToSchema((String)assocKey.getType(), (DataSchemaResolver)this._schemaResolver), facadeClass);
            JMethod typesafeSetter = typesafeKeyClass.method(1, (JType)typesafeKeyClass, "set" + RestLiToolsUtils.nameCapsCase(name));
            JVar setterParam = typesafeSetter.param((JType)clazz, name);
            typesafeSetter.body().add((JStatement)JExpr.invoke((String)"append").arg(JExpr.lit((String)name)).arg((JExpression)setterParam));
            typesafeSetter.body()._return(JExpr._this());
            JMethod typesafeGetter = typesafeKeyClass.method(1, (JType)clazz, "get" + RestLiToolsUtils.nameCapsCase(name));
            typesafeGetter.body()._return((JExpression)JExpr.cast((JType)clazz, (JExpression)JExpr.invoke((String)"getPart").arg(name)));
            assocKeyTypeInfos.put(name, new AssocKeyTypeInfo(clazz, declaredClass));
        }
        typesafeKeyClass.constructor(1);
        return assocKeyTypeInfos;
    }

    private JClass getActionReturnType(JDefinedClass facadeClass, String returns) {
        JClass returnType = returns != null ? this.getJavaBindingType(returns, facadeClass).valueClass : this._voidClass;
        return returnType;
    }

    private JavaBinding getJavaBindingType(String typeSchema, JDefinedClass enclosingClass) {
        return this.getJavaBindingType(RestSpecCodec.textToSchema((String)typeSchema, (DataSchemaResolver)this._schemaResolver), enclosingClass);
    }

    private JavaBinding getJavaBindingType(DataSchema schema, JDefinedClass enclosingClass) {
        TyperefDataSchema typerefDataSchema;
        JavaBinding binding = new JavaBinding();
        if (this._generateDataTemplates || schema instanceof ArrayDataSchema) {
            ClassTemplateSpec classSpec = this.generateClassSpec(schema, enclosingClass);
            binding.schemaClass = this._javaDataTemplateGenerator.generate(classSpec);
            this._generatedArrayClasses.add(binding.schemaClass);
        }
        binding.schemaClass = this.getClassRefForSchema(schema, enclosingClass);
        binding.valueClass = this.getClassRefForSchema(schema, enclosingClass);
        if (schema instanceof TyperefDataSchema && (typerefDataSchema = (TyperefDataSchema)schema).getDereferencedDataSchema().getType() != DataSchema.Type.UNION) {
            String javaClassNameFromSchema = CustomTypeUtil.getJavaCustomTypeClassNameFromSchema((DataSchema)typerefDataSchema);
            if (javaClassNameFromSchema != null) {
                binding.valueClass = this.getCodeModel().directClass(javaClassNameFromSchema);
            } else {
                binding.valueClass = this.getJavaBindingType(typerefDataSchema.getRef(), enclosingClass).valueClass;
            }
        }
        return binding;
    }

    private ClassTemplateSpec generateClassSpec(DataSchema schema, JDefinedClass enclosingClass) {
        FileDataSchemaLocation location = new FileDataSchemaLocation(this._currentSourceFile);
        return this._specGenerator.generate(schema, (DataSchemaLocation)location);
    }

    private JClass getClassRefForSchema(DataSchema schema, JDefinedClass enclosingClass) {
        if (schema instanceof NamedDataSchema) {
            String fullName = ((NamedDataSchema)schema).getBindingName();
            return this.getCodeModel().ref(fullName);
        }
        if (schema instanceof PrimitiveDataSchema) {
            ClassTemplateSpec classSpec = this.generateClassSpec(schema, enclosingClass);
            return this._javaDataTemplateGenerator.generate(classSpec);
        }
        ClassTemplateSpec classSpec = this.generateClassSpec(schema, enclosingClass);
        return this.getCodeModel().ref(classSpec.getBindingName());
    }

    static {
        ROOT_BUILDERS_SUFFIX.put(RestliVersion.RESTLI_1_0_0, "Builders");
        ROOT_BUILDERS_SUFFIX.put(RestliVersion.RESTLI_2_0_0, "RequestBuilders");
        METHOD_BUILDER_SUFFIX = new HashMap<RestliVersion, String>();
        METHOD_BUILDER_SUFFIX.put(RestliVersion.RESTLI_1_0_0, "Builder");
        METHOD_BUILDER_SUFFIX.put(RestliVersion.RESTLI_2_0_0, "RequestBuilder");
    }

    private static class AssocKeyTypeInfo {
        private final JClass _bindingType;
        private final JClass _declaredType;

        private AssocKeyTypeInfo(JClass bindingType, JClass declaredType) {
            this._bindingType = bindingType;
            this._declaredType = declaredType;
        }

        private JClass getBindingType() {
            return this._bindingType;
        }

        private JClass getDeclaredType() {
            return this._declaredType;
        }
    }

    private static class JavaBinding {
        private JClass schemaClass;
        private JClass valueClass;

        private JavaBinding() {
        }
    }
}

