/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.data.management.copy.replication.ConfigBasedDatasetsFinder;
import org.apache.gobblin.data.management.retention.dataset.ConfigurableCleanableDataset;
import org.apache.gobblin.dataset.Dataset;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedCleanabledDatasetFinder
extends ConfigBasedDatasetsFinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBasedCleanabledDatasetFinder.class);
    public FileSystem fileSystem;
    public static final String DATASET_PATH = "gobblin.configBased.fullDatasetPath";

    public ConfigBasedCleanabledDatasetFinder(FileSystem fs, Properties jobProps) throws IOException {
        super(fs, jobProps);
        this.fileSystem = fs;
    }

    @Override
    protected Callable<Void> findDatasetsCallable(final ConfigClient confClient, final URI u, final Properties p, Optional<List<String>> blacklistURNs, final Collection<Dataset> datasets) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Config c = confClient.getConfig(u);
                ConfigurableCleanableDataset datasetForConfig = new ConfigurableCleanableDataset(ConfigBasedCleanabledDatasetFinder.this.fileSystem, p, new Path(c.getString(ConfigBasedCleanabledDatasetFinder.DATASET_PATH)), c, log);
                datasets.add(datasetForConfig);
                return null;
            }
        };
    }
}

