/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.restspec.RestSpecAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ResourceModelAnnotation {
    private static final Map<Class<? extends Annotation>, AnnotationTrait> _traits = new HashMap<Class<? extends Annotation>, AnnotationTrait>();

    public static DataMap getAnnotationsMap(Annotation[] as) {
        return ResourceModelAnnotation.annotationsToData(as, true);
    }

    private static DataMap annotationsToData(Annotation[] as, boolean isTopLevel) {
        DataMap annotationData = new DataMap();
        for (Annotation a : as) {
            AnnotationEntry entry = ResourceModelAnnotation.getAnnotationData(a, isTopLevel);
            if (entry == null) continue;
            annotationData.put((Object)entry.name, entry.data);
        }
        return annotationData;
    }

    private static Object annotationMemberToData(Object memberValue) {
        Object data;
        Class<?> memberClass = memberValue.getClass();
        if (memberClass == Boolean.TYPE || memberClass == Boolean.class || memberClass == Integer.TYPE || memberClass == Integer.class || memberClass == Long.TYPE || memberClass == Long.class || memberClass == Float.TYPE || memberClass == Float.class || memberClass == Double.TYPE || memberClass == Double.class || memberClass == String.class) {
            data = memberValue;
        } else if (memberClass == Byte.class) {
            byte[] singleByteArray = new byte[]{(Byte)memberValue};
            data = ByteString.copy((byte[])singleByteArray);
        } else if (memberClass.isEnum()) {
            data = memberValue.toString();
        } else if (memberClass == Class.class) {
            data = ((Class)memberValue).getCanonicalName();
        } else if (memberClass.isArray() && Array.getLength(memberValue) > 0) {
            if (memberClass == byte[].class) {
                data = ByteString.copy((byte[])((byte[])memberValue));
            } else if (memberClass == Annotation[].class) {
                data = ResourceModelAnnotation.annotationsToData((Annotation[])memberValue, false);
            } else {
                DataList dataList = new DataList();
                int memberArrayLen = Array.getLength(memberValue);
                for (int i = 0; i < memberArrayLen; ++i) {
                    dataList.add(ResourceModelAnnotation.annotationMemberToData(Array.get(memberValue, i)));
                }
                data = dataList.isEmpty() ? null : dataList;
            }
        } else {
            AnnotationEntry entry;
            data = memberValue instanceof Annotation ? ((entry = ResourceModelAnnotation.getAnnotationData((Annotation)memberValue, false)) == null ? null : entry.data) : null;
        }
        return data;
    }

    private static AnnotationEntry getAnnotationData(Annotation a, boolean isTopLevel) {
        DataMap data = new DataMap();
        Class<? extends Annotation> annotationClass = a.annotationType();
        AnnotationTrait trait = _traits.get(annotationClass);
        if (trait == null) {
            trait = ResourceModelAnnotation.getTraits(annotationClass, isTopLevel);
            _traits.put(annotationClass, trait);
        }
        for (Method m : annotationClass.getDeclaredMethods()) {
            MetaTrait methodTrait = trait.memberTraits.get(m);
            if (methodTrait == null || isTopLevel && !methodTrait.isRestSpecAnnotated) continue;
            try {
                Object valueData;
                Object annotationDefault;
                Object memberValue = m.invoke((Object)a, new Object[0]);
                if (methodTrait.skipDefault && (annotationDefault = m.getDefaultValue()) != null && annotationDefault.equals(memberValue) || (valueData = ResourceModelAnnotation.annotationMemberToData(memberValue)) == null) continue;
                data.put((Object)(methodTrait.isRestSpecAnnotated ? methodTrait.name : m.getName()), valueData);
            }
            catch (IllegalAccessException e) {
                throw new RestLiInternalException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RestLiInternalException(e);
            }
            catch (InvocationTargetException e) {
                throw new RestLiInternalException(e);
            }
        }
        if (data.isEmpty()) {
            if (trait.masterTrait.isRestSpecAnnotated) {
                return new AnnotationEntry(trait.masterTrait.name, new DataMap());
            }
            return null;
        }
        return new AnnotationEntry(trait.masterTrait.name, data);
    }

    private static AnnotationTrait getTraits(Class<? extends Annotation> clazz, boolean isTopLevel) {
        AnnotationTrait trait = new AnnotationTrait();
        RestSpecAnnotation classAnnotation = clazz.getAnnotation(RestSpecAnnotation.class);
        trait.masterTrait = classAnnotation == null ? new MetaTrait(false, clazz.getCanonicalName(), isTopLevel, true) : new MetaTrait(classAnnotation, clazz.getCanonicalName());
        trait.memberTraits = new HashMap<Method, MetaTrait>();
        for (Method m : clazz.getDeclaredMethods()) {
            RestSpecAnnotation methodAnnotation = m.getAnnotation(RestSpecAnnotation.class);
            if (methodAnnotation == null && !trait.masterTrait.exclude) {
                trait.memberTraits.put(m, new MetaTrait(trait.masterTrait.isRestSpecAnnotated, m.getName(), trait.masterTrait.exclude, trait.masterTrait.skipDefault));
                continue;
            }
            if (methodAnnotation == null || methodAnnotation.exclude()) continue;
            trait.memberTraits.put(m, new MetaTrait(methodAnnotation, m.getName()));
        }
        return trait;
    }

    private static class MetaTrait {
        public final boolean isRestSpecAnnotated;
        public final String name;
        public final boolean exclude;
        public final boolean skipDefault;

        public MetaTrait(boolean isRestSpecAnnotated, String customKeyName, boolean exclude, boolean skipDefault) {
            this.isRestSpecAnnotated = isRestSpecAnnotated;
            this.name = customKeyName;
            this.exclude = exclude;
            this.skipDefault = skipDefault;
        }

        public MetaTrait(RestSpecAnnotation a, String customName) {
            this.isRestSpecAnnotated = true;
            String annotatedName = a.name();
            this.name = "".equals(annotatedName) ? customName : annotatedName;
            this.exclude = a.exclude();
            this.skipDefault = a.skipDefault();
        }
    }

    private static class AnnotationTrait {
        MetaTrait masterTrait;
        Map<Method, MetaTrait> memberTraits;

        private AnnotationTrait() {
        }
    }

    private static class AnnotationEntry {
        final String name;
        final Object data;

        AnnotationEntry(String name, Object data) {
            this.name = name;
            this.data = data;
        }
    }
}

