/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.DataMap;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.AbstractSchemaEncoder;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AlternativeKeySchema;
import com.linkedin.restli.restspec.AlternativeKeySchemaArray;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssocKeySchemaArray;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.FinderSchemaArray;
import com.linkedin.restli.restspec.IdentifierSchema;
import com.linkedin.restli.restspec.MetadataSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.ResourceSchemaArray;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestMethodSchemaArray;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.server.AlternativeKey;
import com.linkedin.restli.server.Key;
import com.linkedin.restli.server.ResourceLevel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ResourceModelEncoder {
    public static final String DEPRECATED_ANNOTATION_NAME = "deprecated";
    public static final String DEPRECATED_ANNOTATION_DOC_FIELD = "doc";
    public static final String COMPOUND_KEY_TYPE_NAME = "CompoundKey";
    private final DataCodec codec = new JacksonDataCodec();
    private final DocsProvider _docsProvider;
    static Comparator<ResourceMethodDescriptor> RESOURCE_METHOD_COMPARATOR = (o1, o2) -> {
        if (o1.getFinderName() == o2.getFinderName()) {
            return 0;
        }
        if (o1.getFinderName() == null) {
            return -1;
        }
        if (o2.getFinderName() == null) {
            return 1;
        }
        return o1.getFinderName().compareTo(o2.getFinderName());
    };

    public ResourceModelEncoder(DocsProvider docsProvider) {
        this._docsProvider = docsProvider;
    }

    public ResourceSchema buildResourceSchema(ResourceModel resourceModel) {
        ResourceSchema rootNode = new ResourceSchema();
        switch (resourceModel.getResourceType()) {
            case ACTIONS: {
                this.appendActionsModel(rootNode, resourceModel);
                break;
            }
            case SIMPLE: {
                this.appendSimple(rootNode, resourceModel);
                break;
            }
            default: {
                this.appendCollection(rootNode, resourceModel);
            }
        }
        DataMap customAnnotation = resourceModel.getCustomAnnotationData();
        if (!customAnnotation.isEmpty()) {
            rootNode.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
        }
        return rootNode;
    }

    public void appendAlternativeKeys(CollectionSchema rootNode, ResourceModel resourceModel) {
        Map<String, AlternativeKey<?, ?>> alternativeKeys = resourceModel.getAlternativeKeys();
        if (!alternativeKeys.isEmpty()) {
            AlternativeKeySchemaArray altKeyArray = new AlternativeKeySchemaArray();
            for (Map.Entry<String, AlternativeKey<?, ?>> entry : alternativeKeys.entrySet()) {
                AlternativeKeySchema altKeySchema = new AlternativeKeySchema();
                altKeySchema.setName(entry.getKey());
                altKeySchema.setType(ResourceModelEncoder.buildDataSchemaType(entry.getValue().getType()));
                altKeySchema.setKeyCoercer(entry.getValue().getKeyCoercer().getClass().getCanonicalName());
                altKeyArray.add((DataTemplate)altKeySchema);
            }
            rootNode.setAlternativeKeys(altKeyArray);
        }
    }

    public ResourceSchema loadOrBuildResourceSchema(ResourceModel resourceModel) {
        StringBuilder resourceFilePath = new StringBuilder();
        if (resourceModel.getNamespace() != null) {
            resourceFilePath.append(resourceModel.getNamespace());
            resourceFilePath.append(".");
        }
        resourceFilePath.append(resourceModel.getName());
        resourceFilePath.append(".restspec.json");
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceFilePath.toString());
            if (stream == null) {
                return this.buildResourceSchema(resourceModel);
            }
            DataMap resourceSchemaDataMap = this.codec.bytesToMap(IOUtils.toByteArray((InputStream)stream));
            return new ResourceSchema(resourceSchemaDataMap);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + resourceFilePath.toString() + " from classpath.", e);
        }
    }

    static String buildDataSchemaType(Class<?> type) {
        DataSchema schema = DataTemplateUtil.getSchema(type);
        return ResourceModelEncoder.buildDataSchemaType(schema);
    }

    static String buildDataSchemaType(DataSchema schema) {
        if (schema instanceof PrimitiveDataSchema || schema instanceof NamedDataSchema) {
            return schema.getUnionMemberKey();
        }
        JsonBuilder builder = null;
        try {
            builder = new JsonBuilder(JsonBuilder.Pretty.SPACES);
            SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(builder, AbstractSchemaEncoder.TypeReferenceFormat.MINIMIZE);
            encoder.encode(schema);
            String string = builder.result();
            return string;
        }
        catch (IOException e) {
            throw new RestLiInternalException("could not encode schema for '" + schema.toString() + "'", e);
        }
        finally {
            if (builder != null) {
                builder.closeQuietly();
            }
        }
    }

    private static String buildDataSchemaType(Class<?> type, DataSchema dataSchema) {
        DataSchema schemaToEncode;
        if (dataSchema instanceof TyperefDataSchema) {
            return ((TyperefDataSchema)dataSchema).getFullName();
        }
        if (dataSchema instanceof PrimitiveDataSchema || dataSchema instanceof NamedDataSchema) {
            return dataSchema.getUnionMemberKey();
        }
        if (dataSchema instanceof UnionDataSchema && HasTyperefInfo.class.isAssignableFrom(type)) {
            TyperefInfo unionRef = DataTemplateUtil.getTyperefInfo(type.asSubclass(DataTemplate.class));
            schemaToEncode = unionRef.getSchema();
        } else {
            schemaToEncode = dataSchema;
        }
        JsonBuilder builder = null;
        try {
            builder = new JsonBuilder(JsonBuilder.Pretty.SPACES);
            SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(builder, AbstractSchemaEncoder.TypeReferenceFormat.MINIMIZE);
            encoder.encode(schemaToEncode);
            String string = builder.result();
            return string;
        }
        catch (IOException e) {
            throw new RestLiInternalException("could not encode schema for '" + type.getName() + "'", e);
        }
        finally {
            if (builder != null) {
                builder.closeQuietly();
            }
        }
    }

    public static String buildPath(ResourceModel resourceModel) {
        StringBuilder sb = new StringBuilder();
        ResourceModelEncoder.buildPathInternal(resourceModel, sb, false);
        return sb.toString();
    }

    private static String buildPathForEntity(ResourceModel resourceModel) {
        StringBuilder sb = new StringBuilder();
        ResourceModelEncoder.buildPathInternal(resourceModel, sb, true);
        return sb.toString();
    }

    private static void buildPathInternal(ResourceModel resourceModel, StringBuilder sb, boolean addEntityElement) {
        do {
            if (addEntityElement && resourceModel.getKeys().size() >= 1) {
                sb.insert(0, "/{" + resourceModel.getKeyName() + "}");
            }
            sb.insert(0, "/" + resourceModel.getName());
            addEntityElement = true;
        } while ((resourceModel = resourceModel.getParentResourceModel()) != null);
    }

    private void appendCommon(ResourceModel resourceModel, ResourceSchema resourceSchema) {
        resourceSchema.setName(resourceModel.getName());
        if (!resourceModel.getNamespace().isEmpty()) {
            resourceSchema.setNamespace(resourceModel.getNamespace());
        }
        resourceSchema.setPath(ResourceModelEncoder.buildPath(resourceModel));
        Class<? extends RecordTemplate> valueClass = resourceModel.getValueClass();
        if (valueClass != null) {
            resourceSchema.setSchema(DataTemplateUtil.getSchema(valueClass).getUnionMemberKey());
        }
        Class<?> resourceClass = resourceModel.getResourceClass();
        String doc = this._docsProvider.getClassDoc(resourceClass);
        StringBuilder docBuilder = new StringBuilder();
        if (doc != null) {
            docBuilder.append(doc).append("\n\n");
        }
        docBuilder.append("generated from: ").append(resourceClass.getCanonicalName());
        String deprecatedDoc = this._docsProvider.getClassDeprecatedTag(resourceClass);
        if (deprecatedDoc != null) {
            DataMap customAnnotationData = resourceModel.getCustomAnnotationData();
            if (customAnnotationData == null) {
                customAnnotationData = new DataMap();
                resourceModel.setCustomAnnotation(customAnnotationData);
            }
            customAnnotationData.put((Object)DEPRECATED_ANNOTATION_NAME, (Object)this.deprecateDocToAnnotationMap(deprecatedDoc));
        }
        resourceSchema.setDoc(docBuilder.toString());
    }

    private void appendCollection(ResourceSchema resourceSchema, ResourceModel collectionModel) {
        ActionSchemaArray actions;
        this.appendCommon(collectionModel, resourceSchema);
        CollectionSchema collectionSchema = new CollectionSchema();
        AssociationSchema associationSchema = new AssociationSchema(collectionSchema.data());
        if (collectionModel.getKeys().size() == 1) {
            this.appendIdentifierNode(collectionSchema, collectionModel);
        } else {
            this.appendKeys(associationSchema, collectionModel);
        }
        this.appendAlternativeKeys(collectionSchema, collectionModel);
        this.appendSupportsNodeToCollectionSchema(collectionSchema, collectionModel);
        this.appendMethodsToCollectionSchema(collectionSchema, collectionModel);
        FinderSchemaArray finders = this.createFinders(collectionModel);
        if (finders.size() > 0) {
            collectionSchema.setFinders(finders);
        }
        if ((actions = this.createActions(collectionModel, ResourceLevel.COLLECTION)).size() > 0) {
            collectionSchema.setActions(actions);
        }
        this.appendEntityToCollectionSchema(collectionSchema, collectionModel);
        switch (collectionModel.getResourceType()) {
            case COLLECTION: {
                resourceSchema.setCollection(collectionSchema);
                break;
            }
            case ASSOCIATION: {
                resourceSchema.setAssociation(associationSchema);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported resource type");
            }
        }
    }

    private void appendActionsModel(ResourceSchema resourceSchema, ResourceModel resourceModel) {
        this.appendCommon(resourceModel, resourceSchema);
        ActionsSetSchema actionsNode = new ActionsSetSchema();
        ActionSchemaArray actions = this.createActions(resourceModel, ResourceLevel.COLLECTION);
        if (actions.size() > 0) {
            actionsNode.setActions(actions);
        }
        resourceSchema.setActionsSet(actionsNode);
    }

    private void appendSimple(ResourceSchema resourceSchema, ResourceModel resourceModel) {
        this.appendCommon(resourceModel, resourceSchema);
        SimpleSchema simpleSchema = new SimpleSchema();
        this.appendSupportsNodeToSimpleSchema(simpleSchema, resourceModel);
        this.appendMethodsToSimpleSchema(simpleSchema, resourceModel);
        ActionSchemaArray actions = this.createActions(resourceModel, ResourceLevel.ENTITY);
        if (actions.size() > 0) {
            simpleSchema.setActions(actions);
        }
        this.appendEntityToSimpleSchema(simpleSchema, resourceModel);
        resourceSchema.setSimple(simpleSchema);
    }

    private void appendEntityToCollectionSchema(CollectionSchema collectionSchema, ResourceModel resourceModel) {
        EntitySchema entityNode = this.buildEntitySchema(resourceModel);
        collectionSchema.setEntity(entityNode);
    }

    private void appendEntityToSimpleSchema(SimpleSchema simpleSchema, ResourceModel resourceModel) {
        EntitySchema entityNode = this.buildEntitySchema(resourceModel);
        simpleSchema.setEntity(entityNode);
    }

    private EntitySchema buildEntitySchema(ResourceModel resourceModel) {
        ActionSchemaArray actions;
        EntitySchema entityNode = new EntitySchema();
        entityNode.setPath(ResourceModelEncoder.buildPathForEntity(resourceModel));
        if (resourceModel.getResourceLevel() == ResourceLevel.COLLECTION && (actions = this.createActions(resourceModel, ResourceLevel.ENTITY)).size() > 0) {
            entityNode.setActions(actions);
        }
        ResourceSchemaArray subresources = new ResourceSchemaArray();
        for (ResourceModel subResourceModel : resourceModel.getSubResources()) {
            ResourceSchema subresource = new ResourceSchema();
            switch (subResourceModel.getResourceType()) {
                case COLLECTION: 
                case ASSOCIATION: {
                    this.appendCollection(subresource, subResourceModel);
                    break;
                }
                case SIMPLE: {
                    this.appendSimple(subresource, subResourceModel);
                    break;
                }
            }
            DataMap customAnnotation = subResourceModel.getCustomAnnotationData();
            if (!customAnnotation.isEmpty()) {
                subresource.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
            }
            subresources.add((DataTemplate)subresource);
        }
        if (subresources.size() > 0) {
            Collections.sort(subresources, new Comparator<ResourceSchema>(){

                @Override
                public int compare(ResourceSchema resourceSchema, ResourceSchema resourceSchema2) {
                    return resourceSchema.getName().compareTo(resourceSchema2.getName());
                }
            });
            entityNode.setSubresources(subresources);
        }
        return entityNode;
    }

    private void appendKeys(AssociationSchema associationSchema, ResourceModel collectionModel) {
        AssocKeySchemaArray assocKeySchemaArray = new AssocKeySchemaArray();
        ArrayList<Key> sortedKeys = new ArrayList<Key>(collectionModel.getKeys());
        Collections.sort(sortedKeys, new Comparator<Key>(){

            @Override
            public int compare(Key o1, Key o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Key key : sortedKeys) {
            AssocKeySchema assocKeySchema = new AssocKeySchema();
            assocKeySchema.setName(key.getName());
            assocKeySchema.setType(ResourceModelEncoder.buildDataSchemaType(key.getType(), key.getDataSchema()));
            assocKeySchemaArray.add((DataTemplate)assocKeySchema);
        }
        associationSchema.setAssocKeys(assocKeySchemaArray);
        associationSchema.setIdentifier(collectionModel.getKeyName());
    }

    private ActionSchemaArray createActions(ResourceModel resourceModel, ResourceLevel resourceLevel) {
        ActionSchemaArray actionsArray = new ActionSchemaArray();
        List<ResourceMethodDescriptor> resourceMethodDescriptors = resourceModel.getResourceMethodDescriptors();
        Collections.sort(resourceMethodDescriptors, new Comparator<ResourceMethodDescriptor>(){

            @Override
            public int compare(ResourceMethodDescriptor o1, ResourceMethodDescriptor o2) {
                if (o1.getType().equals((Object)ResourceMethod.ACTION)) {
                    if (o2.getType().equals((Object)ResourceMethod.ACTION)) {
                        return o1.getActionName().compareTo(o2.getActionName());
                    }
                    return 1;
                }
                if (o2.getType().equals((Object)ResourceMethod.ACTION)) {
                    return -1;
                }
                return 0;
            }
        });
        for (ResourceMethodDescriptor resourceMethodDescriptor : resourceMethodDescriptors) {
            Class<?> returnType;
            ParameterSchemaArray parameters;
            if (!ResourceMethod.ACTION.equals((Object)resourceMethodDescriptor.getType()) || resourceMethodDescriptor.getActionResourceLevel() != resourceLevel) continue;
            ActionSchema action = new ActionSchema();
            action.setName(resourceMethodDescriptor.getActionName());
            String methodDoc = this._docsProvider.getMethodDoc(resourceMethodDescriptor.getMethod());
            if (methodDoc != null) {
                String returnDoc;
                StringBuilder methodDocBuilder = new StringBuilder(methodDoc.trim());
                if (methodDocBuilder.length() > 0 && (returnDoc = ResourceModelEncoder.sanitizeDoc(this._docsProvider.getReturnDoc(resourceMethodDescriptor.getMethod()))) != null && !returnDoc.isEmpty()) {
                    methodDocBuilder.append("\n");
                    methodDocBuilder.append("Service Returns: ");
                    methodDocBuilder.append(returnDoc.substring(0, 1).toUpperCase());
                    methodDocBuilder.append(returnDoc.substring(1));
                }
                action.setDoc(methodDocBuilder.toString());
            }
            if ((parameters = this.createParameters(resourceMethodDescriptor)).size() > 0) {
                action.setParameters(parameters);
            }
            if ((returnType = resourceMethodDescriptor.getActionReturnType()) != Void.TYPE) {
                String returnTypeString = ResourceModelEncoder.buildDataSchemaType(returnType, resourceMethodDescriptor.getActionReturnRecordDataSchema().getField("value").getType());
                action.setReturns(returnTypeString);
            }
            DataMap customAnnotation = resourceMethodDescriptor.getCustomAnnotationData();
            String deprecatedDoc = this._docsProvider.getMethodDeprecatedTag(resourceMethodDescriptor.getMethod());
            if (deprecatedDoc != null) {
                customAnnotation.put((Object)DEPRECATED_ANNOTATION_NAME, (Object)this.deprecateDocToAnnotationMap(deprecatedDoc));
            }
            if (!customAnnotation.isEmpty()) {
                action.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
            }
            actionsArray.add((DataTemplate)action);
        }
        return actionsArray;
    }

    static String sanitizeDoc(String doc) {
        if (doc != null) {
            String returnComment = doc.trim().replaceAll("[ \\t]+", " ");
            returnComment = returnComment.replace("\n ", "\n");
            returnComment = returnComment.replace(" \n", "\n");
            return returnComment;
        }
        return null;
    }

    private DataMap deprecateDocToAnnotationMap(String deprecatedDoc) {
        deprecatedDoc = deprecatedDoc.trim();
        DataMap deprecatedAnnotation = new DataMap();
        if (!deprecatedDoc.isEmpty()) {
            deprecatedAnnotation.put((Object)DEPRECATED_ANNOTATION_DOC_FIELD, (Object)deprecatedDoc);
        }
        return deprecatedAnnotation;
    }

    private FinderSchemaArray createFinders(ResourceModel resourceModel) {
        FinderSchemaArray findersArray = new FinderSchemaArray();
        List<ResourceMethodDescriptor> resourceMethodDescriptors = resourceModel.getResourceMethodDescriptors();
        Collections.sort(resourceMethodDescriptors, RESOURCE_METHOD_COMPARATOR);
        for (ResourceMethodDescriptor resourceMethodDescriptor : resourceMethodDescriptors) {
            StringArray assocKeys;
            ParameterSchemaArray parameters;
            if (!ResourceMethod.FINDER.equals((Object)resourceMethodDescriptor.getType())) continue;
            FinderSchema finder = new FinderSchema();
            finder.setName(resourceMethodDescriptor.getFinderName());
            String doc = this._docsProvider.getMethodDoc(resourceMethodDescriptor.getMethod());
            if (doc != null) {
                finder.setDoc(doc);
            }
            if ((parameters = this.createParameters(resourceMethodDescriptor)).size() > 0) {
                finder.setParameters(parameters);
            }
            if ((assocKeys = this.createAssocKeyParameters(resourceMethodDescriptor)).size() > 0) {
                finder.setAssocKeys(assocKeys);
            }
            if (resourceMethodDescriptor.getFinderMetadataType() != null) {
                Class<? extends RecordTemplate> metadataType = resourceMethodDescriptor.getFinderMetadataType();
                MetadataSchema metadataSchema = new MetadataSchema();
                metadataSchema.setType(ResourceModelEncoder.buildDataSchemaType(metadataType));
                finder.setMetadata(metadataSchema);
            }
            DataMap customAnnotation = resourceMethodDescriptor.getCustomAnnotationData();
            String deprecatedDoc = this._docsProvider.getMethodDeprecatedTag(resourceMethodDescriptor.getMethod());
            if (deprecatedDoc != null) {
                customAnnotation.put((Object)DEPRECATED_ANNOTATION_NAME, (Object)this.deprecateDocToAnnotationMap(deprecatedDoc));
            }
            if (!customAnnotation.isEmpty()) {
                finder.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
            }
            if (resourceMethodDescriptor.isPagingSupported()) {
                finder.setPagingSupported(true);
            }
            findersArray.add((DataTemplate)finder);
        }
        return findersArray;
    }

    private StringArray createAssocKeyParameters(ResourceMethodDescriptor resourceMethodDescriptor) {
        StringArray assocKeys = new StringArray();
        for (Parameter<?> param : resourceMethodDescriptor.getParameters()) {
            if (param.getParamType() != Parameter.ParamType.KEY && param.getParamType() != Parameter.ParamType.ASSOC_KEY_PARAM) continue;
            assocKeys.add((Object)param.getName());
        }
        return assocKeys;
    }

    private ParameterSchemaArray createParameters(ResourceMethodDescriptor resourceMethodDescriptor) {
        ParameterSchemaArray parameterSchemaArray = new ParameterSchemaArray();
        for (Parameter<?> param : resourceMethodDescriptor.getParameters()) {
            DataMap customAnnotation;
            if (!param.isCustom() || param.getParamType() == Parameter.ParamType.KEY || param.getParamType() == Parameter.ParamType.ASSOC_KEY_PARAM) continue;
            ParameterSchema paramSchema = new ParameterSchema();
            paramSchema.setName(param.getName());
            paramSchema.setType(ResourceModelEncoder.buildDataSchemaType(param.getType(), param.getDataSchema()));
            Object defaultValueData = param.getDefaultValueData();
            if (defaultValueData == null && param.isOptional()) {
                paramSchema.setOptional(true);
            } else if (defaultValueData != null) {
                paramSchema.setDefault(defaultValueData.toString());
            }
            String paramDoc = this._docsProvider.getParamDoc(resourceMethodDescriptor.getMethod(), param.getName());
            if (paramDoc != null) {
                paramSchema.setDoc(paramDoc);
            }
            if (!(customAnnotation = param.getCustomAnnotationData()).isEmpty()) {
                paramSchema.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
            }
            parameterSchemaArray.add((DataTemplate)paramSchema);
        }
        return parameterSchemaArray;
    }

    private RestMethodSchemaArray createRestMethods(ResourceModel resourceModel) {
        ResourceMethod[] crudMethods;
        RestMethodSchemaArray restMethods = new RestMethodSchemaArray();
        for (ResourceMethod method : crudMethods = new ResourceMethod[]{ResourceMethod.CREATE, ResourceMethod.GET, ResourceMethod.UPDATE, ResourceMethod.PARTIAL_UPDATE, ResourceMethod.DELETE, ResourceMethod.BATCH_CREATE, ResourceMethod.BATCH_GET, ResourceMethod.BATCH_UPDATE, ResourceMethod.BATCH_PARTIAL_UPDATE, ResourceMethod.BATCH_DELETE, ResourceMethod.GET_ALL}) {
            ParameterSchemaArray parameters;
            ResourceMethodDescriptor descriptor = resourceModel.findMethod(method);
            if (descriptor == null) continue;
            RestMethodSchema restMethod = new RestMethodSchema();
            restMethod.setMethod(method.toString());
            String doc = this._docsProvider.getMethodDoc(descriptor.getMethod());
            if (doc != null) {
                restMethod.setDoc(doc);
            }
            if ((parameters = this.createParameters(descriptor)).size() > 0) {
                restMethod.setParameters(parameters);
            }
            DataMap customAnnotation = descriptor.getCustomAnnotationData();
            String deprecatedDoc = this._docsProvider.getMethodDeprecatedTag(descriptor.getMethod());
            if (deprecatedDoc != null) {
                customAnnotation.put((Object)DEPRECATED_ANNOTATION_NAME, (Object)this.deprecateDocToAnnotationMap(deprecatedDoc));
            }
            if (!customAnnotation.isEmpty()) {
                restMethod.setAnnotations(new CustomAnnotationContentSchemaMap(customAnnotation));
            }
            if (method == ResourceMethod.GET_ALL && descriptor.isPagingSupported()) {
                restMethod.setPagingSupported(true);
            }
            restMethods.add((DataTemplate)restMethod);
        }
        return restMethods;
    }

    private void appendSupportsNodeToCollectionSchema(CollectionSchema collectionSchema, ResourceModel resourceModel) {
        StringArray supportsArray = this.buildSupportsNode(resourceModel);
        collectionSchema.setSupports(supportsArray);
    }

    private void appendMethodsToCollectionSchema(CollectionSchema collectionSchema, ResourceModel resourceModel) {
        RestMethodSchemaArray restMethods = this.createRestMethods(resourceModel);
        if (restMethods.size() > 0) {
            collectionSchema.setMethods(restMethods);
        }
    }

    private void appendSupportsNodeToSimpleSchema(SimpleSchema simpleSchema, ResourceModel resourceModel) {
        StringArray supportsArray = this.buildSupportsNode(resourceModel);
        simpleSchema.setSupports(supportsArray);
    }

    private void appendMethodsToSimpleSchema(SimpleSchema simpleSchema, ResourceModel resourceModel) {
        RestMethodSchemaArray restMethods = this.createRestMethods(resourceModel);
        if (restMethods.size() > 0) {
            simpleSchema.setMethods(restMethods);
        }
    }

    private StringArray buildSupportsNode(ResourceModel resourceModel) {
        StringArray supportsArray = new StringArray();
        this.buildSupportsArray(resourceModel, supportsArray);
        return supportsArray;
    }

    private void buildSupportsArray(ResourceModel resourceModel, StringArray supportsArray) {
        ArrayList<String> supportsStrings = new ArrayList<String>();
        for (ResourceMethodDescriptor resourceMethodDescriptor : resourceModel.getResourceMethodDescriptors()) {
            ResourceMethod type = resourceMethodDescriptor.getType();
            if (type.equals((Object)ResourceMethod.FINDER) || type.equals((Object)ResourceMethod.ACTION)) continue;
            supportsStrings.add(type.toString());
        }
        Collections.sort(supportsStrings);
        for (String s : supportsStrings) {
            supportsArray.add((Object)s);
        }
    }

    private void appendIdentifierNode(CollectionSchema collectionNode, ResourceModel collectionResource) {
        IdentifierSchema identifierSchema = new IdentifierSchema();
        identifierSchema.setName(collectionResource.getKeyName());
        if (collectionResource.getKeyClass().equals(ComplexResourceKey.class)) {
            identifierSchema.setType(ResourceModelEncoder.buildDataSchemaType(collectionResource.getKeyKeyClass()));
            identifierSchema.setParams(ResourceModelEncoder.buildDataSchemaType(collectionResource.getKeyParamsClass()));
        } else {
            Key key = collectionResource.getPrimaryKey();
            identifierSchema.setType(ResourceModelEncoder.buildDataSchemaType(key.getType(), key.getDataSchema()));
        }
        collectionNode.setIdentifier(identifierSchema);
    }

    public static class NullDocsProvider
    implements DocsProvider {
        @Override
        public void registerSourceFiles(Collection<String> filenames) {
        }

        @Override
        public Set<String> supportedFileExtensions() {
            return Collections.emptySet();
        }

        @Override
        public String getClassDoc(Class<?> resourceClass) {
            return null;
        }

        @Override
        public String getClassDeprecatedTag(Class<?> resourceClass) {
            return null;
        }

        @Override
        public String getMethodDoc(Method method) {
            return null;
        }

        @Override
        public String getMethodDeprecatedTag(Method method) {
            return null;
        }

        @Override
        public String getParamDoc(Method method, String name) {
            return null;
        }

        @Override
        public String getReturnDoc(Method method) {
            return null;
        }
    }

    public static interface DocsProvider {
        public Set<String> supportedFileExtensions();

        public void registerSourceFiles(Collection<String> var1);

        public String getClassDoc(Class<?> var1);

        public String getClassDeprecatedTag(Class<?> var1);

        public String getMethodDoc(Method var1);

        public String getMethodDeprecatedTag(Method var1);

        public String getParamDoc(Method var1, String var2);

        public String getReturnDoc(Method var1);
    }
}

