/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Tag<T>
extends AbstractMap.SimpleEntry<String, T> {
    private static final long serialVersionUID = -5083709915031933607L;
    private static final char KEY_VALUE_SEPARATOR = ':';

    public static Tag<String> fromString(String tagKeyValue) {
        List splitKeyValue = Splitter.on((char)':').limit(2).omitEmptyStrings().splitToList((CharSequence)tagKeyValue);
        if (splitKeyValue.size() == 2) {
            return new Tag<String>((String)splitKeyValue.get(0), (String)splitKeyValue.get(1));
        }
        return null;
    }

    public Tag(String key, T value) {
        super(key, value);
    }

    public Tag(Map.Entry<? extends String, ? extends T> entry) {
        super(entry);
    }

    public static <T> List<Tag<T>> fromMap(Map<? extends String, T> tagsMap) {
        ImmutableList.Builder tagsBuilder = ImmutableList.builder();
        for (Map.Entry<String, T> entry : tagsMap.entrySet()) {
            tagsBuilder.add(new Tag<T>(entry));
        }
        return tagsBuilder.build();
    }

    public static <T> Map<? extends String, T> toMap(List<Tag<T>> tags) {
        ImmutableMap.Builder tagsMapBuilder = ImmutableMap.builder();
        for (Tag<T> tag : tags) {
            tagsMapBuilder.put(tag.getKey(), tag.getValue());
        }
        return tagsMapBuilder.build();
    }

    public static List<Tag<String>> tagValuesToString(List<? extends Tag<?>> tags) {
        return Lists.transform(tags, (Function)new Function<Tag<?>, Tag<String>>(){

            @Nullable
            public Tag<String> apply(Tag<?> input) {
                return input == null ? null : Tag.tagValueToString(input);
            }
        });
    }

    public static Tag<String> tagValueToString(Tag<?> tag) {
        return new Tag<String>((String)tag.getKey(), tag.getValue().toString());
    }

    @Override
    public String toString() {
        return (String)this.getKey() + ':' + this.getValue();
    }
}

