/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.test;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.notification.EventNotification;
import org.apache.gobblin.metrics.notification.Notification;

public class MetricsAssert
implements Function<Notification, Void> {
    private final MetricContext _metricContext;
    private final LinkedBlockingQueue<GobblinTrackingEvent> _events = new LinkedBlockingQueue();

    public MetricsAssert(MetricContext metricContext) {
        this._metricContext = metricContext;
        this._metricContext.addNotificationTarget(this);
    }

    public Void apply(Notification input) {
        if (input instanceof EventNotification) {
            this._events.offer(((EventNotification)input).getEvent());
        }
        return null;
    }

    public MetricContext getMetricContext() {
        return this._metricContext;
    }

    public void assertEvent(Predicate<GobblinTrackingEvent> predicate, long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        GobblinTrackingEvent gte;
        GobblinTrackingEvent gobblinTrackingEvent = gte = timeout > 0L ? this._events.poll(timeout, timeUnit) : this._events.take();
        if (null == gte) {
            throw new TimeoutException();
        }
        if (!predicate.apply((Object)gte)) {
            throw new AssertionError((Object)("Event predicate mismatch: " + (Object)((Object)gte)));
        }
    }

    public void assertEvent(Predicate<GobblinTrackingEvent> predicate) throws InterruptedException {
        try {
            this.assertEvent(predicate, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Error("This should never happen");
        }
    }

    public static Predicate<GobblinTrackingEvent> eqEventName(final String expectedName) {
        return new Predicate<GobblinTrackingEvent>(){

            public boolean apply(@Nonnull GobblinTrackingEvent input) {
                return input.getName().equals(expectedName);
            }
        };
    }

    public static Predicate<GobblinTrackingEvent> eqEventNamespace(final String expectedNamespace) {
        return new Predicate<GobblinTrackingEvent>(){

            public boolean apply(@Nonnull GobblinTrackingEvent input) {
                return input.getNamespace().equals(expectedNamespace);
            }
        };
    }

    public static Predicate<GobblinTrackingEvent> eqEventMetdata(final String metadataKey, final String metadataValue) {
        return new Predicate<GobblinTrackingEvent>(){

            public boolean apply(@Nonnull GobblinTrackingEvent input) {
                return input.getMetadata().get(metadataKey).equals(metadataValue);
            }
        };
    }

    public static Predicate<GobblinTrackingEvent> hasEventMetdata(final String metadataKey) {
        return new Predicate<GobblinTrackingEvent>(){

            public boolean apply(@Nonnull GobblinTrackingEvent input) {
                return input.getMetadata().containsKey(metadataKey);
            }
        };
    }
}

