/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.clients;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.Facilities;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.r2.RetriableRequestException;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryClient
implements D2Client {
    private static final Logger LOG = LoggerFactory.getLogger(RetryClient.class);
    private final D2Client _d2Client;
    private final int _limit;

    public RetryClient(D2Client d2Client, int limit) {
        this._d2Client = d2Client;
        this._limit = limit;
        LOG.debug("Retry client created with limit set to: ", (Object)this._limit);
    }

    public Future<RestResponse> restRequest(RestRequest request) {
        return this.restRequest(request, new RequestContext());
    }

    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        FutureCallback future = new FutureCallback();
        this.restRequest(request, requestContext, (Callback<RestResponse>)future);
        return future;
    }

    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.restRequest(request, new RequestContext(), callback);
    }

    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        Callback<RestResponse> transportCallback = this.decorateCallback(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).restRequest(arg_0, arg_1, arg_2), callback);
        this._d2Client.restRequest(request, requestContext, transportCallback);
    }

    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.streamRequest(request, new RequestContext(), callback);
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        Callback<StreamResponse> transportCallback = this.decorateCallback(request, requestContext, (arg_0, arg_1, arg_2) -> ((D2Client)this._d2Client).streamRequest(arg_0, arg_1, arg_2), callback);
        this._d2Client.streamRequest(request, requestContext, transportCallback);
    }

    private <R, T> Callback<T> decorateCallback(final R request, final RequestContext requestContext, final DecoratorClient<R, T> client, final Callback<T> callback) {
        return new Callback<T>(){

            public void onError(Throwable e) {
                URI targetHostUri;
                boolean retry = false;
                if (e instanceof RetriableRequestException && (targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext)) == null) {
                    Set<URI> exclusionSet = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
                    int attempts = exclusionSet.size();
                    if (attempts <= RetryClient.this._limit) {
                        LOG.warn("A retriable exception happens. Going to retry. This is attempt {}. Current exclusion set: ", (Object)attempts, (Object)(". Current exclusion set: " + exclusionSet));
                        retry = true;
                        client.doRequest(request, requestContext, this);
                    } else {
                        LOG.warn("Retry limit exceeded. This request will fail.");
                    }
                }
                if (!retry) {
                    LoadBalancerStrategy.ExcludedHostHints.clearRequestContextExcludedHosts(requestContext);
                    callback.onError(e);
                }
            }

            public void onSuccess(T result) {
                LoadBalancerStrategy.ExcludedHostHints.clearRequestContextExcludedHosts(requestContext);
                callback.onSuccess(result);
            }
        };
    }

    public void shutdown(Callback<None> callback) {
        this._d2Client.shutdown(callback);
    }

    public Map<String, Object> getMetadata(URI uri) {
        return this._d2Client.getMetadata(uri);
    }

    @Override
    public Facilities getFacilities() {
        return this._d2Client.getFacilities();
    }

    public void start(Callback<None> callback) {
        this._d2Client.start(callback);
    }

    static interface DecoratorClient<R, T> {
        public void doRequest(R var1, RequestContext var2, Callback<T> var3);
    }
}

