/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ServicePropertiesJsonSerializer
implements PropertySerializer<ServiceProperties>,
PropertyBuilder<ServiceProperties> {
    public static void main(String[] args) throws UnsupportedEncodingException, URISyntaxException, PropertySerializationException {
        String serviceName = "testService";
        String clusterName = "testCluster";
        String path = "/foo/bar";
        List<String> loadBalancerStrategyList = Arrays.asList("degrader");
        ServiceProperties property = new ServiceProperties(serviceName, clusterName, path, loadBalancerStrategyList);
        ServicePropertiesJsonSerializer serializer = new ServicePropertiesJsonSerializer();
        System.err.println(new String(serializer.toBytes(property), "UTF-8"));
        System.err.println(serializer.fromBytes(serializer.toBytes(property)));
    }

    @Override
    public byte[] toBytes(ServiceProperties property) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString((Object)property).getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ServiceProperties fromBytes(byte[] bytes) throws PropertySerializationException {
        try {
            Map untyped = (Map)JacksonUtil.getObjectMapper().readValue(new String(bytes, "UTF-8"), Map.class);
            return this.fromMap(untyped);
        }
        catch (Exception e) {
            throw new PropertySerializationException(e);
        }
    }

    private static <T> T mapGet(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }

    @Override
    public ServiceProperties fromMap(Map<String, Object> map) {
        Map publishedMetadataProperties;
        String defaultRoutingToMaster;
        List bannedList;
        Map<String, String> degraderProperties;
        Map<String, Object> transportClientProperties;
        List<String> loadBalancerStrategyList;
        Map<String, Object> loadBalancerStrategyProperties = (Map<String, Object>)ServicePropertiesJsonSerializer.mapGet(map, "loadBalancerStrategyProperties");
        if (loadBalancerStrategyProperties == null) {
            loadBalancerStrategyProperties = Collections.emptyMap();
        }
        if ((loadBalancerStrategyList = (List<String>)ServicePropertiesJsonSerializer.mapGet(map, "loadBalancerStrategyList")) == null) {
            loadBalancerStrategyList = Collections.emptyList();
        }
        if ((transportClientProperties = (Map<String, Object>)ServicePropertiesJsonSerializer.mapGet(map, "transportClientProperties")) == null) {
            transportClientProperties = Collections.emptyMap();
        }
        if ((degraderProperties = (Map<String, String>)ServicePropertiesJsonSerializer.mapGet(map, "degraderProperties")) == null) {
            degraderProperties = Collections.emptyMap();
        }
        if ((bannedList = (List)ServicePropertiesJsonSerializer.mapGet(map, "bannedUri")) == null) {
            bannedList = Collections.emptyList();
        }
        HashSet<URI> banned = new HashSet<URI>(bannedList);
        List prioritizedSchemes = (List)ServicePropertiesJsonSerializer.mapGet(map, "prioritizedSchemes");
        HashMap<String, Object> metadataProperties = new HashMap<String, Object>();
        String isDefaultService = (String)ServicePropertiesJsonSerializer.mapGet(map, "isDefaultService");
        if (isDefaultService != null && "true".equalsIgnoreCase(isDefaultService)) {
            metadataProperties.put("isDefaultService", isDefaultService);
        }
        if (Boolean.valueOf(defaultRoutingToMaster = (String)ServicePropertiesJsonSerializer.mapGet(map, "defaultRoutingToMaster")).booleanValue()) {
            metadataProperties.put("defaultRoutingToMaster", defaultRoutingToMaster);
        }
        if ((publishedMetadataProperties = (Map)ServicePropertiesJsonSerializer.mapGet(map, "serviceMetadataProperties")) != null) {
            metadataProperties.putAll(publishedMetadataProperties);
        }
        if (degraderProperties.containsKey("degrader.initialDropRate") && !"multiProbe".equalsIgnoreCase((String)ServicePropertiesJsonSerializer.mapGet(loadBalancerStrategyProperties, "http.loadBalancer.consistentHashAlgorithm"))) {
            degraderProperties.remove("degrader.initialDropRate");
        }
        return new ServiceProperties((String)map.get("serviceName"), (String)map.get("clusterName"), (String)map.get("path"), loadBalancerStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, metadataProperties);
    }
}

