/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.healthcheck;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckOperations;
import com.linkedin.d2.balancer.util.healthcheck.TransportHealthCheck;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.util.clock.Clock;
import java.net.URI;
import java.net.URISyntaxException;

public class HealthCheckClientBuilder {
    private HealthCheckOperations _healthOperations;
    private String _healthCheckPath;
    private String _servicePath;
    private Clock _clock;
    private long _latency;
    private TrackerClient _client;
    private String _method;

    public HealthCheckClientBuilder() {
        this(null, "", "", null, 0L, null, "OPTIONS");
    }

    public HealthCheckClientBuilder(HealthCheckOperations ops, String path, String servicePath, Clock clk, long latency, TrackerClient client, String method) {
        this._healthOperations = ops;
        this._healthCheckPath = path;
        this._servicePath = servicePath;
        this._clock = clk;
        this._latency = latency;
        this._client = client;
        this._method = method;
    }

    public HealthCheck build() throws URISyntaxException {
        URI curUri = this._client.getUri();
        String fullPath = this._healthCheckPath;
        if (this._healthCheckPath == null || this._healthCheckPath.isEmpty()) {
            fullPath = curUri.getPath();
            if (this._servicePath != null && !this._servicePath.isEmpty()) {
                fullPath = fullPath + this._servicePath;
            }
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)curUri);
        URI newUri = uriBuilder.replacePath(fullPath).build(new Object[0]);
        HealthCheckOperations operations = this._healthOperations;
        if (operations == null) {
            operations = new HealthCheckOperations();
        }
        return new TransportHealthCheck(this._clock, this._client.getWrappedClient(), operations.buildRestRequest(this._method, newUri), operations.buildRequestContext(), operations.buildWireAttributes(), operations.buildResponseValidate(), this._latency);
    }

    public HealthCheckClientBuilder setHealthCheckOperations(HealthCheckOperations ops) {
        this._healthOperations = ops;
        return this;
    }

    public HealthCheckClientBuilder setHealthCheckPath(String path) {
        this._healthCheckPath = path;
        return this;
    }

    public HealthCheckClientBuilder setServicePath(String path) {
        this._servicePath = path;
        return this;
    }

    public HealthCheckClientBuilder setClock(Clock clk) {
        this._clock = clk;
        return this;
    }

    public HealthCheckClientBuilder setLatency(long latency) {
        this._latency = latency;
        return this;
    }

    public HealthCheckClientBuilder setClient(TrackerClient client) {
        this._client = client;
        return this;
    }

    public HealthCheckClientBuilder setMethod(String method) {
        this._method = method;
        return this;
    }
}

