/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV2_1;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV2_1JmxMBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;

public class DegraderLoadBalancerStrategyV2_1Jmx
implements DegraderLoadBalancerStrategyV2_1JmxMBean {
    private final DegraderLoadBalancerStrategyV2_1 _strategy;

    public DegraderLoadBalancerStrategyV2_1Jmx(DegraderLoadBalancerStrategyV2_1 strategy) {
        this._strategy = strategy;
    }

    @Override
    public double getOverrideClusterDropRate() {
        double rate = this._strategy.getCurrentOverrideDropRate();
        return rate;
    }

    @Override
    public String toString() {
        return "DegraderLoadBalancerStrategyV2_1Jmx [_strategy=" + this._strategy + "]";
    }

    @Override
    public int getTotalPointsInHashRing() {
        Map<URI, Integer> uris = this._strategy.getState().getPointsMap();
        int total = 0;
        for (Map.Entry<URI, Integer> entry : uris.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    @Override
    public String getPointsMap() {
        return this._strategy.getState().getPointsMap().toString();
    }

    @Override
    public String getUnhealthyClientsPoints() {
        int pointsPerWeight = this._strategy.getConfig().getPointsPerWeight();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<URI, Integer> entry : this._strategy.getState().getPointsMap().entrySet()) {
            if (entry.getValue() >= pointsPerWeight) continue;
            result.add(entry.getKey().toString() + ":" + entry.getValue() + "/" + pointsPerWeight);
        }
        return ((Object)result).toString();
    }
}

