/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.fork;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.runtime.BoundedBlockingRecordQueue;
import org.apache.gobblin.runtime.ExecutionModel;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.fork.Fork;
import org.apache.gobblin.util.concurrent.AutoResetEvent;

public class SynchronousFork
extends Fork {
    private AutoResetEvent autoResetEvent = new AutoResetEvent();
    private volatile Throwable throwable;

    public SynchronousFork(TaskContext taskContext, Object schema, int branches, int index, ExecutionModel executionModel) throws Exception {
        super(taskContext, schema, branches, index, executionModel);
    }

    @Override
    protected void processRecords() throws IOException, DataConversionException {
        try {
            this.autoResetEvent.waitOne();
            if (this.throwable != null) {
                Throwables.propagateIfPossible((Throwable)this.throwable, IOException.class, DataConversionException.class);
                throw new RuntimeException(this.throwable);
            }
        }
        catch (InterruptedException ie) {
            Throwables.propagate((Throwable)ie);
        }
    }

    @Override
    protected boolean putRecordImpl(Object record) throws InterruptedException {
        try {
            this.processRecord(record);
        }
        catch (Throwable t) {
            this.throwable = t;
            this.autoResetEvent.set();
        }
        return true;
    }

    @Override
    public void markParentTaskDone() {
        super.markParentTaskDone();
        this.autoResetEvent.set();
    }

    @Override
    public Optional<BoundedBlockingRecordQueue.QueueStats> queueStats() {
        return Optional.absent();
    }
}

