/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class JobConfigurationUtils {
    public static Properties combineSysAndJobProperties(Properties sysProps, Properties jobProps) {
        Properties combinedJobProps = new Properties();
        combinedJobProps.putAll((Map<?, ?>)sysProps);
        combinedJobProps.putAll((Map<?, ?>)jobProps);
        return combinedJobProps;
    }

    public static void putPropertiesIntoConfiguration(Properties properties, org.apache.hadoop.conf.Configuration configuration) {
        for (String name : properties.stringPropertyNames()) {
            configuration.set(name, properties.getProperty(name));
        }
    }

    public static void putConfigurationIntoProperties(org.apache.hadoop.conf.Configuration configuration, Properties properties) {
        for (Map.Entry entry : configuration) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    public static void putStateIntoConfiguration(State state, org.apache.hadoop.conf.Configuration configuration) {
        for (String key : state.getPropertyNames()) {
            configuration.set(key, state.getProp(key));
        }
    }

    public static Properties fileToProperties(String fileName, org.apache.hadoop.conf.Configuration conf) throws IOException, ConfigurationException {
        PropertiesConfiguration propsConfig = new PropertiesConfiguration();
        Path filePath = new Path(fileName);
        URI fileURI = filePath.toUri();
        if (fileURI.getScheme() == null && fileURI.getAuthority() == null) {
            propsConfig.load((InputStream)FileSystem.getLocal((org.apache.hadoop.conf.Configuration)conf).open(filePath));
        } else {
            propsConfig.load((InputStream)filePath.getFileSystem(conf).open(filePath));
        }
        return ConfigurationConverter.getProperties((Configuration)propsConfig);
    }

    public static Properties fileToProperties(String fileName) throws IOException, ConfigurationException {
        return JobConfigurationUtils.fileToProperties(fileName, new org.apache.hadoop.conf.Configuration());
    }
}

