/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.instance.plugin.hadoop;

import com.typesafe.config.Config;
import java.beans.ConstructorProperties;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.GobblinInstancePlugin;
import org.apache.gobblin.runtime.api.GobblinInstancePluginFactory;
import org.apache.gobblin.runtime.instance.hadoop.HadoopConfigLoader;
import org.apache.gobblin.runtime.instance.plugin.BaseIdlePluginImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopKerberosKeytabAuthenticationPlugin
extends BaseIdlePluginImpl {
    private static final Logger log = LoggerFactory.getLogger(HadoopKerberosKeytabAuthenticationPlugin.class);
    private final String _loginUser;
    private final String _loginUserKeytabFile;
    private final Configuration _hadoopConf;

    private HadoopKerberosKeytabAuthenticationPlugin(Config sysConfig, String loginUser, String loginUserKeytabFile) {
        super(null);
        this._loginUser = loginUser;
        this._loginUserKeytabFile = loginUserKeytabFile;
        HadoopConfigLoader configLoader = new HadoopConfigLoader(sysConfig);
        this._hadoopConf = configLoader.getConf();
    }

    protected void startUp() throws Exception {
        try {
            UserGroupInformation.setConfiguration((Configuration)this._hadoopConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)this._loginUser, (String)this._loginUserKeytabFile);
            }
        }
        catch (Throwable t) {
            log.error("Failed to start up HadoopKerberosKeytabAuthenticationPlugin", t);
            throw t;
        }
    }

    protected void shutDown() throws Exception {
        log.info("Plugin shutdown: " + (Object)((Object)this));
    }

    public String getLoginUser() {
        return this._loginUser;
    }

    public String getLoginUserKeytabFile() {
        return this._loginUserKeytabFile;
    }

    public Configuration getHadoopConf() {
        return this._hadoopConf;
    }

    public static class CredentialsBasedFactory
    implements GobblinInstancePluginFactory {
        private final String _loginUser;
        private final String _loginUserKeytabFile;

        public GobblinInstancePlugin createPlugin(GobblinInstanceDriver instance) {
            return new HadoopKerberosKeytabAuthenticationPlugin(instance.getSysConfig().getConfig(), this._loginUser, this._loginUserKeytabFile);
        }

        @ConstructorProperties(value={"_loginUser", "_loginUserKeytabFile"})
        public CredentialsBasedFactory(String _loginUser, String _loginUserKeytabFile) {
            this._loginUser = _loginUser;
            this._loginUserKeytabFile = _loginUserKeytabFile;
        }
    }

    @Alias(value="hadoopLoginFromKeytab")
    public static class ConfigBasedFactory
    implements GobblinInstancePluginFactory {
        public GobblinInstancePlugin createPlugin(GobblinInstanceDriver instance) {
            return this.createPlugin(instance.getSysConfig().getConfig());
        }

        public GobblinInstancePlugin createPlugin(Config sysConfig) {
            if (!sysConfig.hasPath("gobblin.instance.hadoop.loginUser")) {
                throw new RuntimeException("Missing required sys config: gobblin.instance.hadoop.loginUser");
            }
            if (!sysConfig.hasPath("gobblin.instance.hadoop.loginUserKeytabFile")) {
                throw new RuntimeException("Missing required sys config: gobblin.instance.hadoop.loginUserKeytabFile");
            }
            String loginUser = sysConfig.getString("gobblin.instance.hadoop.loginUser");
            String loginUserKeytabFile = sysConfig.getString("gobblin.instance.hadoop.loginUserKeytabFile");
            return new HadoopKerberosKeytabAuthenticationPlugin(sysConfig, loginUser, loginUserKeytabFile);
        }
    }
}

