/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.gobblin.compaction.CliOptions;
import org.apache.gobblin.compaction.hive.AvroExternalTable;
import org.apache.gobblin.compaction.hive.SerialCompactor;
import org.apache.gobblin.compaction.mapreduce.MRCompactionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionRunner.class);
    private static final String COMPACTION_CONFIG_DIR = "compaction.config.dir";
    private static final String TIMING_FILE = "timing.file";
    private static final String TIMING_FILE_DEFAULT = "time.txt";
    private static final String SNAPSHOT = "snapshot";
    private static final String DELTA = "delta";
    private static final String NAME = ".name";
    private static final String PKEY = ".pkey";
    private static final String DATALOCATION = ".datalocation";
    private static final String SCHEMALOCATION = ".schemalocation";
    private static final String COPYDATA = ".copydata";
    private static final String COPYDATA_DEFAULT = "false";
    private static final String DATAFORMAT_EXTENSION_NAME = ".dataformat.extension.name";
    private static final String OUTPUT = "output";
    static Properties properties = new Properties();
    static Properties jobProperties = new Properties();

    public static void main(String[] args) throws IOException, ConfigurationException {
        properties = CliOptions.parseArgs(MRCompactionRunner.class, args);
        File compactionConfigDir = new File(properties.getProperty(COMPACTION_CONFIG_DIR));
        File[] listOfFiles = compactionConfigDir.listFiles();
        if (listOfFiles == null || listOfFiles.length == 0) {
            System.err.println("No compaction configuration files found under " + compactionConfigDir);
            System.exit(1);
        }
        int numOfJobs = 0;
        for (File file : listOfFiles) {
            if (!file.isFile() || file.getName().startsWith(".")) continue;
            ++numOfJobs;
        }
        LOG.info("Found " + numOfJobs + " compaction tasks.");
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(properties.getProperty(TIMING_FILE, TIMING_FILE_DEFAULT)), Charset.forName("UTF-8")));){
            for (File file : listOfFiles) {
                if (!file.isFile() || file.getName().startsWith(".")) continue;
                PropertiesConfiguration jobConfig = new PropertiesConfiguration(file.getAbsolutePath());
                jobProperties = ConfigurationConverter.getProperties((Configuration)jobConfig);
                long startTime = System.nanoTime();
                CompactionRunner.compact();
                long endTime = System.nanoTime();
                long elapsedTime = endTime - startTime;
                double seconds = TimeUnit.NANOSECONDS.toSeconds(elapsedTime);
                pw.printf("%s: %f%n", file.getAbsolutePath(), seconds);
            }
        }
    }

    private static void compact() throws IOException {
        SerialCompactor sc = new SerialCompactor.Builder().withSnapshot(CompactionRunner.buildSnapshotTable()).withDeltas(CompactionRunner.buildDeltaTables()).withOutputTableName(jobProperties.getProperty("output.name")).withOutputDataLocationInHdfs(jobProperties.getProperty("output.datalocation")).build();
        sc.compact();
    }

    private static AvroExternalTable buildSnapshotTable() throws IOException {
        return CompactionRunner.buildAvroExternalTable(SNAPSHOT);
    }

    private static List<AvroExternalTable> buildDeltaTables() throws IOException {
        String deltai;
        ArrayList<AvroExternalTable> deltas = new ArrayList<AvroExternalTable>();
        int i = 1;
        while (jobProperties.getProperty((deltai = "delta." + i) + DATALOCATION) != null) {
            deltas.add(CompactionRunner.buildAvroExternalTable(deltai));
            ++i;
        }
        return deltas;
    }

    private static AvroExternalTable buildAvroExternalTable(String tableType) throws IOException {
        AvroExternalTable.Builder builder = ((AvroExternalTable.Builder)((AvroExternalTable.Builder)new AvroExternalTable.Builder().withName(jobProperties.getProperty(tableType + NAME, ""))).withPrimaryKeys(jobProperties.getProperty(tableType + PKEY))).withSchemaLocation(jobProperties.getProperty(tableType + SCHEMALOCATION, "")).withDataLocation(jobProperties.getProperty(tableType + DATALOCATION));
        if (Boolean.parseBoolean(jobProperties.getProperty(tableType + COPYDATA, COPYDATA_DEFAULT))) {
            builder = builder.withMoveDataToTmpHdfsDir(jobProperties.getProperty(tableType + DATAFORMAT_EXTENSION_NAME, ""));
        }
        return builder.build();
    }
}

