/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;

public class AvroCompatibilityChecker {
    private static SchemaValidator BACKWARD_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateLatest();
    public static AvroCompatibilityChecker BACKWARD_CHECKER = new AvroCompatibilityChecker(BACKWARD_VALIDATOR);
    private static SchemaValidator FORWARD_VALIDATOR = new SchemaValidatorBuilder().canBeReadStrategy().validateLatest();
    public static AvroCompatibilityChecker FORWARD_CHECKER = new AvroCompatibilityChecker(FORWARD_VALIDATOR);
    private static SchemaValidator FULL_VALIDATOR = new SchemaValidatorBuilder().mutualReadStrategy().validateLatest();
    public static AvroCompatibilityChecker FULL_CHECKER = new AvroCompatibilityChecker(FULL_VALIDATOR);
    private static SchemaValidator NO_OP_VALIDATOR = new SchemaValidator(){

        public void validate(Schema schema, Iterable<Schema> schemas) throws SchemaValidationException {
        }
    };
    public static AvroCompatibilityChecker NO_OP_CHECKER = new AvroCompatibilityChecker(NO_OP_VALIDATOR);
    private final SchemaValidator validator;

    private AvroCompatibilityChecker(SchemaValidator validator) {
        this.validator = validator;
    }

    public boolean isCompatible(Schema newSchema, Schema latestSchema) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(latestSchema);
        try {
            this.validator.validate(newSchema, schemas);
        }
        catch (SchemaValidationException e) {
            return false;
        }
        return true;
    }
}

