/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.apache.gobblin.metastore.predicates.StateStorePredicate;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;

public interface DatasetStateStore<T extends State>
extends StateStore<T> {
    public static final String DATASET_STATE_STORE_TABLE_SUFFIX = ".jst";
    public static final String CURRENT_DATASET_STATE_FILE_SUFFIX = "current";
    public static final Pattern TABLE_NAME_PARSER_PATTERN = Pattern.compile("^(?:(.+)-)?([^-]+)\\.jst$");

    public Map<String, T> getLatestDatasetStatesByUrns(String var1) throws IOException;

    public T getLatestDatasetState(String var1, String var2) throws IOException;

    public void persistDatasetState(String var1, T var2) throws IOException;

    public void persistDatasetURNs(String var1, Collection<String> var2) throws IOException;

    @Override
    default public List<? extends DatasetStateStoreEntryManager> getMetadataForTables(StateStorePredicate predicate) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public String sanitizeDatasetStatestoreNameFromDatasetURN(String storeName, String datasetURN) throws IOException {
        return datasetURN;
    }

    public static String buildTableName(DatasetStateStore store, String storeName, String stateId, String datasetUrn) throws IOException {
        return Strings.isNullOrEmpty((String)datasetUrn) ? stateId + DATASET_STATE_STORE_TABLE_SUFFIX : store.sanitizeDatasetStatestoreNameFromDatasetURN(storeName, datasetUrn) + "-" + stateId + DATASET_STATE_STORE_TABLE_SUFFIX;
    }

    public static DatasetStateStore buildDatasetStateStore(Config config) throws IOException {
        ClassAliasResolver resolver = new ClassAliasResolver(Factory.class);
        String stateStoreType = ConfigUtils.getString((Config)config, (String)"state.store.type", (String)"fs");
        try {
            Factory stateStoreFactory = (Factory)resolver.resolveClass(stateStoreType).newInstance();
            return stateStoreFactory.createStateStore(config);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static class TableNameParser {
        private final String sanitizedDatasetUrn;
        private final String stateId;

        public TableNameParser(String tableName) {
            Matcher matcher = TABLE_NAME_PARSER_PATTERN.matcher(tableName);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Cannot parse table name " + tableName);
            }
            this.sanitizedDatasetUrn = matcher.group(1);
            this.stateId = matcher.group(2);
        }

        public String getSanitizedDatasetUrn() {
            return this.sanitizedDatasetUrn;
        }

        public String getStateId() {
            return this.stateId;
        }
    }

    public static interface Factory {
        public <T extends State> DatasetStateStore<T> createStateStore(Config var1);
    }
}

