/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.services.webmasters.Webmasters;
import com.google.api.services.webmasters.model.ApiDataRow;
import com.google.api.services.webmasters.model.ApiDimensionFilter;
import com.google.api.services.webmasters.model.ApiDimensionFilterGroup;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryRequest;
import com.google.api.services.webmasters.model.SearchAnalyticsQueryResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterClient;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.source.extractor.extract.google.GoogleCommon;

public class GoogleWebmasterClientImpl
extends GoogleWebmasterClient {
    private final Webmasters.Searchanalytics _analytics;
    private final Webmasters _service;

    public GoogleWebmasterClientImpl(Credential credential, String appName) throws IOException {
        this._service = new Webmasters.Builder(credential.getTransport(), GoogleCommon.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName(appName).build();
        this._analytics = this._service.searchanalytics();
    }

    @Override
    public BatchRequest createBatch() {
        return this._service.batch();
    }

    @Override
    public List<String> getPages(String siteProperty, String startDate, String endDate, String country, int rowLimit, List<GoogleWebmasterFilter.Dimension> requestedDimensions, List<ApiDimensionFilter> filters, int startRow) throws IOException {
        GoogleWebmasterClientImpl.checkRowLimit(rowLimit);
        Preconditions.checkArgument((boolean)requestedDimensions.contains((Object)GoogleWebmasterFilter.Dimension.PAGE));
        SearchAnalyticsQueryResponse rspByCountry = (SearchAnalyticsQueryResponse)this.createSearchAnalyticsQuery(siteProperty, startDate, endDate, requestedDimensions, GoogleWebmasterFilter.andGroupFilters(filters), rowLimit, startRow).execute();
        List pageRows = rspByCountry.getRows();
        ArrayList<String> pages = new ArrayList<String>(rowLimit);
        if (pageRows != null) {
            int pageIndex = requestedDimensions.indexOf((Object)GoogleWebmasterFilter.Dimension.PAGE);
            for (ApiDataRow row : pageRows) {
                pages.add((String)row.getKeys().get(pageIndex));
            }
        }
        return pages;
    }

    @Override
    public Webmasters.Searchanalytics.Query createSearchAnalyticsQuery(String siteProperty, String startDate, String endDate, List<GoogleWebmasterFilter.Dimension> dimensions, ApiDimensionFilterGroup filterGroup, int rowLimit, int startRow) throws IOException {
        ArrayList<String> dimensionStrings = new ArrayList<String>();
        for (GoogleWebmasterFilter.Dimension dimension : dimensions) {
            dimensionStrings.add(dimension.toString().toLowerCase());
        }
        SearchAnalyticsQueryRequest request = new SearchAnalyticsQueryRequest().setStartDate(startDate).setEndDate(endDate).setRowLimit(Integer.valueOf(rowLimit)).setDimensions(dimensionStrings).setStartRow(Integer.valueOf(startRow));
        if (filterGroup != null) {
            request.setDimensionFilterGroups(Arrays.asList(filterGroup));
        }
        return this._analytics.query(siteProperty, request);
    }

    private static void checkRowLimit(int rowLimit) {
        Preconditions.checkArgument((rowLimit > 0 && rowLimit <= 5000 ? 1 : 0) != 0, (Object)"Row limit for Google Search Console API must be within range (0, 5000]");
    }
}

