/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.applicationautoscaling.model.ScalableDimension;
import com.amazonaws.services.applicationautoscaling.model.ServiceNamespace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeScalableTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceNamespace;
    private List<String> resourceIds;
    private String scalableDimension;
    private Integer maxResults;
    private String nextToken;

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public DescribeScalableTargetsRequest withServiceNamespace(String serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    public void setServiceNamespace(ServiceNamespace serviceNamespace) {
        this.serviceNamespace = serviceNamespace.toString();
    }

    public DescribeScalableTargetsRequest withServiceNamespace(ServiceNamespace serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new ArrayList<String>(resourceIds);
    }

    public DescribeScalableTargetsRequest withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add(ele);
        }
        return this;
    }

    public DescribeScalableTargetsRequest withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public void setScalableDimension(String scalableDimension) {
        this.scalableDimension = scalableDimension;
    }

    public String getScalableDimension() {
        return this.scalableDimension;
    }

    public DescribeScalableTargetsRequest withScalableDimension(String scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    public void setScalableDimension(ScalableDimension scalableDimension) {
        this.scalableDimension = scalableDimension.toString();
    }

    public DescribeScalableTargetsRequest withScalableDimension(ScalableDimension scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeScalableTargetsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeScalableTargetsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceNamespace() != null) {
            sb.append("ServiceNamespace: " + this.getServiceNamespace() + ",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: " + this.getResourceIds() + ",");
        }
        if (this.getScalableDimension() != null) {
            sb.append("ScalableDimension: " + this.getScalableDimension() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalableTargetsRequest)) {
            return false;
        }
        DescribeScalableTargetsRequest other = (DescribeScalableTargetsRequest)obj;
        if (other.getServiceNamespace() == null ^ this.getServiceNamespace() == null) {
            return false;
        }
        if (other.getServiceNamespace() != null && !other.getServiceNamespace().equals(this.getServiceNamespace())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getScalableDimension() == null ^ this.getScalableDimension() == null) {
            return false;
        }
        if (other.getScalableDimension() != null && !other.getScalableDimension().equals(this.getScalableDimension())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceNamespace() == null ? 0 : this.getServiceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getScalableDimension() == null ? 0 : this.getScalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeScalableTargetsRequest clone() {
        return (DescribeScalableTargetsRequest)super.clone();
    }
}

