/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.ZNRecord;

public class StateTransitionTimeoutConfig {
    private final String _resource;
    private final Map<String, String> _timeoutMap;

    public StateTransitionTimeoutConfig(ZNRecord record) {
        this._resource = record.getId();
        this._timeoutMap = record.getMapFields().containsKey(StateTransitionTimeoutProperty.TIMEOUT.name()) ? record.getMapField(StateTransitionTimeoutProperty.TIMEOUT.name()) : new HashMap<String, String>();
    }

    public void setStateTransitionTimeout(String from, String to, int timeout) {
        this.setStateTransitionTimeout(null, from, to, timeout);
    }

    private void setStateTransitionTimeout(String partitionName, String from, String to, int timeout) {
        if (partitionName != null) {
            this._timeoutMap.put(partitionName, String.valueOf(timeout));
        } else {
            this._timeoutMap.put(String.format("%s.%s", from, to), String.valueOf(timeout));
        }
    }

    public int getStateTransitionTimeout(String partitionName, String from, String to) {
        if (partitionName != null && this._timeoutMap.containsKey(partitionName)) {
            return Integer.parseInt(this._timeoutMap.get(partitionName));
        }
        if (this._timeoutMap.containsKey(String.format("%s.%s", from, to))) {
            return Integer.parseInt(this._timeoutMap.get(String.format("%s.%s", from, to)));
        }
        if (this._timeoutMap.containsKey(String.format("*.%s", to))) {
            return Integer.parseInt(this._timeoutMap.get(String.format("*.%s", to)));
        }
        if (this._timeoutMap.containsKey(String.format("%s.*", from))) {
            return Integer.parseInt(this._timeoutMap.get(String.format("%s.*", from)));
        }
        if (this._timeoutMap.containsKey("*.*")) {
            return Integer.parseInt(this._timeoutMap.get("*.*"));
        }
        return -1;
    }

    public int getStateTransitionTimeout(String from, String to) {
        return this.getStateTransitionTimeout(null, from, to);
    }

    public Map<String, String> getTimeoutMap() {
        return this._timeoutMap;
    }

    public String getResource() {
        return this._resource;
    }

    public static StateTransitionTimeoutConfig fromRecord(ZNRecord record) {
        return record.getMapFields().containsKey(StateTransitionTimeoutProperty.TIMEOUT.name()) ? new StateTransitionTimeoutConfig(record) : null;
    }

    public static enum StateTransitionTimeoutProperty {
        TIMEOUT;

    }
}

