/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.log4j.Logger;

public class ReadClusterDataStage
extends AbstractBaseStage {
    private static final Logger logger = Logger.getLogger((String)ReadClusterDataStage.class.getName());
    private ClusterDataCache _cache = null;

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START ReadClusterDataStage.process()");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (cache == null && this._cache == null) {
            cache = new ClusterDataCache();
        }
        this._cache = cache;
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        this._cache.refresh(dataAccessor);
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
        if (clusterStatusMonitor != null) {
            HashSet instanceSet = Sets.newHashSet();
            HashSet liveInstanceSet = Sets.newHashSet();
            HashSet disabledInstanceSet = Sets.newHashSet();
            HashMap disabledPartitions = Maps.newHashMap();
            HashMap tags = Maps.newHashMap();
            Map<String, LiveInstance> liveInstanceMap = this._cache.getLiveInstances();
            for (Map.Entry<String, InstanceConfig> e : this._cache.getInstanceConfigMap().entrySet()) {
                String instanceName = e.getKey();
                InstanceConfig config = e.getValue();
                instanceSet.add(instanceName);
                if (liveInstanceMap.containsKey(instanceName)) {
                    liveInstanceSet.add(instanceName);
                }
                if (!config.getInstanceEnabled()) {
                    disabledInstanceSet.add(instanceName);
                }
                disabledPartitions.put(instanceName, config.getDisabledPartitionsMap());
                HashSet instanceTags = Sets.newHashSet(config.getTags());
                tags.put(instanceName, instanceTags);
            }
            clusterStatusMonitor.setClusterInstanceStatus(liveInstanceSet, instanceSet, disabledInstanceSet, disabledPartitions, tags);
        }
        event.addAttribute("ClusterDataCache", this._cache);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END ReadClusterDataStage.process(). took: " + (endTime - startTime) + " ms"));
    }
}

