/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedList;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.CreateIdEntityStatus;
import com.linkedin.restli.common.CreateStatus;
import com.linkedin.restli.internal.common.CreateIdEntityStatusDecoder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchCreateIdEntityResponse<K, V extends RecordTemplate>
extends RecordTemplate {
    private final List<CreateIdEntityStatus<K, V>> _collection;

    public BatchCreateIdEntityResponse(DataMap map, CreateIdEntityStatusDecoder<K, V> idEntityDecoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        super(map, BatchCreateIdEntityResponse.generateSchema());
        this._collection = this.createCollectionFromDecoder(idEntityDecoder);
    }

    public BatchCreateIdEntityResponse(List<CreateIdEntityStatus<K, V>> elements) {
        super(BatchCreateIdEntityResponse.generateDataMap(elements), BatchCreateIdEntityResponse.generateSchema());
        this._collection = elements;
    }

    private static DataMap generateDataMap(List<? extends RecordTemplate> elements) {
        DataMap dataMap = new DataMap();
        DataList listElements = new DataList();
        for (RecordTemplate recordTemplate : elements) {
            CreateIdEntityStatus status = (CreateIdEntityStatus)recordTemplate;
            CheckedUtil.addWithoutChecking((CheckedList)listElements, (Object)status.data());
        }
        dataMap.put((Object)"elements", (Object)listElements);
        return dataMap;
    }

    private static RecordDataSchema generateSchema() {
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        ArrayDataSchema arraySchema = new ArrayDataSchema((DataSchema)new RecordDataSchema(new Name(CreateStatus.class.getSimpleName()), RecordDataSchema.RecordType.RECORD));
        RecordDataSchema.Field arrayField = new RecordDataSchema.Field((DataSchema)arraySchema);
        arrayField.setName("elements", errorMessageBuilder);
        RecordDataSchema schema = new RecordDataSchema(new Name(BatchCreateIdEntityResponse.class.getSimpleName()), RecordDataSchema.RecordType.RECORD);
        schema.setFields(Arrays.asList(arrayField), errorMessageBuilder);
        return schema;
    }

    private List<CreateIdEntityStatus<K, V>> createCollectionFromDecoder(CreateIdEntityStatusDecoder<K, V> decoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        DataList elements = this.data().getDataList("elements");
        ArrayList<CreateIdEntityStatus<K, V>> collection = new ArrayList<CreateIdEntityStatus<K, V>>(elements.size());
        for (Object obj : elements) {
            DataMap dataMap = (DataMap)obj;
            CreateIdEntityStatus<K, V> status = this.decodeValue(dataMap, decoder);
            collection.add(status);
        }
        return collection;
    }

    private CreateIdEntityStatus<K, V> decodeValue(DataMap dataMap, CreateIdEntityStatusDecoder<K, V> decoder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return decoder.makeValue(dataMap);
    }

    public List<CreateIdEntityStatus<K, V>> getElements() {
        return this._collection;
    }
}

