/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.restli.common.CollectionMetadata;
import java.util.Arrays;
import java.util.List;

public class CollectionResponse<T extends RecordTemplate>
extends RecordTemplate {
    public static final String ELEMENTS = "elements";
    public static final String METADATA = "metadata";
    public static final String PAGING = "paging";
    private static final RecordDataSchema.Field PAGING_FIELD = new RecordDataSchema.Field(DataTemplateUtil.getSchema(CollectionMetadata.class));
    private final Class<T> _elementClass;
    private final ArrayDataSchema _arraySchema;
    private final RecordDataSchema.Field _arrayField;
    private final RecordDataSchema _schema;
    private static final Name _COLLECTION_RESPONSE_NAME;

    public CollectionResponse(Class<T> elementClass) {
        this(new DataMap(), elementClass);
    }

    public CollectionResponse(DataMap data, Class<T> elementClass) {
        super(data, null);
        this._elementClass = elementClass;
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        Name elementSchemaName = new Name(elementClass.getSimpleName());
        this._arraySchema = new ArrayDataSchema((DataSchema)new RecordDataSchema(elementSchemaName, RecordDataSchema.RecordType.RECORD));
        this._arrayField = new RecordDataSchema.Field((DataSchema)this._arraySchema);
        this._arrayField.setName(ELEMENTS, errorMessageBuilder);
        if (this.data().get((Object)ELEMENTS) == null) {
            this.data().put((Object)ELEMENTS, (Object)new DataList());
        }
        this._schema = new RecordDataSchema(_COLLECTION_RESPONSE_NAME, RecordDataSchema.RecordType.RECORD);
        this._schema.setFields(Arrays.asList(this._arrayField, PAGING_FIELD), errorMessageBuilder);
    }

    public RecordDataSchema schema() {
        return this._schema;
    }

    public List<T> getElements() {
        DataList value = (DataList)this.data().get((Object)ELEMENTS);
        return new DynamicRecordArray<T>(value, this._arraySchema, this._elementClass);
    }

    public boolean hasPaging() {
        return this.contains(PAGING_FIELD);
    }

    public void removePaging() {
        this.remove(PAGING_FIELD);
    }

    public CollectionMetadata getPaging() {
        return (CollectionMetadata)this.obtainWrapped(PAGING_FIELD, CollectionMetadata.class, GetMode.STRICT);
    }

    public void setPaging(CollectionMetadata value) {
        this.putWrapped(PAGING_FIELD, CollectionMetadata.class, (DataTemplate)value);
    }

    public void setMetadataRaw(DataMap metadata) {
        if (metadata != null) {
            this.data().put((Object)METADATA, (Object)metadata);
        }
    }

    public DataMap getMetadataRaw() {
        return (DataMap)this.data().get((Object)METADATA);
    }

    static {
        PAGING_FIELD.setName(PAGING, new StringBuilder(10));
        _COLLECTION_RESPONSE_NAME = new Name(CollectionResponse.class.getSimpleName());
    }

    private static class DynamicRecordArray<R extends RecordTemplate>
    extends WrappingArrayTemplate<R> {
        public DynamicRecordArray(DataList list, ArrayDataSchema arraySchema, Class<R> elementClass) {
            super(list, arraySchema, elementClass);
        }
    }
}

