/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.KeyValueRecordFactory;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.util.CustomTypeUtil;
import java.util.Map;

public class KeyValueRecord<K, V extends RecordTemplate>
extends RecordTemplate {
    public static final String KEY_FIELD_NAME = "key";
    public static final String VALUE_FIELD_NAME = "value";
    public static final String PARAMS_FIELD_NAME = "$params";

    public KeyValueRecord(DataMap dataMap) {
        super(dataMap, null);
    }

    KeyValueRecord() {
        super(new DataMap(), null);
    }

    void setPrimitiveKey(RecordDataSchema.Field keyField, K key, TypeSpec<K> keyType) {
        DataSchema keySchema = keyType.getSchema();
        if (keySchema.isPrimitive()) {
            this.putDirect(keyField, keyType.getType(), keyType.getType(), key, SetMode.IGNORE_NULL);
            return;
        }
        switch (keySchema.getType()) {
            case TYPEREF: {
                TyperefDataSchema typerefDataSchema = (TyperefDataSchema)keySchema;
                DataSchema.Type dereferencedType = keySchema.getDereferencedType();
                Class javaClassForSchema = CustomTypeUtil.getJavaCustomTypeClassFromSchema((DataSchema)typerefDataSchema);
                if (javaClassForSchema == null) {
                    this.putDirect(keyField, keyType.getType(), keyType.getType(), key, SetMode.IGNORE_NULL);
                    break;
                }
                Class keyDereferencedClass = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchemaClass((DataSchema.Type)dereferencedType);
                this.putDirect(keyField, javaClassForSchema, keyDereferencedClass, key, SetMode.IGNORE_NULL);
                break;
            }
            case ENUM: {
                this.putDirect(keyField, keyType.getType(), String.class, key, SetMode.IGNORE_NULL);
                break;
            }
            default: {
                throw new IllegalArgumentException("key is not a primitive, typeref, or an enum!");
            }
        }
    }

    <KK extends RecordTemplate, KP extends RecordTemplate> void setComplexKey(RecordDataSchema.Field keyField, RecordDataSchema.Field paramsField, K key, ComplexKeySpec<KK, KP> complexKeyType) {
        if (!(key instanceof ComplexResourceKey)) {
            throw new IllegalArgumentException("Key must be a ComplexResourceKey!");
        }
        ComplexResourceKey complexResourceKey = (ComplexResourceKey)key;
        Object keyKey = complexResourceKey.getKey();
        Object keyParams = complexResourceKey.getParams();
        this.putWrapped(keyField, complexKeyType.getKeyType().getType(), (DataTemplate)keyKey, SetMode.IGNORE_NULL);
        this.putWrapped(paramsField, complexKeyType.getParamsType().getType(), (DataTemplate)keyParams, SetMode.IGNORE_NULL);
    }

    void setCompoundKey(RecordDataSchema.Field keyField, K key, Map<String, CompoundKey.TypeInfo> fieldTypes) {
        if (!(key instanceof CompoundKey)) {
            throw new IllegalArgumentException("Key must be a CompoundKey!");
        }
        CompoundKey compoundKey = (CompoundKey)key;
        DataMap compoundKeyData = compoundKey.toDataMap(fieldTypes);
        this.putDirect(keyField, DataMap.class, DataMap.class, compoundKeyData, SetMode.IGNORE_NULL);
    }

    public void setValue(RecordDataSchema.Field valueField, V value, Class<V> valueClass) {
        this.putWrapped(valueField, valueClass, (DataTemplate)value, SetMode.IGNORE_NULL);
    }

    public K getPrimitiveKey(Class<K> keyClass) {
        return this.getPrimitiveKey(TypeSpec.forClassMaybeNull(keyClass));
    }

    public K getPrimitiveKey(TypeSpec<K> keyType) {
        StringBuilder sb = new StringBuilder(10);
        DataSchema keySchema = keyType.getSchema();
        RecordDataSchema.Field keyField = new RecordDataSchema.Field(keySchema);
        keyField.setName(KEY_FIELD_NAME, sb);
        if (keySchema.isPrimitive() || keySchema.getType() == DataSchema.Type.ENUM) {
            return (K)this.obtainDirect(keyField, keyType.getType(), GetMode.DEFAULT);
        }
        if (keySchema.getType() == DataSchema.Type.TYPEREF) {
            TyperefDataSchema typerefDataSchema = (TyperefDataSchema)keySchema;
            Class javaClass = CustomTypeUtil.getJavaCustomTypeClassFromSchema((DataSchema)typerefDataSchema);
            if (javaClass == null) {
                return (K)this.obtainDirect(keyField, keyType.getType(), GetMode.DEFAULT);
            }
            return (K)this.obtainDirect(keyField, javaClass, GetMode.DEFAULT);
        }
        throw new IllegalArgumentException("key is not a primitive, typeref, or an enum!");
    }

    public <KK extends RecordTemplate, KP extends RecordTemplate> ComplexResourceKey<KK, KP> getComplexKey(Class<KK> keyKeyClass, Class<KP> keyParamsClass) {
        return this.getComplexKey(ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass));
    }

    public <KK extends RecordTemplate, KP extends RecordTemplate> ComplexResourceKey<KK, KP> getComplexKey(ComplexKeySpec<KK, KP> complexKeyType) {
        StringBuilder sb = new StringBuilder(10);
        RecordDataSchema.Field keyField = new RecordDataSchema.Field(complexKeyType.getKeyType().getSchema());
        keyField.setName(KEY_FIELD_NAME, sb);
        RecordDataSchema.Field paramsField = new RecordDataSchema.Field(complexKeyType.getParamsType().getSchema());
        paramsField.setName(PARAMS_FIELD_NAME, sb);
        RecordTemplate keyKey = (RecordTemplate)this.obtainWrapped(keyField, complexKeyType.getKeyType().getType(), GetMode.DEFAULT);
        RecordTemplate keyParams = (RecordTemplate)this.obtainWrapped(paramsField, complexKeyType.getParamsType().getType(), GetMode.DEFAULT);
        return new ComplexResourceKey<RecordTemplate, RecordTemplate>(keyKey, keyParams);
    }

    public CompoundKey getCompoundKey(Map<String, CompoundKey.TypeInfo> fieldTypes) {
        StringBuilder sb = new StringBuilder(10);
        RecordDataSchema.Field keyField = new RecordDataSchema.Field(KeyValueRecordFactory.COMPOUND_KEY_SCHEMA);
        keyField.setName(KEY_FIELD_NAME, sb);
        DataMap compoundKeyData = (DataMap)this.obtainDirect(keyField, DataMap.class, GetMode.DEFAULT);
        if (compoundKeyData.size() != fieldTypes.size()) {
            throw new IllegalArgumentException("Number of keys must be the same! Number of keys stored in the KeyValueRecordis: " + compoundKeyData.size() + ". Number of keys in fieldTypes is: " + fieldTypes.size());
        }
        return CompoundKey.fromValues(compoundKeyData, fieldTypes);
    }

    public V getValue(Class<V> valueClass) {
        return this.getValue(new TypeSpec<V>(valueClass));
    }

    public V getValue(TypeSpec<V> valueTypeSpec) {
        StringBuilder sb = new StringBuilder(10);
        RecordDataSchema.Field valueField = new RecordDataSchema.Field(valueTypeSpec.getSchema());
        valueField.setName(VALUE_FIELD_NAME, sb);
        return (V)((RecordTemplate)this.obtainWrapped(valueField, valueTypeSpec.getType(), GetMode.DEFAULT));
    }
}

